/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.Convert;
import com.aspose.html.internal.ms.System.Globalization.NumberFormatInfo;
import com.aspose.html.internal.ms.System.IFormatProvider;
import com.aspose.html.internal.ms.core.System.g;
import com.aspose.html.internal.ms.core.System.k;
import com.aspose.html.internal.ms.lang.Extensions;

@Extensions
public final class DoubleExtensions {
    public static final double Epsilon = Double.MIN_VALUE;
    public static final double MaxValue = Double.MAX_VALUE;
    public static final double MinValue = -1.7976931348623157E308;
    public static final double NaN = Double.NaN;
    public static final double NegativeInfinity = Double.NEGATIVE_INFINITY;
    public static final double PositiveInfinity = Double.POSITIVE_INFINITY;

    public static int compareTo(double a2, double b2) {
        if (DoubleExtensions.isPositiveInfinity(a2) && DoubleExtensions.isPositiveInfinity(b2)) {
            return 0;
        }
        if (DoubleExtensions.isNegativeInfinity(a2) && DoubleExtensions.isNegativeInfinity(b2)) {
            return 0;
        }
        if (DoubleExtensions.isNaN(b2)) {
            if (DoubleExtensions.isNaN(a2)) {
                return 0;
            }
            return 1;
        }
        if (DoubleExtensions.isNaN(a2) && !DoubleExtensions.isNaN(b2)) {
            return -1;
        }
        if (a2 > b2) {
            return 1;
        }
        if (a2 < b2) {
            return -1;
        }
        return 0;
    }

    public static int compareTo(double a2, Object b2) {
        if (b2 == null) {
            return 1;
        }
        if (b2.getClass() != Double.class) {
            throw new ArgumentException("Value is not a System.Double");
        }
        double d2 = Convert.toDouble(b2);
        if (DoubleExtensions.isPositiveInfinity(a2) && DoubleExtensions.isPositiveInfinity(d2)) {
            return 0;
        }
        if (DoubleExtensions.isNegativeInfinity(a2) && DoubleExtensions.isNegativeInfinity(d2)) {
            return 0;
        }
        if (DoubleExtensions.isNaN(d2)) {
            return DoubleExtensions.isNaN(a2) ? 0 : 1;
        }
        if (DoubleExtensions.isNaN(a2) && !DoubleExtensions.isNaN(d2)) {
            return -1;
        }
        if (a2 > d2) {
            return 1;
        }
        if (a2 < d2) {
            return -1;
        }
        return 0;
    }

    public static boolean equals(double a2, double b2) {
        return b2 == a2 || DoubleExtensions.isNaN(b2) && DoubleExtensions.isNaN(a2);
    }

    public static boolean equals(double a2, Object b2) {
        if (b2.getClass() != Double.class) {
            return false;
        }
        double d2 = Convert.toDouble(b2);
        return DoubleExtensions.equals(a2, d2);
    }

    public static int getHashCode(double a2) {
        return new Double(a2).hashCode();
    }

    public static int getTypeCode() {
        return 14;
    }

    public static boolean isInfinity(double d2) {
        return d2 == Double.POSITIVE_INFINITY || d2 == Double.NEGATIVE_INFINITY;
    }

    public static boolean isNaN(double d2) {
        return Double.isNaN(d2);
    }

    public static boolean isNegativeInfinity(double value) {
        return value == Double.NEGATIVE_INFINITY;
    }

    public static boolean isPositiveInfinity(double value) {
        return value == Double.POSITIVE_INFINITY;
    }

    public static double parse(String s2) {
        return g.a(s2);
    }

    public static double parse(String s2, int numberStyles) {
        return g.a(s2, numberStyles);
    }

    public static double parse(String s2, IFormatProvider provider) {
        return g.a(s2, provider);
    }

    public static double parse(String s2, int numberStyles, IFormatProvider provider) {
        return g.a(s2, numberStyles, provider);
    }

    public static String toString(double value) {
        return k.a("G", value, (IFormatProvider)NumberFormatInfo.getCurrentInfo());
    }

    public static String toString(double value, IFormatProvider provider) {
        return k.a(null, value, (IFormatProvider)NumberFormatInfo.getInstance(provider));
    }

    public static String toString(double value, String pattern) {
        return k.a(pattern, value, (IFormatProvider)NumberFormatInfo.getCurrentInfo());
    }

    public static String toString(double value, String pattern, IFormatProvider provider) {
        return k.a(pattern, value, (IFormatProvider)NumberFormatInfo.getInstance(provider));
    }

    public static boolean tryParse(String source, int numberStyles, IFormatProvider provider, double[] referenceToValue) {
        try {
            referenceToValue[0] = DoubleExtensions.parse(source, numberStyles, provider);
            return true;
        }
        catch (Exception exception) {
            referenceToValue[0] = 0.0;
            return false;
        }
    }

    public static boolean tryParse(String source, double[] referenceToValue) {
        return DoubleExtensions.tryParse(source, 231, NumberFormatInfo.getCurrentInfo(), referenceToValue);
    }
}

