/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Drawing;

import com.aspose.html.drawing.Color;
import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.internal.ms.System.Array;
import com.aspose.html.internal.ms.System.BitConverter;
import com.aspose.html.internal.ms.System.Drawing.Graphics;
import com.aspose.html.internal.ms.System.Drawing.Image;
import com.aspose.html.internal.ms.System.Drawing.Imaging.BitmapData;
import com.aspose.html.internal.ms.System.Drawing.Imaging.Encoder;
import com.aspose.html.internal.ms.System.Drawing.Imaging.EncoderParameter;
import com.aspose.html.internal.ms.System.Drawing.Imaging.EncoderParameters;
import com.aspose.html.internal.ms.System.Drawing.Imaging.ImageFormat;
import com.aspose.html.internal.ms.System.Drawing.Imaging.PixelFormat;
import com.aspose.html.internal.ms.System.Drawing.Imaging.PlainImage;
import com.aspose.html.internal.ms.System.Drawing.Rectangle;
import com.aspose.html.internal.ms.System.Drawing.RectangleF;
import com.aspose.html.internal.ms.System.Drawing.Size;
import com.aspose.html.internal.ms.System.IO.FileNotFoundException;
import com.aspose.html.internal.ms.System.IO.FileStream;
import com.aspose.html.internal.ms.System.IO.IOException;
import com.aspose.html.internal.ms.System.IO.Stream;
import com.aspose.html.internal.ms.System.InvalidOperationException;
import com.aspose.html.internal.ms.System.NotImplementedException;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.Type;
import com.aspose.html.internal.ms.core.System.Drawing.GraphicsUtils;
import com.aspose.html.internal.ms.core.System.Drawing.Imaging.ImageCodec;
import com.aspose.html.internal.ms.core.System.Drawing.Imaging.c;
import com.aspose.html.internal.ms.core.System.Drawing.Imaging.d;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.PngMetadata;
import com.aspose.html.internal.ms.core.drawing.b.a;
import com.aspose.html.internal.ms.core.drawing.d.b;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.RGBImageFilter;
import java.awt.image.Raster;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.io.InputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;

public final class Bitmap
extends Image {
    protected int _userPixelFormat = 0;
    private ColorModel a = null;
    private b b = new b(this);

    Bitmap(PlainImage orig) {
        super.initialize(orig, false);
    }

    public Bitmap(int width, int height, Graphics g2) {
        this(width, height, 2498570);
        if (g2 == null || width <= 0 || height <= 0) {
            throw new ArgumentException();
        }
        this.getCurrentImage().setHorizontalResolution(g2.getDpiX());
        this.getCurrentImage().setVerticalResolution(g2.getDpiY());
    }

    public Bitmap(Image original) {
        this(original, original.getSize());
    }

    public Bitmap(Image orig, Size newSize) {
        this(orig, newSize.getWidth(), newSize.getHeight());
    }

    public Bitmap(Image orig, int width, int height) {
        super(Bitmap.b(orig, width, height), ImageFormat.getMemoryBmp());
    }

    Bitmap(java.awt.Image nativeObject, ImageFormat format) {
        super(nativeObject, format);
    }

    private Bitmap(java.awt.Image nativeObject, ImageFormat format, int pixFormat) {
        this(nativeObject, format);
        if (pixFormat != this.getPixelFormat()) {
            throw new NotImplementedException("Converting PixelFormat is not implemented yet.");
        }
    }

    public Bitmap(int width, int height) {
        this(width, height, 2498570);
    }

    public Bitmap(int width, int height, int format) {
        super(Bitmap.asBufferedImage(width, height, format), ImageFormat.getMemoryBmp());
        this._userPixelFormat = format;
        int[] nArray = PixelFormat.getMaskByPixelFormat(format);
        this.a = new DirectColorModel(Image.getPixelFormatSize(format), nArray[0], nArray.length > 1 ? nArray[1] : 0, nArray.length > 2 ? nArray[2] : 0, nArray.length > 3 ? nArray[3] : 0);
    }

    public Bitmap(Stream stream) {
        this(Bitmap.a(stream), false, null);
    }

    public Bitmap(String filename) {
        this(Bitmap.a(filename), false, null);
    }

    public Bitmap(Stream stream, boolean useIcm) {
        this(Bitmap.a(stream), useIcm, null);
    }

    public Bitmap(String filename, boolean useIcm) {
        this(Bitmap.a(filename), useIcm, null);
    }

    private static String a(String string) {
        if (string == null) {
            throw new ArgumentNullException("Value of 'filename' cannot be null");
        }
        return string;
    }

    private static Stream a(Stream stream) {
        if (stream == null) {
            throw new ArgumentException("Value of null is not valid for 'stream'");
        }
        stream.setPosition(0L);
        return stream;
    }

    static Bitmap a(Bitmap bitmap) {
        com.aspose.html.internal.ms.core.drawing.c.b b2 = new com.aspose.html.internal.ms.core.drawing.c.b(new AffineTransform(), 2);
        BufferedImage bufferedImage = b2.a(Bitmap.toJava(bitmap), null);
        return new Bitmap(bufferedImage, bitmap.getRawFormat());
    }

    private static BufferedImage a(int n2, int n3, int n4) {
        DirectColorModel directColorModel = null;
        int[] nArray = null;
        if (Image.isAlphaPixelFormat(n4)) {
            directColorModel = new DirectColorModel(32, 0xFF0000, 65280, 255, -16777216);
            nArray = new int[]{directColorModel.getRedMask(), directColorModel.getGreenMask(), directColorModel.getBlueMask(), directColorModel.getAlphaMask()};
        } else {
            directColorModel = new DirectColorModel(32, 0xFF0000, 65280, 255, -16777216);
            nArray = new int[]{directColorModel.getRedMask(), directColorModel.getGreenMask(), directColorModel.getBlueMask(), directColorModel.getAlphaMask()};
        }
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = new SinglePixelPackedSampleModel(3, n2, n3, nArray);
        DataBufferInt dataBufferInt = new DataBufferInt(new int[n2 * n3], n2 * n3, 0);
        WritableRaster writableRaster = Raster.createWritableRaster(singlePixelPackedSampleModel, dataBufferInt, new Point(0, 0));
        BufferedImage bufferedImage = new BufferedImage(directColorModel, writableRaster, Image.isPAlphaPixelFormat(n4), null);
        return bufferedImage;
    }

    public static BufferedImage asBufferedImage(int width, int height, int format) {
        return com.aspose.html.internal.ms.core.drawing.a.c.a(width, height, format);
    }

    Bitmap(Stream stream, boolean useIcm, ImageFormat format) {
        this.a(new d(stream), format);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Bitmap(String filename, boolean useIcm, ImageFormat format) {
        FileStream fileStream = null;
        try {
            fileStream = new FileStream(filename, 3, 1);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ArgumentException("Parameter value is not valid <" + filename + ">");
        }
        try {
            this.a(new d(fileStream), format);
        }
        finally {
            if (fileStream != null) {
                fileStream.close();
            }
        }
    }

    public Bitmap(Type type, String resource) {
        Class clazz = type.getJavaClass();
        if (resource == null) {
            throw new ArgumentException("Resource '" + resource + "' could not be found in class '" + clazz.toString() + "'");
        }
        InputStream inputStream = clazz.getResourceAsStream(resource);
        InputStream inputStream2 = clazz.getResourceAsStream(resource);
        if (inputStream == null) {
            throw new ArgumentException("Resource '" + resource + "' could not be found in class '" + clazz.toString() + "'");
        }
        this.a(new d(Stream.fromJava(inputStream)), null);
    }

    private void a(MemoryCacheImageInputStream memoryCacheImageInputStream, ImageFormat imageFormat) {
        ImageCodec imageCodec = null;
        imageCodec = imageFormat == null ? ImageCodec.createReader(memoryCacheImageInputStream) : ImageCodec.createReader(imageFormat);
        if (imageCodec == null && imageFormat == null) {
            throw new ArgumentException("Error loading file: Unsupported file format", "input");
        }
        if (imageCodec == null) {
            throw new ArgumentNullException("ImageCodec was not found for format: " + imageFormat.toString());
        }
        try {
            imageCodec.setNativeStream(memoryCacheImageInputStream);
            if (imageCodec.getImageFormat().equals(ImageFormat.getIcon()) && imageFormat == null) {
                PlainImage plainImage;
                PlainImage plainImage2 = plainImage = imageCodec.readPlainImage();
                while (plainImage != null) {
                    plainImage2 = plainImage;
                    plainImage = imageCodec.readNextPlainImage();
                }
                this.a(plainImage2);
                super.initialize(plainImage2, false);
            } else {
                PlainImage plainImage = imageCodec.readPlainImage();
                this.a(plainImage);
                super.initialize(plainImage, false);
                plainImage = imageCodec.readNextPlainImage();
                while (plainImage != null) {
                    super.initialize(plainImage, true);
                    plainImage = imageCodec.readNextPlainImage();
                }
            }
            this._flags |= 0x12000;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            if (imageCodec != null) {
                imageCodec.dispose();
            }
        }
    }

    private void a(PlainImage plainImage) {
        if (plainImage != null && plainImage.getProperty("pixelFormat") != null) {
            this._userPixelFormat = (Integer)plainImage.getProperty("pixelFormat");
        }
    }

    private boolean a(int n2, int n3) {
        return this.a(n2, n3, this.getWidth(), this.getHeight());
    }

    private boolean a(int n2, int n3, int n4, int n5) {
        return n2 >= 0 && n2 < n4 && n3 >= 0 && n3 < n5;
    }

    private void a(ImageOutputStream imageOutputStream, ImageCodec imageCodec, ImageFormat imageFormat, PlainImage plainImage) {
        int n2 = this.getPixelFormat();
        ColorModel colorModel = ((BufferedImage)this.getCurrentImage().getNativeImage()).getColorModel();
        WritableRaster writableRaster = ((BufferedImage)this.getCurrentImage().getNativeImage()).getRaster();
        DataBuffer dataBuffer = writableRaster.getDataBuffer();
        DirectColorModel directColorModel = (DirectColorModel)colorModel;
        BufferedImage bufferedImage = null;
        Object var11_11 = null;
        int[] nArray = null;
        directColorModel = new DirectColorModel(32, 0xFF0000, 65280, 255);
        nArray = new int[]{directColorModel.getRedMask(), directColorModel.getGreenMask(), directColorModel.getBlueMask()};
        PixelInterleavedSampleModel pixelInterleavedSampleModel = new PixelInterleavedSampleModel(dataBuffer.getDataType(), this.getWidth(), this.getHeight(), 32, 32 * this.getWidth(), new int[]{16, 8, 0});
        bufferedImage = new BufferedImage(directColorModel, Raster.createBandedRaster(dataBuffer, this.getWidth(), this.getHeight(), 32 * this.getWidth(), new int[]{0, 1, 2}, new int[]{16, 8, 0}, null), Image.isPAlphaPixelFormat(n2), null);
        plainImage = new PlainImage(bufferedImage, plainImage.getThumbnails(), imageFormat, plainImage.getHorizontalResolution(), plainImage.getVerticalResolution(), plainImage.getDimension());
        plainImage.setNativeMetadata(plainImage.getNativeMetadata());
        imageCodec.setNativeStream(imageOutputStream);
        imageCodec.writePlainImage(plainImage);
    }

    @Override
    protected void internalSave(ImageOutputStream output, ImageCodec ic2, EncoderParameters encoderParams, Stream originalStream) {
        PlainImage plainImage = this.getCurrentImage();
        plainImage.getNativeImage().flush();
        this.setPlainImageProperties(encoderParams, plainImage);
        if (ic2.getImageFormat().equals(ImageFormat.getGif()) || ic2.getImageFormat().equals(ImageFormat.getTiff()) || ic2.getImageFormat().equals(ImageFormat.getJpeg()) || ic2.getImageFormat().equals(ImageFormat.getPng())) {
            ic2.setNativeStream(originalStream);
        } else {
            ic2.setNativeStream(output);
        }
        if (ic2.getImageFormat().equals(ImageFormat.getTiff())) {
            if (this.isMultiframe) {
                ic2.prepareWriteSequence();
                ic2.writeToSequence(plainImage);
            } else {
                EncoderParameters encoderParameters = new EncoderParameters(1);
                encoderParameters.getParam()[0] = new EncoderParameter(Encoder.Compression, 2);
                this.setPlainImageProperties(encoderParameters, plainImage);
                ic2.writePlainImage(plainImage);
            }
        } else if (ic2.getImageFormat().equals(ImageFormat.getGif())) {
            if (this.isMultiframe) {
                ic2.prepareWriteSequence();
                ic2.writeToSequence(plainImage);
            } else {
                ic2.writePlainImage(this.getNativeObject());
            }
        } else {
            ic2.writePlainImage(this.getNativeObject());
        }
    }

    private static java.awt.Image a(Image image, int n2, int n3) {
        if (image == null) {
            throw new ArgumentNullException("original");
        }
        java.awt.Image image2 = null;
        BufferedImage bufferedImage = null;
        if (image.getWidth() == n2 && image.getHeight() == n3) {
            image2 = image.getCurrentImage().getNativeImage();
            bufferedImage = com.aspose.html.internal.ms.core.drawing.a.c.a(n2, n3, 2498570);
        } else {
            image2 = image.getCurrentImage().getNativeImage().getScaledInstance(n2, n3, 4);
            bufferedImage = com.aspose.html.internal.ms.core.drawing.a.c.a(image2.getWidth(null), image2.getHeight(null), 2498570);
        }
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image2, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    private static java.awt.Image b(Image image, int n2, int n3) {
        if (image == null) {
            throw new ArgumentNullException("original");
        }
        java.awt.Image image2 = null;
        BufferedImage bufferedImage = null;
        Graphics2D graphics2D = null;
        double d2 = (double)n2 / (double)image.getWidth();
        double d3 = (double)n3 / (double)image.getHeight();
        boolean bl2 = image.getWidth() != n2 || image.getHeight() != n3;
        boolean bl3 = Image.isIndexedPixelFormat(image.getPixelFormat());
        if (bl2 && !bl3) {
            image2 = image.getCurrentImage().getNativeImage().getScaledInstance(n2, n3, 4);
            bufferedImage = com.aspose.html.internal.ms.core.drawing.a.c.a(image2.getWidth(null), image2.getHeight(null), 2498570);
        } else {
            image2 = image.getCurrentImage().getNativeImage();
            bufferedImage = com.aspose.html.internal.ms.core.drawing.a.c.a(image.getWidth(), image.getHeight(), 2498570);
        }
        graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image2, 0, 0, null);
        graphics2D.dispose();
        if (bl2 && bl3) {
            com.aspose.html.internal.ms.core.drawing.c.b b2 = new com.aspose.html.internal.ms.core.drawing.c.b(AffineTransform.getScaleInstance(d2, d3), 2);
            BufferedImage bufferedImage2 = b2.a(bufferedImage, null);
            if (d2 < 1.0 || d3 < 1.0) {
                bufferedImage2 = (BufferedImage)GraphicsUtils.smoothSimple(new Bitmap(bufferedImage2, ImageFormat.getMemoryBmp())).getCurrentImage().getNativeImage();
            }
            return bufferedImage2;
        }
        return bufferedImage;
    }

    static boolean a(StreamingState streamingState) {
        if (streamingState != null) {
            return streamingState.e >= 0 || streamingState.c < streamingState.a.getY() + streamingState.a.getHeight() && streamingState.b < streamingState.a.getX() + streamingState.a.getWidth();
        }
        return false;
    }

    int b(StreamingState streamingState) {
        int n2 = 0;
        int n3 = 0;
        if (streamingState == null) {
            return Color.fromArgb(255, 255, 0, 255).toArgb();
        }
        if (streamingState.h == 1) {
            n2 = streamingState.j[n3] & 0xFF;
            ++n3;
            ++streamingState.b;
            if (streamingState.b >= streamingState.a.getX() + streamingState.a.getWidth()) {
                streamingState.b = streamingState.a.getX();
                ++streamingState.c;
                int n4 = streamingState.c * streamingState.i.getStride() + streamingState.b;
                byte[] byArray = (byte[])streamingState.i.getScan0().toPointer().getData();
                if (byArray.length > n4) {
                    streamingState.j = new byte[byArray.length - n4];
                    Array.copy(Array.boxing(byArray), n4, Array.boxing(streamingState.j), 0, byArray.length - n4);
                }
                n3 = 0;
            }
        } else if (streamingState.h > 0) {
            int n5;
            if (streamingState.e < 0) {
                streamingState.d = streamingState.j[n3];
                ++n3;
                streamingState.e = 0;
                if (streamingState.b == streamingState.a.getX() && (n5 = streamingState.b & streamingState.h - 1) != 0) {
                    streamingState.d = (short)(streamingState.d << n5 * streamingState.g);
                    streamingState.e = n5;
                }
            }
            streamingState.d = (short)(streamingState.d << streamingState.g);
            n2 = streamingState.d >> 8 & streamingState.f;
            ++streamingState.b;
            ++streamingState.e;
            if (streamingState.e >= streamingState.h) {
                streamingState.e = -1;
            }
            if (streamingState.b >= streamingState.a.getX() + streamingState.a.getWidth()) {
                streamingState.b = streamingState.a.getX();
                ++streamingState.c;
                n5 = streamingState.c * streamingState.i.getWidth() + streamingState.b * Bitmap.a(streamingState.i.getPixelFormat()) / 8;
                byte[] byArray = (byte[])streamingState.i.getScan0().toPointer().getData();
                streamingState.j = new byte[byArray.length - n5];
                Array.copy(Array.boxing(byArray), n5, Array.boxing(streamingState.j), 0, byArray.length - n5);
                n3 = 0;
                streamingState.e = -1;
            }
        } else {
            n2 = streamingState.h == -4 ? BitConverter.toInt32(streamingState.j, 0) : streamingState.j[0] | streamingState.j[1] << 8 | streamingState.j[2] << 16 | 0xFF000000;
            n3 -= streamingState.h;
            ++streamingState.b;
            if (streamingState.b >= streamingState.a.getX() + streamingState.a.getWidth()) {
                streamingState.b = streamingState.a.getX();
                ++streamingState.c;
                int n6 = streamingState.c * streamingState.i.getWidth() + streamingState.b * -streamingState.h;
                byte[] byArray = (byte[])streamingState.i.getScan0().toPointer().getData();
                streamingState.j = new byte[byArray.length - n6];
                Array.copy(Array.boxing(byArray), n6, Array.boxing(streamingState.j), 0, byArray.length - n6);
                n3 = 0;
            }
        }
        return n2;
    }

    boolean a(StreamingState streamingState, BitmapData bitmapData, int n2, int n3, int n4, int n5) {
        if (streamingState == null || bitmapData == null || bitmapData.getScan0() == null) {
            throw new ArgumentException();
        }
        if (n2 < 0 || n3 < 0 || n2 + n4 > bitmapData.getWidth() || n3 + n5 > bitmapData.getHeight()) {
            throw new ArgumentException();
        }
        streamingState.a.setX(n2);
        streamingState.a.setY(n3);
        streamingState.a.setWidth(n4);
        streamingState.a.setHeight(n5);
        streamingState.b = n2;
        streamingState.c = n3;
        streamingState.e = -1;
        byte[] byArray = (byte[])bitmapData.getScan0().toPointer().getData();
        int n6 = n3 * bitmapData.getStride();
        switch (bitmapData.getPixelFormat()) {
            case 196865: {
                streamingState.f = 1;
                streamingState.g = 1;
                streamingState.h = 8;
                n6 += n2 >> 3;
                break;
            }
            case 197634: {
                streamingState.f = 15;
                streamingState.g = 4;
                streamingState.h = 2;
                n6 += n2 >> 1;
                break;
            }
            case 198659: {
                streamingState.f = 255;
                streamingState.g = 8;
                streamingState.h = 1;
                n6 += n2;
                break;
            }
            case 137224: {
                if ((bitmapData.getReserved() & 0x800) != 0) {
                    streamingState.h = -3;
                    n6 += n2 * 3 >> 3;
                    break;
                }
            }
            default: {
                streamingState.h = -(Bitmap.a(bitmapData.getPixelFormat()) >> 3);
                n6 -= n2 * streamingState.h;
            }
        }
        streamingState.j = new byte[byArray.length - n6];
        Array.copy(Array.boxing(byArray), n6, Array.boxing(streamingState.j), 0, byArray.length - n6);
        streamingState.i = bitmapData;
        return true;
    }

    private static int a(int n2) {
        return Image.getPixelFormatSize(n2);
    }

    protected Color getPixelOld(int x2, int y2) {
        int n2 = this.getNativeObject_Bitmap_New().getRGB(x2, y2);
        return Color.fromArgb(n2);
    }

    public Color getPixel(int x2, int y2) {
        if (!this.a(x2, y2)) {
            throw new ArgumentOutOfRangeException("x/y (" + x2 + ", " + y2 + ") must be non-negative and less than width/height(" + this.getWidth() + "," + this.getHeight() + ")");
        }
        if (this.a()) {
            throw new InvalidOperationException("Bitmap region is already locked");
        }
        int n2 = this.getPixelFormat();
        if (n2 == 397319) {
            int n3 = ((short[])this.getNativeObject_Bitmap_New().getRaster().getDataElements(x2, y2, null))[0] & 0xFFFF;
            return Color.fromArgb(com.aspose.html.internal.ms.core.System.Drawing.b.b(n3));
        }
        if (n2 == 135173) {
            int n4 = ((short[])this.getNativeObject_Bitmap_New().getRaster().getDataElements(x2, y2, null))[0] & 0xFFFF;
            return Color.fromArgb(com.aspose.html.internal.ms.core.System.Drawing.b.d(n4));
        }
        if (n2 == 135174) {
            int n5 = ((short[])this.getNativeObject_Bitmap_New().getRaster().getDataElements(x2, y2, null))[0] & 0xFFFF;
            return Color.fromArgb(com.aspose.html.internal.ms.core.System.Drawing.b.f(n5));
        }
        if (n2 == 925707) {
            BitmapData bitmapData = this.b(x2, y2, this.getPixelFormat());
            byte[] byArray = (byte[])bitmapData.getScan0().toPointer().getData();
            int n6 = byArray[3] & 0xFF;
            float f2 = 255.0f / (float)n6;
            return Color.fromArgb(n6 << 24 | (int)(f2 * (float)(byArray[2] & 0xFF)) << 16 | (int)(f2 * (float)(byArray[1] & 0xFF)) << 8 | (int)(f2 * (float)(byArray[0] & 0xFF)));
        }
        if (n2 == 139273) {
            Color color = this.getPixelOld(x2, y2);
            return Color.fromArgb((int)(0xFFFFFFFFFF000000L | color.a()));
        }
        if (Image.isIndexedPixelFormat(n2) && n2 == 198659) {
            return this.getPixelOld(x2, y2);
        }
        if (n2 == 197634) {
            Color color = this.getPixelOld(x2, y2);
            return Color.fromArgb((int)(0xFFFFFFFFFF000000L | color.a()));
        }
        return this.getPixelOld(x2, y2);
    }

    public void setPixel(int x2, int y2, Color color) {
        if (Image.isIndexedPixelFormat(this.getPixelFormat())) {
            throw new InvalidOperationException("SetPixel is not supported for images with indexed pixel formats.");
        }
        if (!this.a(x2, y2)) {
            throw new ArgumentOutOfRangeException("x/y must be non-negative and less than width/height");
        }
        if (this.a()) {
            throw new InvalidOperationException("Bitmap region is already locked");
        }
        int n2 = this.getPixelFormat();
        BufferedImage bufferedImage = this.getNativeObject_Bitmap_New();
        int n3 = color.toArgb();
        if (bufferedImage.getType() == 1) {
            bufferedImage.getRaster().setDataElements(x2, y2, new int[]{n3});
        } else if (n2 == 397319) {
            bufferedImage.getRaster().setDataElements(x2, y2, new short[]{(short)com.aspose.html.internal.ms.core.System.Drawing.b.a(n3)});
        } else if (n2 == 135173) {
            bufferedImage.getRaster().setDataElements(x2, y2, new short[]{(short)com.aspose.html.internal.ms.core.System.Drawing.b.c(n3)});
        } else if (n2 == 135174) {
            bufferedImage.getRaster().setDataElements(x2, y2, new short[]{(short)com.aspose.html.internal.ms.core.System.Drawing.b.e(n3)});
        } else {
            bufferedImage.setRGB(x2, y2, n3);
        }
    }

    @Override
    public Object deepClone() {
        return this.deepClone(new Rectangle(0, 0, this.getWidth(), this.getHeight()));
    }

    public Bitmap deepClone(Rectangle rect) {
        return this.deepClone(rect, this.getPixelFormat());
    }

    public Bitmap deepClone(Rectangle rect, int pixFormat) {
        return this.deepClone(new RectangleF(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight()), pixFormat);
    }

    public Bitmap deepClone(RectangleF rect, int pixFormat) {
        Image image = null;
        for (PlainImage plainImage : this.getNativeObject()) {
            plainImage = this.a(rect, pixFormat, plainImage);
            if (image == null) {
                image = new Bitmap(plainImage);
                continue;
            }
            image.initialize(plainImage, true);
        }
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PlainImage a(RectangleF rectangleF, int n2, PlainImage plainImage) {
        Object object;
        BufferedImage bufferedImage = (BufferedImage)plainImage.getNativeImage();
        BufferedImage bufferedImage2 = null;
        if (this.getPixelFormat() == n2) {
            bufferedImage2 = c.a(bufferedImage, (int)rectangleF.getX(), (int)rectangleF.getY(), (int)rectangleF.getWidth(), (int)rectangleF.getHeight());
        } else {
            bufferedImage2 = com.aspose.html.internal.ms.core.drawing.a.c.a((int)rectangleF.getWidth(), (int)rectangleF.getHeight(), n2);
            object = bufferedImage2.createGraphics();
            try {
                ((java.awt.Graphics)object).drawImage(bufferedImage, -((int)rectangleF.getX()), -((int)rectangleF.getY()), null);
            }
            finally {
                ((java.awt.Graphics)object).dispose();
            }
        }
        object = plainImage.deepClone(false);
        ((PlainImage)object).setNativeImage(bufferedImage2);
        return object;
    }

    public synchronized BitmapData lockBits(Rectangle rect, int flags, int format) {
        return this.lockBits(rect, flags, format, false);
    }

    protected synchronized BitmapData lockBits(Rectangle rect, int flags, int format, boolean emptyData) {
        return this.b.a(rect, flags, format, emptyData);
    }

    private BitmapData b(int n2, int n3, int n4) {
        BitmapData bitmapData = this.lockBits(new Rectangle(n2, n3, 1, 1), 1, n4);
        this.unlockBits(bitmapData);
        return bitmapData;
    }

    protected synchronized BitmapData lockBits(Rectangle rect, int flags, int format, BitmapData bitmapData) {
        throw new NotImplementedException();
    }

    public void makeTransparent() {
        Color color = Color.fromKnownColor(95);
        if (this.getWidth() > 0 && this.getHeight() > 0) {
            color = this.getPixel(0, this.getHeight() - 1).Clone();
        }
        this.a(color, false);
    }

    public void makeTransparent(Color transparentColor) {
        this.a(transparentColor, true);
    }

    private void a(Color color, boolean bl2) {
        Bitmap bitmap = new Bitmap(this.getWidth(), this.getHeight(), 2498570);
        BufferedImage bufferedImage = this.getNativeObject_Bitmap_New();
        BufferedImage bufferedImage2 = bitmap.getNativeObject_Bitmap_New();
        int n2 = bufferedImage.getWidth() + bufferedImage.getMinX();
        int n3 = bufferedImage.getHeight() + bufferedImage.getMinY();
        for (int i2 = bufferedImage.getMinY(); i2 < n3; ++i2) {
            for (int i3 = bufferedImage.getMinX(); i3 < n2; ++i3) {
                int n4 = bufferedImage.getRGB(i3, i2);
                if (!Image.isAlphaPixelFormat(this.getPixelFormat())) {
                    n4 |= 0xFF000000;
                }
                if (n4 == color.toArgb() && (color.getA() != 0 || bl2)) continue;
                bufferedImage2.setRGB(i3, i2, n4);
            }
        }
        this.initialize(bitmap.getCurrentImage(), false);
    }

    private boolean a() {
        return this.b.a();
    }

    public synchronized void unlockBits(BitmapData bitmapData) {
        this.b.a(bitmapData);
    }

    public BufferedImage getNativeObject_Bitmap_New() {
        return (BufferedImage)this.getNativeObject().getCurrentImage().getNativeImage();
    }

    @Override
    protected java.awt.Image[] cloneNativeObjects(java.awt.Image[] src) {
        if (src == null) {
            return null;
        }
        java.awt.Image[] imageArray = new java.awt.Image[src.length];
        for (int i2 = 0; i2 < imageArray.length; ++i2) {
            BufferedImage bufferedImage;
            java.awt.Image image = src[i2];
            BufferedImage bufferedImage2 = bufferedImage = image instanceof BufferedImage ? (BufferedImage)image : null;
            if (bufferedImage == null) {
                throw new ArgumentNullException("src", StringExtensions.format("Unsupported image type '{0}'", image.toString()));
            }
            imageArray[i2] = new BufferedImage(bufferedImage.getColorModel(), bufferedImage.copyData(null), bufferedImage.isAlphaPremultiplied(), null);
        }
        return imageArray;
    }

    @Override
    protected int getInternalPixelFormat() {
        Object object;
        BufferedImage bufferedImage = (BufferedImage)this.getCurrentImage().getNativeImage();
        ColorModel colorModel = bufferedImage.getColorModel();
        int n2 = colorModel.getPixelSize();
        if (colorModel instanceof IndexColorModel) {
            if (this.getRawFormat().equals(ImageFormat.getGif()) && n2 < 8) {
                n2 = 8;
            } else if (this.getRawFormat().equals(ImageFormat.getPng())) {
                PlainImage plainImage = this.getCurrentImage();
                if (plainImage.getNativeMetadata() instanceof PngMetadata) {
                    object = (PngMetadata)plainImage.getNativeMetadata();
                    int n3 = ((PngMetadata)object).getIHDR().getBitspc();
                    if (n3 == 1) {
                        return 196865;
                    }
                    if (n3 == 4) {
                        return 197634;
                    }
                    if (n3 == 8) {
                        return 198659;
                    }
                }
            } else if (n2 == 8) {
                return 198659;
            }
        }
        if (colorModel.getColorSpace() instanceof a) {
            return 8207;
        }
        int n4 = Image.getInternalPixelFormat(this.getNativeObject_Bitmap_New().getType(), n2);
        if (Image.getPixelFormatSize(this._userPixelFormat) > 32) {
            return this._userPixelFormat;
        }
        if (this._userPixelFormat == 397319) {
            return this._userPixelFormat;
        }
        if (this._userPixelFormat == 139273) {
            return this._userPixelFormat;
        }
        if (n4 == 0) {
            if (this.getRawFormat().equals(ImageFormat.getPng())) {
                return 2498570;
            }
            if (colorModel.getColorSpace().isCS_sRGB()) {
                object = colorModel.getComponentSize();
                if (colorModel.getNumComponents() == 3) {
                    return object[0] == 16 ? 1060876 : 137224;
                }
                if (colorModel.getNumComponents() == 4) {
                    if (object[0] == 16) {
                        return colorModel.isAlphaPremultiplied() ? 1851406 : 3424269;
                    }
                    return colorModel.isAlphaPremultiplied() ? 925707 : 2498570;
                }
                return n4;
            }
            if (6 == colorModel.getColorSpace().getType() && colorModel.getPixelSize() == 16 && colorModel.getNumComponents() == 2) {
                return 0x101004;
            }
            return n4;
        }
        return n4;
    }

    public static BufferedImage toJava(Bitmap btm) {
        if (btm == null) {
            return null;
        }
        return btm.getNativeObject_Bitmap_New();
    }

    public static Bitmap fromJava(BufferedImage nativeImage) {
        if (nativeImage == null) {
            return null;
        }
        return new Bitmap(nativeImage, ImageFormat.getBmp());
    }

    class StreamingState {
        Rectangle a = new Rectangle();
        int b;
        int c;
        short d;
        int e;
        int f;
        int g;
        int h;
        BitmapData i;
        byte[] j;

        StreamingState() {
        }
    }

    class TransFilter
    extends RGBImageFilter {
        private Color b = Color.fromKnownColor(27);
        private boolean c = true;

        public TransFilter(Color transparentColor, boolean resetTransparent) {
            this.b = transparentColor;
            this.c = resetTransparent;
            this.canFilterIndexColorModel = true;
        }

        @Override
        public final int filterRGB(int x2, int y2, int rgb) {
            if (rgb == this.b.toArgb() && (this.b.getA() != 0 || this.c)) {
                return 0;
            }
            return rgb;
        }
    }
}

