/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Drawing.Printing;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.Array;
import com.aspose.html.internal.ms.System.Collections.ArrayList;
import com.aspose.html.internal.ms.System.Collections.ICollection;
import com.aspose.html.internal.ms.System.Collections.IEnumerable;
import com.aspose.html.internal.ms.System.Collections.IEnumerator;
import com.aspose.html.internal.ms.System.Collections.Specialized.NameValueCollection;
import com.aspose.html.internal.ms.System.ComponentModel.EditorBrowsableAttribute;
import com.aspose.html.internal.ms.System.ComponentModel.InvalidEnumArgumentException;
import com.aspose.html.internal.ms.System.Drawing.Graphics;
import com.aspose.html.internal.ms.System.Drawing.Image;
import com.aspose.html.internal.ms.System.Drawing.Imaging.ImageFormat;
import com.aspose.html.internal.ms.System.Drawing.Printing.DefaultPageSettingsBuilder;
import com.aspose.html.internal.ms.System.Drawing.Printing.InvalidPrinterException;
import com.aspose.html.internal.ms.System.Drawing.Printing.PageSettings;
import com.aspose.html.internal.ms.System.Drawing.Printing.PaperSize;
import com.aspose.html.internal.ms.System.Drawing.Printing.PaperSource;
import com.aspose.html.internal.ms.System.Drawing.Printing.PrinterResolution;
import com.aspose.html.internal.ms.System.ICloneable;
import com.aspose.html.internal.ms.System.NotImplementedException;
import com.aspose.html.internal.ms.System.SerializableAttribute;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.core.System.Drawing.Printing.GraphicsContext;
import com.aspose.html.internal.ms.core.System.Drawing.Printing.Loaders.PrinterSettingsLoader;
import com.aspose.html.internal.ms.core.System.Drawing.Printing.PrinterUtils;
import com.aspose.html.internal.ms.lang.ReservedForInternalUse;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;

@SerializableAttribute
public class PrinterSettings
implements ICloneable,
Cloneable {
    private String a;
    private String b;
    private short c;
    private int d;
    private int e;
    private int f;
    private int g;
    private boolean h;
    private int i;
    private int j;
    private boolean k;
    private boolean l;
    private int m;
    private boolean n;
    private PrinterResolutionCollection o;
    private PaperSizeCollection p;
    private PaperSourceCollection q;
    private PageSettings r;
    private int s;
    private boolean t;
    private NameValueCollection u;
    private PrintService v = PrintServiceLookup.lookupDefaultPrintService();

    public PrinterSettings() {
        if (this.v == null) {
            PrintService[] printServiceArray = PrintServiceLookup.lookupPrintServices(null, null);
            if (printServiceArray == null || printServiceArray.length == 0) {
                throw new InvalidPrinterException("Printers are not found. Set default printer.");
            }
            this.v = printServiceArray[0];
        }
        this.a = this.v.getName();
        if (this.a == null) {
            throw new InvalidPrinterException("Printer's name is null");
        }
        this.b();
        PrinterSettingsLoader.getLoader(this.v).loadPrinterSettings(this);
        this.r = DefaultPageSettingsBuilder.loadDefaultPageSettingsBuilder(this, this.v).buildDefaultPageSettings().getPageSettings();
    }

    private void b() {
        this.o = null;
        this.p = null;
        this.q = null;
        this.r = null;
        this.e = 1;
        this.f = 1;
        this.d = 9999;
        this.g = 9999;
        this.c = 1;
        this.h = true;
    }

    public boolean canDuplex() {
        return this.k;
    }

    public void setCan_duplex(boolean can_duplex) {
        this.k = can_duplex;
    }

    public boolean getCollate() {
        return this.h;
    }

    public void setCollate(boolean value) {
        this.h = value;
    }

    public short getCopies() {
        return this.c;
    }

    public void setCopies(short value) {
        if (value < 0) {
            throw new ArgumentException("The value of the Copies property is less than zero.");
        }
        this.c = value;
    }

    public PageSettings getDefaultPageSettings() {
        return this.r;
    }

    public void setPaperSizes(PaperSizeCollection paperSizeCollection) {
        this.p = paperSizeCollection;
    }

    PrinterResolution a() {
        if (this.o != null && this.o.size() > 0) {
            return this.o.get_Item(0);
        }
        return new PrinterResolution(200, 200, -3);
    }

    public void setPrinterResolutions(PrinterResolutionCollection resolutions) {
        this.o = resolutions;
    }

    public int getDuplex() {
        return this.s;
    }

    public void setDuplex(int value) {
        this.s = value;
    }

    public int getFromPage() {
        return this.f;
    }

    public void setFromPage(int value) {
        if (value < 0) {
            throw new ArgumentException("The value of the FromPage property is less than zero");
        }
        this.f = value;
    }

    public static StringCollection getInstalledPrinters() {
        return new StringCollection(PrinterUtils.getInstalledPrinters());
    }

    public boolean isDefaultPrinter() {
        return StringExtensions.equals(this.a, PrinterUtils.getDefaultPrinter());
    }

    public boolean isPlotter() {
        return this.t;
    }

    public boolean isValid() {
        return PrinterUtils.isPrinterValid(this.a);
    }

    public int getLandscapeAngle() {
        return this.m;
    }

    public int getMaximumCopies() {
        return this.j;
    }

    public void setMaximumCopies(int maximum_copies) {
        this.j = maximum_copies;
    }

    public int getMaximumPage() {
        return this.d;
    }

    public void setMaximumPage(int value) {
        if (value < 0) {
            throw new ArgumentException("The value of the MaximumPage property is less than zero");
        }
        this.d = value;
    }

    public int getMinimumPage() {
        return this.e;
    }

    public void setMinimumPage(int value) {
        if (value < 0) {
            throw new ArgumentException("The value of the MaximumPage property is less than zero");
        }
        this.e = value;
    }

    public PaperSizeCollection getPaperSizes() {
        if (!this.isValid()) {
            throw new InvalidPrinterException(this);
        }
        return this.p;
    }

    public PaperSourceCollection getPaperSources() {
        if (!this.isValid()) {
            throw new InvalidPrinterException(this);
        }
        return this.q;
    }

    public void setPaperSources(PaperSourceCollection paper_sources) {
        this.q = paper_sources;
    }

    public String getPrintFileName() {
        return this.b;
    }

    public void setPrintFileName(String value) {
        this.b = value;
    }

    public String getPrinterName() {
        return this.a;
    }

    public void setPrinterName(String value) {
        if (StringExtensions.equals(this.a, value)) {
            return;
        }
        this.a = value;
        String string = this.getPrintFileName();
        boolean bl2 = this.getCollate();
        short s2 = this.getCopies();
        int n2 = this.getFromPage();
        int n3 = this.getToPage();
        try {
            PrinterSettingsLoader printerSettingsLoader = PrinterSettingsLoader.getLoader(this.a);
            printerSettingsLoader.loadPrinterSettings(this);
            this.r = DefaultPageSettingsBuilder.loadDefaultPageSettingsBuilder(this, this.v).buildDefaultPageSettings().getPageSettings();
            this.b = string;
            this.h = bl2;
            this.c = s2;
            this.f = n2;
            this.g = n3;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public PrinterResolutionCollection getPrinterResolutions() {
        if (!this.isValid()) {
            throw new InvalidPrinterException(this);
        }
        return this.o;
    }

    public int getPrintRange() {
        return this.i;
    }

    public void setPrintRange(int value) {
        if (value != 0 && value != 1 && value != 2) {
            throw new InvalidEnumArgumentException("The value of the PrintRange property is not one of the PrintRange values");
        }
        this.i = value;
    }

    public boolean getPrintToFile() {
        return this.n;
    }

    public void setPrintToFile(boolean value) {
        this.n = value;
    }

    public boolean getSupportsColor() {
        return this.l;
    }

    public void setSupportsColor(boolean isColorSupported) {
        this.l = isColorSupported;
    }

    public int getToPage() {
        return this.g;
    }

    public void setToPage(int value) {
        if (value < 0) {
            throw new ArgumentException("The value of the ToPage property is less than zero");
        }
        this.g = value;
    }

    @Override
    public Object deepClone() {
        try {
            return this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public Graphics createMeasurementGraphics() {
        throw new NotImplementedException();
    }

    public Graphics createMeasurementGraphics(boolean honorOriginAtMargins) {
        throw new NotImplementedException();
    }

    public Graphics createMeasurementGraphics(PageSettings pageSettings) {
        throw new NotImplementedException();
    }

    public Graphics createMeasurementGraphics(PageSettings pageSettings, boolean honorOriginAtMargins) {
        throw new NotImplementedException();
    }

    public boolean isDirectPrintingSupported(Image image) {
        throw new NotImplementedException();
    }

    public boolean isDirectPrintingSupported(ImageFormat imageFormat) {
        throw new NotImplementedException();
    }

    public String toString() {
        return StringExtensions.concat("Printer [PrinterSettings ", this.a, " Copies=", this.c, " Collate=", this.h, " Duplex=", this.k, " FromPage=", this.f, " LandscapeAngle=", this.m, " MaximumCopies=", this.j, " OutputPort=", " ToPage=", this.g, "]");
    }

    public PrintService getPrintService() {
        return this.v;
    }

    GraphicsContext a(PageSettings pageSettings) {
        return new GraphicsContext(this.v);
    }

    public boolean getLandscape() {
        return true;
    }

    public static class StringCollection
    implements ICollection,
    IEnumerable {
        private String[] a;

        public StringCollection(String[] array) {
            this.a = array;
        }

        @Override
        public int size() {
            return this.a.length;
        }

        @Override
        public boolean isSynchronized() {
            return false;
        }

        @Override
        public Object getSyncRoot() {
            return this;
        }

        public String get_Item(int index) {
            return this.a[index];
        }

        public int add(String value) {
            String[] stringArray = new String[this.size() + 1];
            this.copyTo(Array.boxing(stringArray), 0);
            stringArray[this.size()] = value;
            this.a = stringArray;
            return this.size();
        }

        public void copyTo(String[] strings, int index) {
            Array.copy(Array.boxing(this.a), index, Array.boxing(strings), 0, this.a.length);
        }

        public IEnumerator iterator() {
            return Array.boxing(this.a).iterator();
        }

        @Override
        public void copyTo(Array array, int index) {
            Array.boxing(this.a).copyTo(array, index);
        }
    }

    public static class PrinterResolutionCollection
    implements ICollection,
    IEnumerable {
        private ArrayList a = new ArrayList();

        public PrinterResolutionCollection(PrinterResolution[] array) {
            for (PrinterResolution printerResolution : array) {
                this.a.addItem(printerResolution);
            }
        }

        @Override
        public int size() {
            return this.a.size();
        }

        @Override
        @ReservedForInternalUse
        public boolean isSynchronized() {
            return false;
        }

        @Override
        @ReservedForInternalUse
        public Object getSyncRoot() {
            return this;
        }

        @EditorBrowsableAttribute(state=1)
        public int add(PrinterResolution printerResolution) {
            return this.a.addItem(printerResolution);
        }

        public void copyTo(PrinterResolution[] printerResolutions, int index) {
            throw new NotImplementedException();
        }

        public PrinterResolution get_Item(int index) {
            Object object = this.a.get_Item(index);
            return object instanceof PrinterResolution ? (PrinterResolution)object : null;
        }

        public IEnumerator iterator() {
            return this.a.iterator();
        }

        @Override
        @ReservedForInternalUse
        public void copyTo(Array array, int index) {
            this.a.copyTo(array, index);
        }

        void a() {
            this.a.clear();
        }
    }

    public static class PaperSizeCollection
    implements ICollection,
    IEnumerable {
        private ArrayList a = new ArrayList();

        public PaperSizeCollection(PaperSize[] array) {
            for (PaperSize paperSize : array) {
                this.a.addItem(paperSize);
            }
        }

        @Override
        public int size() {
            return this.a.size();
        }

        @Override
        @ReservedForInternalUse
        public boolean isSynchronized() {
            return false;
        }

        @Override
        @ReservedForInternalUse
        public Object getSyncRoot() {
            return this;
        }

        @EditorBrowsableAttribute(state=1)
        public int add(PaperSize paperSize) {
            return this.a.addItem(paperSize);
        }

        public void copyTo(PaperSize[] paperSizes, int index) {
            throw new NotImplementedException();
        }

        public PaperSize get_Item(int index) {
            Object object = this.a.get_Item(index);
            return object instanceof PaperSize ? (PaperSize)object : null;
        }

        public IEnumerator iterator() {
            return this.a.iterator();
        }

        @Override
        @ReservedForInternalUse
        public void copyTo(Array array, int index) {
            this.a.copyTo(array, index);
        }

        void a() {
            this.a.clear();
        }
    }

    public static class PaperSourceCollection
    implements ICollection,
    IEnumerable {
        private ArrayList a = new ArrayList();

        public PaperSourceCollection(PaperSource[] array) {
            for (PaperSource paperSource : array) {
                this.a.addItem(paperSource);
            }
        }

        @Override
        public int size() {
            return this.a.size();
        }

        @Override
        @ReservedForInternalUse
        public boolean isSynchronized() {
            return false;
        }

        @Override
        @ReservedForInternalUse
        public Object getSyncRoot() {
            return this;
        }

        @EditorBrowsableAttribute(state=1)
        public int add(PaperSource paperSource) {
            return this.a.addItem(paperSource);
        }

        public void copyTo(PaperSource[] paperSources, int index) {
            throw new NotImplementedException();
        }

        public PaperSource get_Item(int index) {
            Object object = this.a.get_Item(index);
            return object instanceof PaperSource ? (PaperSource)object : null;
        }

        public IEnumerator iterator() {
            return this.a.iterator();
        }

        @Override
        @ReservedForInternalUse
        public void copyTo(Array array, int index) {
            this.a.copyTo(array, index);
        }

        void a() {
            this.a.clear();
        }
    }
}

