/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Drawing.Printing;

import com.aspose.html.internal.ms.System.Drawing.Point;
import com.aspose.html.internal.ms.System.Drawing.Printing.Margins;
import com.aspose.html.internal.ms.System.Drawing.Rectangle;
import com.aspose.html.internal.ms.System.Drawing.Size;
import com.aspose.html.internal.ms.System.NotImplementedException;
import com.aspose.html.internal.ms.System.msMath;

public final class PrinterUnitConvert {
    private PrinterUnitConvert() {
    }

    public static double convert(double value, int fromUnit, int toUnit) {
        switch (fromUnit) {
            case 0: {
                switch (toUnit) {
                    case 0: {
                        return value;
                    }
                    case 1: {
                        return value * 10.0;
                    }
                    case 2: {
                        return value * 25.4;
                    }
                    case 3: {
                        return value * 2.54;
                    }
                }
                break;
            }
            case 1: {
                switch (toUnit) {
                    case 0: {
                        return value / 10.0;
                    }
                    case 1: {
                        return value;
                    }
                    case 2: {
                        return value * 2.54;
                    }
                    case 3: {
                        return value * 0.254;
                    }
                }
                break;
            }
            case 2: {
                switch (toUnit) {
                    case 0: {
                        return value / 25.4;
                    }
                    case 1: {
                        return value / 2.54;
                    }
                    case 2: {
                        return value;
                    }
                    case 3: {
                        return value / 10.0;
                    }
                }
                break;
            }
            case 3: {
                switch (toUnit) {
                    case 0: {
                        return value / 2.54;
                    }
                    case 1: {
                        return value / 0.254;
                    }
                    case 2: {
                        return value * 10.0;
                    }
                    case 3: {
                        return value;
                    }
                }
            }
        }
        throw new NotImplementedException();
    }

    public static int convert(int value, int fromUnit, int toUnit) {
        double d2 = PrinterUnitConvert.convert((double)value, fromUnit, toUnit);
        return (int)msMath.round(d2);
    }

    public static Margins convert(Margins value, int fromUnit, int toUnit) {
        return new Margins(PrinterUnitConvert.convert(value.getLeft(), fromUnit, toUnit), PrinterUnitConvert.convert(value.getRight(), fromUnit, toUnit), PrinterUnitConvert.convert(value.getTop(), fromUnit, toUnit), PrinterUnitConvert.convert(value.getBottom(), fromUnit, toUnit));
    }

    public static Point convert(Point value, int fromUnit, int toUnit) {
        return new Point(PrinterUnitConvert.convert(value.getX(), fromUnit, toUnit), PrinterUnitConvert.convert(value.getY(), fromUnit, toUnit));
    }

    public static Rectangle convert(Rectangle value, int fromUnit, int toUnit) {
        return new Rectangle(PrinterUnitConvert.convert(value.getX(), fromUnit, toUnit), PrinterUnitConvert.convert(value.getY(), fromUnit, toUnit), PrinterUnitConvert.convert(value.getWidth(), fromUnit, toUnit), PrinterUnitConvert.convert(value.getHeight(), fromUnit, toUnit));
    }

    public static Size convert(Size value, int fromUnit, int toUnit) {
        return new Size(PrinterUnitConvert.convert(value.getWidth(), fromUnit, toUnit), PrinterUnitConvert.convert(value.getHeight(), fromUnit, toUnit));
    }
}

