/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Drawing;

import com.aspose.html.internal.ms.System.ComponentModel.BrowsableAttribute;
import com.aspose.html.internal.ms.System.Drawing.PointF;
import com.aspose.html.internal.ms.System.Drawing.Size;
import com.aspose.html.internal.ms.System.Globalization.CultureInfo;
import com.aspose.html.internal.ms.System.ObjectExtensions;
import com.aspose.html.internal.ms.System.SerializableAttribute;
import com.aspose.html.internal.ms.System.SingleExtensions;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.core.System.Drawing.Drawing2D.a;
import com.aspose.html.internal.ms.lang.Struct;
import java.awt.geom.Dimension2D;

@SerializableAttribute
public class SizeF
extends Struct<SizeF> {
    private Dimension2D b = new a(0.0f, 0.0f);
    public static SizeF Empty = new SizeF();

    public SizeF() {
    }

    private SizeF(Dimension2D point) {
        this.b = point;
    }

    public static SizeF op_Addition(SizeF sz1, SizeF sz2) {
        return new SizeF(sz1.getWidth() + sz2.getWidth(), sz1.getHeight() + sz2.getHeight());
    }

    public static boolean op_Equality(SizeF sz1, SizeF sz2) {
        return sz1.getWidth() == sz2.getWidth() && sz1.getHeight() == sz2.getHeight();
    }

    public static boolean op_Inequality(SizeF sz1, SizeF sz2) {
        return sz1.getWidth() != sz2.getWidth() || sz1.getHeight() != sz2.getHeight();
    }

    public static SizeF op_Subtraction(SizeF sz1, SizeF sz2) {
        return new SizeF(sz1.getWidth() - sz2.getWidth(), sz1.getHeight() - sz2.getHeight());
    }

    public static PointF to_PointF(SizeF size) {
        return new PointF(size.getWidth(), size.getHeight());
    }

    public SizeF(PointF pt) {
        this.b.setSize(pt.getX(), pt.getY());
    }

    public SizeF(SizeF size) {
        this.b.setSize(size.getWidth(), size.getHeight());
    }

    public SizeF(float width, float height) {
        this.b.setSize(width, height);
    }

    @BrowsableAttribute(browsable=false)
    public boolean isEmpty() {
        return (double)this.getWidth() == 0.0 && (double)this.getHeight() == 0.0;
    }

    public float getWidth() {
        return (float)this.b.getWidth();
    }

    public void setWidth(float value) {
        this.b.setSize(value, this.b.getHeight());
    }

    public float getHeight() {
        return (float)this.b.getHeight();
    }

    public void setHeight(float value) {
        this.b.setSize(this.b.getWidth(), value);
    }

    public int hashCode() {
        return (int)this.getWidth() ^ (int)this.getHeight();
    }

    public PointF toPointF() {
        return new PointF((float)this.b.getWidth(), (float)this.b.getHeight());
    }

    public Size toSize() {
        int n2 = (int)this.getWidth();
        int n3 = (int)this.getHeight();
        return new Size(n2, n3);
    }

    public String toString() {
        return StringExtensions.format("{{Width={0}, Height={1}}}", SingleExtensions.toString(this.getWidth(), CultureInfo.getCurrentCulture()), SingleExtensions.toString(this.getHeight(), CultureInfo.getCurrentCulture()));
    }

    public static SizeF add(SizeF sz1, SizeF sz2) {
        return new SizeF(sz1.getWidth() + sz2.getWidth(), sz1.getHeight() + sz2.getHeight());
    }

    public static SizeF subtract(SizeF sz1, SizeF sz2) {
        return new SizeF(sz1.getWidth() - sz2.getWidth(), sz1.getHeight() - sz2.getHeight());
    }

    public static SizeF fromJava(Dimension2D point) {
        if (point == null) {
            return new SizeF(0.0f, 0.0f);
        }
        return new SizeF(point);
    }

    public static Dimension2D toJava(SizeF size) {
        if (size == null) {
            return null;
        }
        return size.b;
    }

    @Override
    public void CloneTo(SizeF that) {
        that.setWidth(this.getWidth());
        that.setHeight(this.getHeight());
    }

    @Override
    public SizeF Clone() {
        SizeF sizeF = new SizeF();
        this.CloneTo(sizeF);
        return sizeF;
    }

    public Object clone() {
        return this.Clone();
    }

    private boolean a(SizeF sizeF) {
        return sizeF.getWidth() == this.getWidth() && sizeF.getHeight() == this.getHeight();
    }

    public boolean equals(Object obj) {
        assert (obj != null);
        if (ObjectExtensions.referenceEquals(null, obj)) {
            return false;
        }
        if (ObjectExtensions.referenceEquals(this, obj)) {
            return true;
        }
        if (!(obj instanceof SizeF)) {
            return false;
        }
        return this.a((SizeF)obj);
    }

    public static boolean equals(SizeF obj1, SizeF obj2) {
        return obj1.equals(obj2);
    }
}

