/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Drawing;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.ComponentModel.InvalidEnumArgumentException;
import com.aspose.html.internal.ms.System.Drawing.Bitmap;
import com.aspose.html.internal.ms.System.Drawing.Brush;
import com.aspose.html.internal.ms.System.Drawing.Drawing2D.Matrix;
import com.aspose.html.internal.ms.System.Drawing.Drawing2D.WrapMode;
import com.aspose.html.internal.ms.System.Drawing.Graphics;
import com.aspose.html.internal.ms.System.Drawing.Image;
import com.aspose.html.internal.ms.System.Drawing.Imaging.ColorMatrix;
import com.aspose.html.internal.ms.System.Drawing.Imaging.FrameDimension;
import com.aspose.html.internal.ms.System.Drawing.Imaging.ImageAttributes;
import com.aspose.html.internal.ms.System.Drawing.Imaging.ImageFormat;
import com.aspose.html.internal.ms.System.Drawing.Imaging.Metafile;
import com.aspose.html.internal.ms.System.Drawing.Imaging.PlainImage;
import com.aspose.html.internal.ms.System.Drawing.RasterGraphics;
import com.aspose.html.internal.ms.System.Drawing.Rectangle;
import com.aspose.html.internal.ms.System.Drawing.RectangleF;
import com.aspose.html.internal.ms.System.Drawing.Size;
import com.aspose.html.internal.ms.System.Enum;
import com.aspose.html.internal.ms.System.OutOfMemoryException;
import com.aspose.html.internal.ms.core.System.Drawing.GraphicsUtils;
import com.aspose.html.internal.ms.core.System.Drawing.Imaging.c;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;

public final class TextureBrush
extends Brush {
    TexturePaint a;
    private final RectangleF b = new RectangleF();
    private Image c = null;
    private int d;
    private ImageAttributes e = null;
    private int f = 3;
    private int g = 0;
    private int h = 0;
    private int i = 0;
    private int j = 0;

    @Override
    public Paint getNativeObject() {
        this.d();
        if (this.a == null) {
            this.a(true);
        }
        return this.a;
    }

    RectangleF a() {
        return this.b;
    }

    private static RectangleF a(Image image) {
        if (image == null) {
            throw new ArgumentNullException("image");
        }
        if (image instanceof Metafile) {
            java.awt.Image image2 = ((Metafile)image).getCurrentImage().getNativeImage();
            return new RectangleF(0.0f, 0.0f, image2.getWidth(null), image2.getHeight(null));
        }
        return new RectangleF(0.0f, 0.0f, image.getWidth(), image.getHeight());
    }

    public TextureBrush(Image image) {
        this(image, 0);
    }

    public TextureBrush(Image image, int wrapMode) {
        this(image, wrapMode, TextureBrush.a(image));
    }

    public TextureBrush(Image image, Rectangle dstRect) {
        this(image, 0, dstRect.Clone());
    }

    public TextureBrush(Image image, RectangleF dstRect) {
        this(image, 0, dstRect.Clone());
    }

    public TextureBrush(Image image, Rectangle dstRect, ImageAttributes imageAttr) {
        this(image, imageAttr != null ? 4 : 0, dstRect.Clone(), imageAttr);
    }

    public TextureBrush(Image image, RectangleF dstRect, ImageAttributes imageAttr) {
        this(image, imageAttr != null ? 4 : 0, dstRect.Clone(), imageAttr, true);
    }

    public TextureBrush(Image image, int wrapMode, Rectangle dstRect) {
        this(image, wrapMode, new RectangleF(dstRect.getX(), dstRect.getY(), dstRect.getWidth(), dstRect.getHeight()));
    }

    public TextureBrush(Image image, int wrapMode, RectangleF dstRect) {
        this(image, wrapMode, dstRect, null, true);
    }

    private TextureBrush(Image image, int wrapMode, Rectangle dstRect, ImageAttributes imageAttr) {
        this(image, wrapMode, new RectangleF(dstRect.getX(), dstRect.getY(), dstRect.getWidth(), dstRect.getHeight()), imageAttr, true);
    }

    public TextureBrush(Image image, int wrapMode, boolean cloneImage) {
        this(image, wrapMode, TextureBrush.a(image), null, cloneImage);
    }

    private TextureBrush(Image image, int wrapMode, RectangleF dstRect, ImageAttributes imageAttr, boolean cloneImage) {
        if (image == null) {
            throw new ArgumentNullException("image");
        }
        if (dstRect == null) {
            throw new ArgumentNullException("image");
        }
        if (dstRect.isEmpty() || !TextureBrush.a(image).contains(dstRect)) {
            throw new OutOfMemoryException("Out of memory");
        }
        if (!Enum.isDefined(WrapMode.class, (long)wrapMode)) {
            throw new InvalidEnumArgumentException("wrapMode");
        }
        dstRect.CloneTo(this.b);
        Rectangle rectangle = Rectangle.round(dstRect);
        if (image instanceof Bitmap) {
            this.c = cloneImage ? (ImageFormat.getPng() == image.getRawFormat() && Size.op_Equality(rectangle.getSize(), image.getSize()) ? ((Bitmap)image).deepClone(rectangle) : new Bitmap(((Bitmap)image).deepClone(rectangle))) : image;
        } else if (image instanceof Metafile) {
            this.c = this.a((Metafile)image, rectangle);
        } else {
            throw new IllegalArgumentException("Image neither Bitmap nor Metafile");
        }
        this.d = wrapMode;
        this.e = imageAttr;
    }

    private void a(boolean bl2) {
        Image image = null;
        image = this.d != 0 ? TextureBrush.createWrappedImage(this.c, this.d, this.b) : this.c;
        this.a = new TexturePaint((BufferedImage)image.getNativeObject().getCurrentImage().getNativeImage(), new Rectangle2D.Double(0.0, 0.0, image.getWidth(), image.getHeight()));
        if (bl2) {
            this.b();
        }
    }

    private void c() {
        this.c = Bitmap.a((Bitmap)this.c);
        this.a(false);
    }

    void b() {
        if (this.e == null || this.a == null || this.a.getImage() == null) {
            return;
        }
        ImageAttributes.ImageAttribute imageAttribute = this.e.getAttribute(1);
        if (imageAttribute == null) {
            return;
        }
        ColorMatrix colorMatrix = imageAttribute.clrMatrix;
        if (colorMatrix == null) {
            return;
        }
        BufferedImage bufferedImage = this.a.getImage();
        for (int i2 = 0; i2 < bufferedImage.getWidth(); ++i2) {
            for (int i3 = 0; i3 < bufferedImage.getHeight(); ++i3) {
                int n2 = this.a.getImage().getRGB(i2, i3);
                int n3 = n2 >> 24 & 0xFF;
                int n4 = n2 >> 16 & 0xFF;
                int n5 = n2 >> 8 & 0xFF;
                int n6 = n2 >> 0 & 0xFF;
                float f2 = 1.0f;
                n4 = (int)(Math.abs(colorMatrix.getMatrix00() * f2) * (float)n4 > 255.0f ? 255.0f : (float)n4 * Math.abs(colorMatrix.getMatrix00() * f2));
                n5 = (int)(Math.abs(colorMatrix.getMatrix11() * f2) * (float)n5 > 255.0f ? 255.0f : (float)n5 * Math.abs(colorMatrix.getMatrix11() * f2));
                n6 = (int)(Math.abs(colorMatrix.getMatrix22() * f2) * (float)n6 > 255.0f ? 255.0f : (float)n6 * Math.abs(colorMatrix.getMatrix22() * f2));
                n3 = (int)(Math.abs(colorMatrix.getMatrix33() * f2) * (float)n3 > 255.0f ? 255.0f : (float)n3 * Math.abs(colorMatrix.getMatrix33() * f2));
                n4 = (int)(Math.abs(colorMatrix.getMatrix40() * f2) + (float)n4 > 255.0f ? 255.0f : (float)n4 + Math.abs(colorMatrix.getMatrix40() * f2));
                n5 = (int)(Math.abs(colorMatrix.getMatrix41() * f2) + (float)n5 > 255.0f ? 255.0f : (float)n5 + Math.abs(colorMatrix.getMatrix41() * f2));
                n6 = (int)(Math.abs(colorMatrix.getMatrix42() * f2) + (float)n6 > 255.0f ? 255.0f : (float)n6 + Math.abs(colorMatrix.getMatrix42() * f2));
                n3 = (int)(Math.abs(colorMatrix.getMatrix43() * f2) + (float)n3 > 255.0f ? 255.0f : (float)n3 + Math.abs(colorMatrix.getMatrix43() * f2));
                n2 = (n3 & 0xFF) << 24 | (n4 & 0xFF) << 16 | (n5 & 0xFF) << 8 | (n6 & 0xFF) << 0;
                this.a.getImage().setRGB(i2, i3, n2);
            }
        }
    }

    public static Image createWrappedImage(Image image, int wrapMode, RectangleF rect) {
        Image image2 = null;
        Graphics graphics = null;
        int n2 = (int)rect.getWidth();
        int n3 = (int)rect.getHeight();
        switch (wrapMode) {
            case 1: {
                if (n2 != 1) {
                    n2 *= 2;
                }
                image2 = new Bitmap(n2, n3);
                graphics = Graphics.fromImage(image2);
                graphics.drawImage(image, new Matrix());
                if (n2 == 1) break;
                ((RasterGraphics)graphics).a(image, new Matrix(-1.0f, 0.0f, 0.0f, 1.0f, n2, 0.0f), true);
                break;
            }
            case 2: {
                if (n3 != 1) {
                    n3 *= 2;
                }
                image2 = new Bitmap(n2, n3);
                graphics = Graphics.fromImage(image2);
                graphics.drawImage(image, new Matrix());
                if (n3 == 1) break;
                ((RasterGraphics)graphics).a(image, new Matrix(1.0f, 0.0f, 0.0f, -1.0f, 0.0f, n3), true);
                break;
            }
            case 3: {
                if (n2 != 1) {
                    n2 *= 2;
                }
                if (n3 != 1) {
                    n3 *= 2;
                }
                image2 = new Bitmap(n2, n3);
                graphics = Graphics.fromImage(image2);
                ((RasterGraphics)graphics).drawImage(image, new Matrix());
                if (n2 != 1) {
                    ((RasterGraphics)graphics).a(image, new Matrix(-1.0f, 0.0f, 0.0f, 1.0f, n2, 0.0f), true);
                }
                if (n3 != 1) {
                    ((RasterGraphics)graphics).a(image, new Matrix(1.0f, 0.0f, 0.0f, -1.0f, 0.0f, n3), true);
                }
                if (n2 == 1 || n3 == 1) break;
                ((RasterGraphics)graphics).a(image, new Matrix(-1.0f, 0.0f, 0.0f, -1.0f, n2, n3), true);
                break;
            }
            case 4: {
                image2 = image;
            }
            default: {
                image2 = image;
            }
        }
        return image2;
    }

    @Override
    public PaintContext createContext(ColorModel cm2, java.awt.Rectangle deviceBounds, Rectangle2D userBounds, AffineTransform xform, RenderingHints hints) {
        if (this.getWrapMode() == 4) {
            if (this.getBrushTransform().isInvertible()) {
                Matrix.multiply(xform, this.getBrushTransform().getNativeObject(), 1);
            }
            Bitmap bitmap = new Bitmap((int)Math.ceil(userBounds.getMaxX()), (int)Math.ceil(userBounds.getMaxY()));
            Graphics graphics = Graphics.fromImage(bitmap);
            graphics.drawImage(this.getImage(), Matrix.fromJava(xform));
            TextureBrush textureBrush = new TextureBrush((Image)bitmap, this.getWrapMode());
            return textureBrush.getNativeObject().createContext(cm2, deviceBounds, userBounds, new AffineTransform(), hints);
        }
        return super.createContext(cm2, deviceBounds, userBounds, xform, hints);
    }

    public Image getImage() {
        this.d();
        TextureBrush textureBrush = (TextureBrush)this.deepClone();
        Graphics.fromImage(textureBrush.c).getNativeObject().setPaint(textureBrush);
        return textureBrush.c;
    }

    public Matrix getTransform() {
        this.d();
        return this.getBrushTransform();
    }

    public void setTransform(Matrix value) {
        this.d();
        this.setBrushTransform(value);
    }

    public int getWrapMode() {
        this.d();
        return this.d;
    }

    public void setWrapMode(int value) {
        this.d();
        if (!Enum.isDefined(WrapMode.class, (long)value)) {
            throw new InvalidEnumArgumentException("wrapMode");
        }
        this.d = value;
    }

    private void d() {
        if (this.isDisposed()) {
            throw new ArgumentException("TextureBrush object already disposed.");
        }
    }

    @Override
    public Object deepClone() {
        this.d();
        TextureBrush textureBrush = (TextureBrush)this.internalClone();
        if (this.c != null) {
            textureBrush.c = (Image)this.c.deepClone();
        }
        return textureBrush;
    }

    public void multiplyTransform(Matrix matrix) {
        this.d();
        super.brushMultiplyTransform(matrix);
    }

    public void multiplyTransform(Matrix matrix, int order) {
        this.d();
        super.brushMultiplyTransform(matrix, order);
    }

    public void resetTransform() {
        this.d();
        super.brushResetTransform();
    }

    public void rotateTransform(float angle) {
        this.d();
        super.brushRotateTransform(angle);
    }

    public void rotateTransform(float angle, int order) {
        this.d();
        super.brushRotateTransform(angle, order);
    }

    public void scaleTransform(float sx, float sy) {
        this.d();
        super.brushScaleTransform(sx, sy);
    }

    public void scaleTransform(float sx, float sy, int order) {
        this.d();
        super.brushScaleTransform(sx, sy, order);
    }

    public void translateTransform(float dx2, float dy2) {
        this.d();
        super.brushTranslateTransform(dx2, dy2);
    }

    public void translateTransform(float dx2, float dy2, int order) {
        this.d();
        super.brushTranslateTransform(dx2, dy2, order);
    }

    @Override
    public void dispose() {
        this.a = null;
        this.c = null;
        this.setDisposed();
    }

    public void backupCurrentTextParams(Graphics graphics) {
        this.f = graphics.getSmoothingMode();
        this.g = graphics.getTextRenderingHint();
        this.h = graphics.getCompositingQuality();
        this.i = graphics.getCompositingMode();
        this.j = graphics.getInterpolationMode();
        graphics.setSmoothingMode(3);
        graphics.setTextRenderingHint(0);
        graphics.setCompositingQuality(0);
        graphics.setCompositingMode(0);
        graphics.setInterpolationMode(0);
    }

    public void restoreBackupedTextParams(Graphics graphics) {
        graphics.setSmoothingMode(this.f);
        graphics.setTextRenderingHint(this.g);
        graphics.setCompositingQuality(this.h);
        graphics.setCompositingMode(this.i);
        graphics.setInterpolationMode(this.j);
    }

    private Bitmap a(Metafile metafile, Rectangle rectangle) {
        BufferedImage bufferedImage = (BufferedImage)metafile.getCurrentImage().getNativeImage();
        BufferedImage bufferedImage2 = com.aspose.html.internal.ms.core.System.Drawing.Imaging.c.a(bufferedImage, rectangle.getX(), rectangle.getY(), rectangle.getWidth(), rectangle.getHeight());
        PlainImage plainImage = new PlainImage(bufferedImage2, null, ImageFormat.getMemoryBmp(), GraphicsUtils.getDefaultScreenResolution(), GraphicsUtils.getDefaultScreenResolution(), FrameDimension.getPage());
        return new Bitmap(plainImage);
    }
}

