/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.IO;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.Decimal;
import com.aspose.html.internal.ms.System.IDisposable;
import com.aspose.html.internal.ms.System.IO.Stream;
import com.aspose.html.internal.ms.System.ObjectDisposedException;
import com.aspose.html.internal.ms.System.SerializableAttribute;
import com.aspose.html.internal.ms.System.Text.Encoding;

@SerializableAttribute
public class BinaryWriter
implements IDisposable {
    public static BinaryWriter Null = new BinaryWriter();
    protected Stream OutStream;
    private Encoding a;
    private byte[] b;
    private byte[] c;
    private int d;
    private boolean e;
    private static final boolean f = false;

    protected BinaryWriter() {
        this(Stream.Null, Encoding.getUTF8());
    }

    public BinaryWriter(Stream output) {
        this(output, Encoding.getUTF8());
    }

    public BinaryWriter(Stream output, Encoding encoding) {
        if (output == null) {
            throw new ArgumentNullException("output");
        }
        if (encoding == null) {
            throw new ArgumentNullException("encoding");
        }
        if (!output.canWrite()) {
            throw new ArgumentException("Stream does not support writing or already closed.");
        }
        this.OutStream = output;
        this.a = encoding;
        this.b = new byte[16];
    }

    public Stream getBaseStream() {
        this.flush();
        return this.OutStream;
    }

    public void close() {
        this.dispose(true);
    }

    @Override
    public void dispose() {
        this.dispose(true);
    }

    protected void dispose(boolean disposing) {
        if (disposing && this.OutStream != null) {
            this.OutStream.close();
        }
        this.b = null;
        this.a = null;
        this.e = true;
    }

    public void flush() {
        this.OutStream.flush();
    }

    public long seek(int offset, int origin) {
        if (this.e) {
            throw new ObjectDisposedException("BinaryWriter", "Cannot seek a closed BinaryWriter");
        }
        return this.OutStream.seek(offset, origin);
    }

    public void write(boolean value) {
        if (this.e) {
            throw new ObjectDisposedException("BinaryWriter", "Cannot write to a closed BinaryWriter");
        }
        this.b[0] = (byte)(value ? 1 : 0);
        this.OutStream.write(this.b, 0, 1);
    }

    public void writeByte(byte value) {
        this.b[0] = value;
        this.OutStream.write(this.b, 0, 1);
    }

    public void writeBytes(byte[] buffer, int offset, int count) {
        if (this.e) {
            throw new ObjectDisposedException("BinaryWriter", "Cannot write to a closed BinaryWriter");
        }
        if (buffer == null) {
            throw new ArgumentNullException("buffer");
        }
        this.OutStream.write(buffer, offset, count);
    }

    public void writeBytes(byte[] buffer) {
        this.OutStream.write(buffer, 0, buffer.length);
    }

    public void write(char ch2) {
        if (this.e) {
            throw new ObjectDisposedException("BinaryWriter", "Cannot write to a closed BinaryWriter");
        }
        char[] cArray = new char[]{ch2};
        byte[] byArray = this.a.getBytes(cArray, 0, 1);
        this.OutStream.write(byArray, 0, byArray.length);
    }

    public void writeChars(char[] chars) {
        if (this.e) {
            throw new ObjectDisposedException("BinaryWriter", "Cannot write to a closed BinaryWriter");
        }
        if (chars == null) {
            throw new ArgumentNullException("chars");
        }
        byte[] byArray = this.a.getBytes(chars, 0, chars.length);
        this.OutStream.write(byArray, 0, byArray.length);
    }

    public void writeChars(char[] chars, int index, int count) {
        if (this.e) {
            throw new ObjectDisposedException("BinaryWriter", "Cannot write to a closed BinaryWriter");
        }
        if (chars == null) {
            throw new ArgumentNullException("chars");
        }
        byte[] byArray = this.a.getBytes(chars, index, count);
        this.OutStream.write(byArray, 0, byArray.length);
    }

    public void writeInt16(short value) {
        this.b[0] = (byte)value;
        this.b[1] = (byte)(value >> 8);
        this.OutStream.write(this.b, 0, 2);
    }

    public void writeUInt16(int value) {
        this.writeInt16((short)value);
    }

    public void writeInt32(int value) {
        if (this.e) {
            throw new ObjectDisposedException("BinaryWriter", "Cannot write to a closed BinaryWriter");
        }
        this.b[0] = (byte)value;
        this.b[1] = (byte)(value >> 8);
        this.b[2] = (byte)(value >> 16);
        this.b[3] = (byte)(value >> 24);
        this.OutStream.write(this.b, 0, 4);
    }

    public void writeUInt32(long value) {
        this.writeInt32((int)value);
    }

    public void writeInt64(long value) {
        this.writeUInt32(value & 0xFFFFFFFFL);
        this.writeUInt32(value >> 32);
    }

    public void writeUInt64(long value) {
        this.writeUInt32(value & 0xFFFFFFFFL);
        this.writeUInt32(value >>> 32);
    }

    public void writeFloat(float value) {
        this.writeInt32(Float.floatToIntBits(value));
    }

    public void writeDouble(double value) {
        this.writeInt64(Double.doubleToLongBits(value));
    }

    public void writeDecimal(Decimal decimal) {
        int[] nArray = Decimal.getBits(decimal);
        byte[] byArray = new byte[]{(byte)nArray[0], (byte)(nArray[0] >> 8), (byte)(nArray[0] >> 16), (byte)(nArray[0] >> 24), (byte)nArray[1], (byte)(nArray[1] >> 8), (byte)(nArray[1] >> 16), (byte)(nArray[1] >> 24), (byte)nArray[2], (byte)(nArray[2] >> 8), (byte)(nArray[2] >> 16), (byte)(nArray[2] >> 24), (byte)nArray[3], (byte)(nArray[3] >> 8), (byte)(nArray[3] >> 16), (byte)(nArray[3] >> 24)};
        this.OutStream.write(byArray, 0, 16);
    }

    public void write(String value) {
        int n2;
        if (this.e) {
            throw new ObjectDisposedException("BinaryWriter", "Cannot write to a closed BinaryWriter");
        }
        int n3 = this.a.getByteCount(value);
        this.write7BitEncodedInt(n3);
        if (this.c == null) {
            this.c = new byte[512];
            this.d = 512 / this.a.getMaxByteCount(1);
        }
        int n4 = 0;
        for (int i2 = value.length(); i2 > 0; i2 -= n2) {
            n2 = i2 > this.d ? this.d : i2;
            int n5 = this.a.getBytes(value, n4, n2, this.c, 0);
            this.OutStream.write(this.c, 0, n5);
            n4 += n2;
        }
    }

    protected void write7BitEncodedInt(int value) {
        int n2;
        do {
            n2 = value >> 7 & 0x1FFFFFF;
            byte by2 = (byte)(value & 0x7F);
            if (n2 != 0) {
                by2 = (byte)(by2 & 0xFF | 0x80);
            }
            this.writeByte(by2);
        } while ((value = n2) != 0);
    }
}

