/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Net.Mail;

import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.IO.MemoryStream;
import com.aspose.html.internal.ms.System.IO.Path;
import com.aspose.html.internal.ms.System.IO.Stream;
import com.aspose.html.internal.ms.System.IO.StreamWriter;
import com.aspose.html.internal.ms.System.Net.Mail.AttachmentBase;
import com.aspose.html.internal.ms.System.Net.Mime.ContentDisposition;
import com.aspose.html.internal.ms.System.Net.Mime.ContentType;
import com.aspose.html.internal.ms.System.Text.Encoding;
import com.aspose.html.internal.ms.lang.Operators;

public class Attachment
extends AttachmentBase {
    private ContentDisposition a = new ContentDisposition();
    private Encoding b;

    public Attachment(String fileName) {
        super(fileName);
        this.a(fileName);
    }

    public Attachment(String fileName, String mediaType) {
        super(fileName, mediaType);
        this.a(fileName);
    }

    public Attachment(String fileName, ContentType contentType) {
        super(fileName, contentType);
        this.a(fileName);
    }

    public Attachment(Stream contentStream, ContentType contentType) {
        super(contentStream, contentType);
    }

    public Attachment(Stream contentStream, String name) {
        super(contentStream);
        this.setName(name);
    }

    public Attachment(Stream contentStream, String name, String mediaType) {
        super(contentStream, mediaType);
        this.setName(name);
    }

    public ContentDisposition getContentDisposition() {
        return this.a;
    }

    public String getName() {
        return this.getContentType().getName();
    }

    public void setName(String value) {
        this.getContentType().setName(value);
    }

    public Encoding getNameEncoding() {
        return this.b;
    }

    public void setNameEncoding(Encoding value) {
        this.b = value;
    }

    public static Attachment createAttachmentFromString(String content, ContentType contentType) {
        if (content == null) {
            throw new ArgumentNullException("content");
        }
        MemoryStream memoryStream = new MemoryStream();
        StreamWriter streamWriter = new StreamWriter(memoryStream);
        streamWriter.write(content);
        streamWriter.flush();
        memoryStream.setPosition(Operators.castToInt64(0, 9));
        Attachment attachment = new Attachment((Stream)memoryStream, contentType);
        attachment.setTransferEncoding(0);
        return attachment;
    }

    public static Attachment createAttachmentFromString(String content, String name) {
        if (content == null) {
            throw new ArgumentNullException("content");
        }
        MemoryStream memoryStream = new MemoryStream();
        StreamWriter streamWriter = new StreamWriter(memoryStream);
        streamWriter.write(content);
        streamWriter.flush();
        memoryStream.setPosition(Operators.castToInt64(0, 9));
        Attachment attachment = new Attachment((Stream)memoryStream, new ContentType("text/plain"));
        attachment.setTransferEncoding(0);
        attachment.setName(name);
        return attachment;
    }

    public static Attachment createAttachmentFromString(String content, String name, Encoding contentEncoding, String mediaType) {
        if (content == null) {
            throw new ArgumentNullException("content");
        }
        MemoryStream memoryStream = new MemoryStream();
        StreamWriter streamWriter = new StreamWriter(memoryStream, contentEncoding);
        streamWriter.write(content);
        streamWriter.flush();
        memoryStream.setPosition(Operators.castToInt64(0, 9));
        Attachment attachment = new Attachment(memoryStream, name, mediaType);
        attachment.setTransferEncoding(ContentType.guessTransferEncoding(contentEncoding));
        attachment.getContentType().setCharSet(streamWriter.getEncoding().getBodyName());
        return attachment;
    }

    private void a(String string) {
        if (string == null) {
            throw new ArgumentNullException("fileName");
        }
        this.setName(Path.getFileName(string));
    }
}

