/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Net.Mail;

import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.IO.MemoryStream;
import com.aspose.html.internal.ms.System.IO.Stream;
import com.aspose.html.internal.ms.System.Net.Mail.AttachmentBase;
import com.aspose.html.internal.ms.System.Net.Mime.ContentType;
import com.aspose.html.internal.ms.System.Text.Encoding;
import com.aspose.html.internal.ms.System.Uri;

public class LinkedResource
extends AttachmentBase {
    private Uri a;

    public LinkedResource(String fileName) {
        super(fileName);
        if (fileName == null) {
            throw new ArgumentNullException();
        }
    }

    public LinkedResource(String fileName, ContentType contentType) {
        super(fileName, contentType);
        if (fileName == null) {
            throw new ArgumentNullException();
        }
    }

    public LinkedResource(String fileName, String mediaType) {
        super(fileName, mediaType);
        if (fileName == null) {
            throw new ArgumentNullException();
        }
    }

    public LinkedResource(Stream contentStream) {
        super(contentStream);
        if (contentStream == null) {
            throw new ArgumentNullException();
        }
    }

    public LinkedResource(Stream contentStream, ContentType contentType) {
        super(contentStream, contentType);
        if (contentStream == null) {
            throw new ArgumentNullException();
        }
    }

    public LinkedResource(Stream contentStream, String mediaType) {
        super(contentStream, mediaType);
        if (contentStream == null) {
            throw new ArgumentNullException();
        }
    }

    public Uri getContentLink() {
        return this.a;
    }

    public void setContentLink(Uri value) {
        this.a = value;
    }

    public static LinkedResource createLinkedResourceFromString(String content) {
        if (content == null) {
            throw new ArgumentNullException();
        }
        MemoryStream memoryStream = new MemoryStream(Encoding.getDefault().getBytes(content));
        LinkedResource linkedResource = new LinkedResource(memoryStream);
        linkedResource.setTransferEncoding(0);
        return linkedResource;
    }

    public static LinkedResource createLinkedResourceFromString(String content, ContentType contentType) {
        if (content == null) {
            throw new ArgumentNullException();
        }
        MemoryStream memoryStream = new MemoryStream(Encoding.getDefault().getBytes(content));
        LinkedResource linkedResource = new LinkedResource((Stream)memoryStream, contentType);
        linkedResource.setTransferEncoding(0);
        return linkedResource;
    }

    public static LinkedResource createLinkedResourceFromString(String content, Encoding contentEncoding, String mediaType) {
        if (content == null) {
            throw new ArgumentNullException();
        }
        MemoryStream memoryStream = new MemoryStream(contentEncoding.getBytes(content));
        LinkedResource linkedResource = new LinkedResource((Stream)memoryStream, mediaType);
        linkedResource.setTransferEncoding(0);
        return linkedResource;
    }
}

