/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Net.Sockets;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.internal.ms.System.Array;
import com.aspose.html.internal.ms.System.AsyncCallback;
import com.aspose.html.internal.ms.System.GC;
import com.aspose.html.internal.ms.System.IAsyncResult;
import com.aspose.html.internal.ms.System.IDisposable;
import com.aspose.html.internal.ms.System.IO.IOException;
import com.aspose.html.internal.ms.System.IO.Stream;
import com.aspose.html.internal.ms.System.Net.Sockets.Socket;
import com.aspose.html.internal.ms.System.NotSupportedException;
import com.aspose.html.internal.ms.System.ObjectDisposedException;
import com.aspose.html.internal.ms.System.ObjectExtensions;
import com.aspose.html.internal.ms.System.Runtime.InteropServices.InAttribute;
import com.aspose.html.internal.ms.System.Runtime.InteropServices.OutAttribute;
import com.aspose.html.internal.ms.System.Threading.Timeout;
import com.aspose.html.internal.ms.System.Timers.ElapsedEventArgs;
import com.aspose.html.internal.ms.System.Timers.ElapsedEventHandler;
import com.aspose.html.internal.ms.System.Timers.Timer;
import com.aspose.html.internal.ms.lang.Operators;

public class NetworkStream
extends Stream
implements IDisposable {
    private int a;
    private Socket b;
    private boolean c;
    private boolean d;
    private boolean e;
    private boolean f = false;

    public NetworkStream(Socket socket) {
        this(socket, 3, false);
    }

    public NetworkStream(Socket socket, boolean ownsSocket) {
        this(socket, 3, ownsSocket);
    }

    public NetworkStream(Socket socket, int access) {
        this(socket, access, false);
    }

    public NetworkStream(Socket socket, int access, boolean ownsSocket) {
        if (socket == null) {
            throw new ArgumentNullException("socket is null");
        }
        if (socket.getSocketType() != 1) {
            throw new ArgumentException("Socket is not of type Stream", "socket");
        }
        if (!socket.getConnected()) {
            throw new IOException("Not connected");
        }
        if (!socket.getBlocking()) {
            throw new IOException("Operation not allowed on a non-blocking socket.");
        }
        this.b = socket;
        this.c = ownsSocket;
        this.a = access;
        this.d = this.canRead();
        this.e = this.canWrite();
    }

    @Override
    public boolean canRead() {
        return this.a == 3 || this.a == 1;
    }

    @Override
    public boolean canSeek() {
        return false;
    }

    @Override
    public boolean canTimeout() {
        return true;
    }

    @Override
    public boolean canWrite() {
        return this.a == 3 || this.a == 2;
    }

    public boolean getDataAvailable() {
        this.a();
        return this.b.getAvailable() > 0;
    }

    @Override
    public long getLength() {
        return this.b.getReceiveBufferSize();
    }

    @Override
    public long getPosition() {
        throw new NotSupportedException();
    }

    @Override
    public void setPosition(long value) {
        throw new NotSupportedException();
    }

    protected boolean getReadable() {
        return this.d;
    }

    protected void setReadable(boolean value) {
        this.d = value;
    }

    @Override
    public int getReadTimeout() {
        int n2 = this.b.getReceiveTimeout();
        return n2 <= 0 ? Timeout.Infinite : n2;
    }

    @Override
    public void setReadTimeout(int value) {
        if (value <= 0 && value != Timeout.Infinite) {
            throw new ArgumentOutOfRangeException("value", "The value specified is less than or equal to zero and is not Infinite.");
        }
        this.b.setReceiveTimeout(value);
    }

    protected Socket getSocket() {
        return this.b;
    }

    protected boolean getWriteable() {
        return this.e;
    }

    protected void setWriteable(boolean value) {
        this.e = value;
    }

    @Override
    public int getWriteTimeout() {
        int n2 = this.b.getSendTimeout();
        return n2 <= 0 ? Timeout.Infinite : n2;
    }

    @Override
    public void setWriteTimeout(int value) {
        if (value <= 0 && value != Timeout.Infinite) {
            throw new ArgumentOutOfRangeException("value", "The value specified is less than or equal to zero and is not Infinite");
        }
        this.b.setSendTimeout(value);
    }

    @Override
    public IAsyncResult beginRead(byte[] buffer, int offset, int size, AsyncCallback callback, Object state) {
        IAsyncResult iAsyncResult;
        this.a();
        if (buffer == null) {
            throw new ArgumentNullException("buffer is null");
        }
        int n2 = Array.boxing(buffer).getLength();
        if (offset < 0 || offset > n2) {
            throw new ArgumentOutOfRangeException("offset exceeds the size of buffer");
        }
        if (size < 0 || offset + size > n2) {
            throw new ArgumentOutOfRangeException("offset+size exceeds the size of buffer");
        }
        Socket socket = this.b;
        if (socket == null) {
            throw new IOException("Connection closed");
        }
        try {
            iAsyncResult = socket.beginReceive(buffer, offset, size, 0, callback, state);
        }
        catch (RuntimeException runtimeException) {
            throw new IOException("BeginReceive failure", runtimeException);
        }
        return iAsyncResult;
    }

    @Override
    public IAsyncResult beginWrite(byte[] buffer, int offset, int size, AsyncCallback callback, Object state) {
        IAsyncResult iAsyncResult;
        this.a();
        if (buffer == null) {
            throw new ArgumentNullException("buffer is null");
        }
        int n2 = Array.boxing(buffer).getLength();
        if (offset < 0 || offset > n2) {
            throw new ArgumentOutOfRangeException("offset exceeds the size of buffer");
        }
        if (size < 0 || offset + size > n2) {
            throw new ArgumentOutOfRangeException("offset+size exceeds the size of buffer");
        }
        Socket socket = this.b;
        if (socket == null) {
            throw new IOException("Connection closed");
        }
        try {
            iAsyncResult = socket.beginSend(buffer, offset, size, 0, callback, state);
        }
        catch (RuntimeException runtimeException) {
            throw new IOException("BeginWrite failure", runtimeException);
        }
        return iAsyncResult;
    }

    protected void finalize() {
        this.dispose(false);
    }

    public void close(int timeout) {
        if (timeout < -1) {
            throw new ArgumentOutOfRangeException("timeout", "timeout is less than -1");
        }
        Timer timer = new Timer();
        timer.Elapsed.add(new ElapsedEventHandler(){

            @Override
            public void invoke(Object source, ElapsedEventArgs e2) {
                NetworkStream.this.a(source, e2);
            }
        });
        timer.setInterval(Operators.castToDouble(timeout, 9));
        timer.setAutoReset(false);
        timer.setEnabled(true);
    }

    private void a(Object object, ElapsedEventArgs elapsedEventArgs) {
        this.close();
    }

    @Override
    protected void dispose(boolean disposing) {
        Socket socket;
        if (this.f) {
            return;
        }
        this.f = true;
        if (this.c && (socket = this.b) != null) {
            socket.close();
        }
        this.b = null;
        this.a = 0;
        if (disposing) {
            GC.suppressFinalize(this);
        }
    }

    @Override
    public int endRead(IAsyncResult ar2) {
        int n2;
        this.a();
        if (ar2 == null) {
            throw new ArgumentNullException("async result is null");
        }
        Socket socket = this.b;
        if (socket == null) {
            throw new IOException("Connection closed");
        }
        try {
            n2 = socket.endReceive(ar2);
        }
        catch (RuntimeException runtimeException) {
            throw new IOException("EndRead failure", runtimeException);
        }
        return n2;
    }

    @Override
    public void endWrite(IAsyncResult ar2) {
        this.a();
        if (ar2 == null) {
            throw new ArgumentNullException("async result is null");
        }
        Socket socket = this.b;
        if (socket == null) {
            throw new IOException("Connection closed");
        }
        try {
            socket.endSend(ar2);
        }
        catch (RuntimeException runtimeException) {
            throw new IOException("EndWrite failure", runtimeException);
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public int read(@InAttribute @OutAttribute byte[] buffer, int offset, int size) {
        int n2;
        this.a();
        if (buffer == null) {
            throw new ArgumentNullException("buffer is null");
        }
        if (offset < 0 || offset > Array.boxing(buffer).getLength()) {
            throw new ArgumentOutOfRangeException("offset exceeds the size of buffer");
        }
        if (size < 0 || offset + size > Array.boxing(buffer).getLength()) {
            throw new ArgumentOutOfRangeException("offset+size exceeds the size of buffer");
        }
        Socket socket = this.b;
        if (socket == null) {
            throw new IOException("Connection closed");
        }
        try {
            n2 = socket.receive(buffer, offset, size, 0);
        }
        catch (RuntimeException runtimeException) {
            throw new IOException("Read failure", runtimeException);
        }
        return n2;
    }

    @Override
    public long seek(long offset, int origin) {
        throw new NotSupportedException();
    }

    @Override
    public void setLength(long value) {
        throw new NotSupportedException();
    }

    @Override
    public void write(byte[] buffer, int offset, int size) {
        this.a();
        if (buffer == null) {
            throw new ArgumentNullException("buffer");
        }
        if (offset < 0 || offset > Array.boxing(buffer).getLength()) {
            throw new ArgumentOutOfRangeException("offset exceeds the size of buffer");
        }
        if (size < 0 || size > Array.boxing(buffer).getLength() - offset) {
            throw new ArgumentOutOfRangeException("offset+size exceeds the size of buffer");
        }
        Socket socket = this.b;
        if (socket == null) {
            throw new IOException("Connection closed");
        }
        try {
            int n2 = 0;
            while (size - n2 > 0) {
                n2 += socket.send(buffer, offset + n2, size - n2, 0);
            }
        }
        catch (RuntimeException runtimeException) {
            throw new IOException("Write failure", runtimeException);
        }
    }

    private void a() {
        if (this.f) {
            throw new ObjectDisposedException(ObjectExtensions.getType(this).getFullName());
        }
    }

    public void changeToSSLSocket() {
        this.b.changeToSSL();
    }

    public boolean changeToSSLSocket_internal() {
        return this.b.changeToSSL_internal();
    }
}

