/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Reflection;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.Collections.Generic.List;
import com.aspose.html.internal.ms.System.Globalization.CultureInfo;
import com.aspose.html.internal.ms.System.Reflection.Binder;
import com.aspose.html.internal.ms.System.Reflection.CustomAttribute;
import com.aspose.html.internal.ms.System.Reflection.MethodBase;
import com.aspose.html.internal.ms.System.Reflection.MethodInfo;
import com.aspose.html.internal.ms.System.Reflection.Module;
import com.aspose.html.internal.ms.System.Reflection.ParameterInfo;
import com.aspose.html.internal.ms.System.Reflection.PropertyInfo;
import com.aspose.html.internal.ms.System.Reflection.RuntimeMethodInfo;
import com.aspose.html.internal.ms.System.Reflection.RuntimeType;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.Type;
import com.aspose.html.internal.ms.lang.Operators;
import java.lang.annotation.Annotation;

class RuntimePropertyInfo
extends PropertyInfo {
    private RuntimeMethodInfo a;
    private RuntimeMethodInfo b;
    private String c;
    private final int d;

    public RuntimePropertyInfo(RuntimeMethodInfo getMethod, RuntimeMethodInfo setMethod, int bindingFlags) {
        this.a = getMethod;
        this.b = setMethod;
        this.d = bindingFlags;
        this.c = getMethod != null ? StringExtensions.substring(getMethod.getName(), 4) : StringExtensions.substring(setMethod.getName(), 4);
    }

    public int b() {
        return this.d;
    }

    @Override
    public int getAttributes() {
        return this.a != null ? this.a.getAttributes() : this.b.getAttributes();
    }

    @Override
    public boolean canRead() {
        return this.a != null;
    }

    @Override
    public boolean canWrite() {
        return this.b != null;
    }

    @Override
    public Type getPropertyType() {
        if (this.a != null) {
            return this.a.getReturnType();
        }
        ParameterInfo[] parameterInfoArray = this.b.getParameters();
        if (parameterInfoArray.length > 0) {
            return parameterInfoArray[parameterInfoArray.length - 1].getParameterType();
        }
        return this.b.getReturnType();
    }

    @Override
    public MethodInfo[] getAccessors(boolean nonPublic) {
        List<MethodInfo> list = new List<MethodInfo>();
        if (this.a != null) {
            list.addItem(this.getGetMethod(nonPublic));
        }
        if (this.b != null) {
            list.addItem(this.getSetMethod(nonPublic));
        }
        return list.toArray(new MethodInfo[0]);
    }

    @Override
    public MethodInfo getGetMethod(boolean nonPublic) {
        return this.a;
    }

    @Override
    public ParameterInfo[] getIndexParameters() {
        if (this.a != null) {
            return this.a.getParameters();
        }
        return this.b.getParameters();
    }

    @Override
    public MethodInfo getSetMethod(boolean nonPublic) {
        return this.b;
    }

    @Override
    public Module getModule() {
        return null;
    }

    @Override
    public Type getDeclaringType() {
        if (this.a != null) {
            return this.a.getDeclaringType();
        }
        return this.b.getDeclaringType();
    }

    @Override
    public String getName() {
        return this.c;
    }

    @Override
    public Type getReflectedType() {
        return null;
    }

    @Override
    public boolean isDefined(Type attributeType, boolean inherit) {
        if (attributeType == null) {
            throw new ArgumentNullException("attributeType");
        }
        RuntimeType runtimeType = Operators.as(attributeType.getUnderlyingSystemType(), RuntimeType.class);
        if (runtimeType == null) {
            throw new ArgumentException("Argument must be a Type", "attributeType");
        }
        return CustomAttribute.b(this, (Type)runtimeType);
    }

    @Override
    public Object[] getCustomAttributes(boolean inherit) {
        return CustomAttribute.a(this, Operators.typeOf(Object.class));
    }

    @Override
    public Object[] getCustomAttributes(Type attributeType, boolean inherit) {
        if (attributeType == null) {
            throw new ArgumentNullException("attributeType");
        }
        RuntimeType runtimeType = Operators.as(attributeType.getUnderlyingSystemType(), RuntimeType.class);
        if (runtimeType == null) {
            throw new ArgumentException("Type must be a type provided by the runtime.", "attributeType");
        }
        return CustomAttribute.a(this, (Type)runtimeType);
    }

    @Override
    public Object getValue(Object obj, Object[] index) {
        return this.getValue(obj, 60, null, index, null);
    }

    @Override
    public Object getValue(Object obj, int invokeAttr, Binder binder, Object[] index, CultureInfo culture) {
        MethodInfo methodInfo = this.getGetMethod(true);
        if (methodInfo == null) {
            throw new ArgumentException("Property Get method was not found.");
        }
        return methodInfo.invoke(obj, invokeAttr, binder, index, null);
    }

    @Override
    public void setValue(Object obj, Object value, Object[] index) {
        this.setValue(obj, value, 60, null, index, null);
    }

    @Override
    public void setValue(Object obj, Object value, int invokeAttr, Binder binder, Object[] index, CultureInfo culture) {
        MethodInfo methodInfo = this.getSetMethod(true);
        if (methodInfo == null) {
            throw new ArgumentException("Property set method not found.");
        }
        Object[] objectArray = null;
        if (index != null) {
            objectArray = new Object[index.length + 1];
            for (int i2 = 0; i2 < index.length; ++i2) {
                objectArray[i2] = index[i2];
            }
            objectArray[index.length] = value;
        } else {
            objectArray = new Object[]{value};
        }
        methodInfo.invoke(obj, invokeAttr, binder, objectArray, culture);
    }

    @Override
    public void setValueManual(MethodBase.Invoker invoker, Object obj, Object value, int invokeAttr, Binder binder, Object[] index, CultureInfo culture) {
        MethodInfo methodInfo = this.getSetMethod(true);
        if (methodInfo == null) {
            throw new ArgumentException("Property set method not found.");
        }
        Object[] objectArray = null;
        if (index != null) {
            objectArray = new Object[index.length + 1];
            for (int i2 = 0; i2 < index.length; ++i2) {
                objectArray[i2] = index[i2];
            }
            objectArray[index.length] = value;
        } else {
            objectArray = new Object[]{value};
        }
        methodInfo.invokeManual(invoker, obj, invokeAttr, binder, objectArray, culture);
    }

    @Override
    public Annotation[] getAnnotations() {
        if (this.a != null) {
            return this.a.getAnnotations();
        }
        return this.b.getAnnotations();
    }
}

