/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Security.Cryptography;

import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.internal.ms.System.Array;
import com.aspose.html.internal.ms.System.Buffer;
import com.aspose.html.internal.ms.System.Convert;
import com.aspose.html.internal.ms.System.NotSupportedException;
import com.aspose.html.internal.ms.System.Security.Cryptography.CryptographicException;
import com.aspose.html.internal.ms.System.Security.Cryptography.CspParameters;
import com.aspose.html.internal.ms.System.Security.Cryptography.DeriveBytes;
import com.aspose.html.internal.ms.System.Security.Cryptography.HashAlgorithm;
import com.aspose.html.internal.ms.System.Text.Encoding;
import com.aspose.html.internal.ms.System.msArray;
import com.aspose.html.internal.ms.core.System.Security.Cryptography.n;

public class PasswordDeriveBytes
extends DeriveBytes {
    private String a;
    private byte[] b;
    private int c;
    private HashAlgorithm d;
    private int e;
    private byte[] f;
    private byte[] g;
    private byte[] h;
    private int i;
    private int j;

    public PasswordDeriveBytes(String strPassword, byte[] rgbSalt) {
        this.a(strPassword, rgbSalt, "SHA1", 100);
    }

    public PasswordDeriveBytes(String strPassword, byte[] rgbSalt, CspParameters cspParams) {
        this.a(strPassword, rgbSalt, "SHA1", 100);
        if (cspParams != null) {
            throw new NotSupportedException(n.a("CspParameters not supported for PasswordDeriveBytes."));
        }
    }

    public PasswordDeriveBytes(String strPassword, byte[] rgbSalt, String strHashName, int iterations) {
        this.a(strPassword, rgbSalt, strHashName, iterations);
    }

    public PasswordDeriveBytes(String strPassword, byte[] rgbSalt, String strHashName, int iterations, CspParameters cspParams) {
        this.a(strPassword, rgbSalt, strHashName, iterations);
        if (cspParams != null) {
            throw new NotSupportedException(n.a("CspParameters not supported for PasswordDeriveBytes."));
        }
    }

    public PasswordDeriveBytes(byte[] password, byte[] salt) {
        this.a(password, salt, "SHA1", 100);
    }

    public PasswordDeriveBytes(byte[] password, byte[] salt, CspParameters cspParams) {
        this.a(password, salt, "SHA1", 100);
        if (cspParams != null) {
            throw new NotSupportedException(n.a("CspParameters not supported for PasswordDeriveBytes."));
        }
    }

    public PasswordDeriveBytes(byte[] password, byte[] salt, String hashName, int iterations) {
        this.a(password, salt, hashName, iterations);
    }

    public PasswordDeriveBytes(byte[] password, byte[] salt, String hashName, int iterations, CspParameters cspParams) {
        this.a(password, salt, hashName, iterations);
        if (cspParams != null) {
            throw new NotSupportedException(n.a("CspParameters not supported for PasswordDeriveBytes."));
        }
    }

    private void a(String string, byte[] byArray, String string2, int n2) {
        if (string == null) {
            throw new ArgumentNullException("strPassword");
        }
        byte[] byArray2 = Encoding.getUTF8().getBytes(string);
        this.a(byArray2, byArray, string2, n2);
        msArray.clear(byArray2, 0, byArray2.length);
    }

    private void a(byte[] byArray, byte[] byArray2, String string, int n2) {
        if (byArray == null) {
            throw new ArgumentNullException("password");
        }
        this.f = (byte[])byArray.clone();
        this.setSalt(byArray2);
        this.setHashName(string);
        this.setIterationCount(n2);
        this.e = 0;
    }

    public String getHashName() {
        return this.a;
    }

    public void setHashName(String value) {
        if (value == null) {
            throw new ArgumentNullException("value");
        }
        if (this.e != 0) {
            throw new CryptographicException(n.a("Can't change this property at this stage"));
        }
        this.a = value;
    }

    public int getIterationCount() {
        return this.c;
    }

    public void setIterationCount(int value) {
        if (value < 1) {
            throw new ArgumentOutOfRangeException("> 0", "IterationCount");
        }
        if (this.e != 0) {
            throw new CryptographicException(n.a("Can't change this property at this stage"));
        }
        this.c = value;
    }

    public byte[] getSalt() {
        if (this.b == null) {
            return null;
        }
        return (byte[])this.b.clone();
    }

    public void setSalt(byte[] value) {
        if (this.e != 0) {
            throw new CryptographicException(n.a("Can't change this property at this stage"));
        }
        this.b = (byte[])(value != null ? (byte[])value.clone() : null);
    }

    public byte[] cryptDeriveKey(String algname, String alghashname, int keySize, byte[] rgbIV) {
        if (keySize > 128) {
            throw new CryptographicException(n.a("Key Size can't be greater than 128 bits"));
        }
        throw new NotSupportedException(n.a("CspParameters not supported for PasswordDeriveBytes."));
    }

    @Override
    @Deprecated
    public byte[] getBytes(int cb2) {
        if (cb2 < 1) {
            throw new IndexOutOfBoundsException("cb");
        }
        if (this.e == 0) {
            this.reset();
            this.e = 1;
        }
        byte[] byArray = new byte[cb2];
        int n2 = 0;
        int n3 = Math.max(1, this.c - 1);
        if (this.h == null) {
            this.h = this.g;
            for (int i2 = 0; i2 < n3 - 1; ++i2) {
                this.h = this.d.computeHash(this.h);
            }
        }
        while (n2 < cb2) {
            int n4;
            byte[] byArray2 = null;
            if (this.j == 0) {
                byArray2 = this.d.computeHash(this.h);
            } else if (this.j < 1000) {
                String string = Convert.toString(this.j);
                byArray2 = new byte[this.h.length + string.length()];
                for (n4 = 0; n4 < string.length(); ++n4) {
                    byArray2[n4] = (byte)string.charAt(n4);
                }
                Buffer.blockCopy(Array.boxing(this.h), 0, Array.boxing(byArray2), string.length(), this.h.length);
                byArray2 = this.d.computeHash(byArray2);
            } else {
                throw new CryptographicException(n.a("too long"));
            }
            int n5 = byArray2.length - this.i;
            n4 = Math.min(cb2 - n2, n5);
            Buffer.blockCopy(Array.boxing(byArray2), this.i, Array.boxing(byArray), n2, n4);
            n2 += n4;
            this.i += n4;
            while (this.i >= byArray2.length) {
                this.i -= byArray2.length;
                ++this.j;
            }
        }
        return byArray;
    }

    @Override
    public void reset() {
        this.e = 0;
        this.i = 0;
        this.j = 0;
        this.d = HashAlgorithm.create(this.a);
        if (this.b != null) {
            this.d.transformBlock(this.f, 0, this.f.length, this.f, 0);
            this.d.transformFinalBlock(this.b, 0, this.b.length);
            this.g = this.d.getHash();
        } else {
            this.g = this.d.computeHash(this.f);
        }
    }
}

