/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Security.Cryptography;

import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.Enum;
import com.aspose.html.internal.ms.System.GC;
import com.aspose.html.internal.ms.System.IDisposable;
import com.aspose.html.internal.ms.System.ObjectExtensions;
import com.aspose.html.internal.ms.System.Security.Cryptography.CipherMode;
import com.aspose.html.internal.ms.System.Security.Cryptography.CryptoConfig;
import com.aspose.html.internal.ms.System.Security.Cryptography.CryptographicException;
import com.aspose.html.internal.ms.System.Security.Cryptography.ICryptoTransform;
import com.aspose.html.internal.ms.System.Security.Cryptography.KeySizes;
import com.aspose.html.internal.ms.System.Security.Cryptography.PaddingMode;
import com.aspose.html.internal.ms.System.msArray;
import com.aspose.html.internal.ms.core.System.Security.Cryptography.n;

public abstract class SymmetricAlgorithm
implements IDisposable {
    protected int BlockSizeValue;
    protected byte[] IVValue;
    protected int KeySizeValue;
    protected byte[] KeyValue;
    protected KeySizes[] LegalBlockSizesValue;
    protected KeySizes[] LegalKeySizesValue;
    protected int FeedbackSizeValue;
    protected int ModeValue = 1;
    protected int PaddingValue = 2;
    private boolean a = false;

    protected SymmetricAlgorithm() {
    }

    @Override
    public void dispose() {
        this.dispose(true);
        GC.suppressFinalize(this);
    }

    public void clear() {
        this.dispose(true);
    }

    protected void dispose(boolean disposing) {
        if (!this.a) {
            if (this.KeyValue != null) {
                msArray.clear(this.KeyValue, 0, this.KeyValue.length);
                this.KeyValue = null;
            }
            if (disposing) {
                // empty if block
            }
            this.a = true;
        }
    }

    public int getBlockSize() {
        return this.BlockSizeValue;
    }

    public void setBlockSize(int value) {
        if (!KeySizes.a(this.LegalBlockSizesValue, value)) {
            throw new CryptographicException(n.a("block size not supported by algorithm"));
        }
        if (this.BlockSizeValue != value) {
            this.BlockSizeValue = value;
            this.IVValue = null;
        }
    }

    public int getFeedbackSize() {
        return this.FeedbackSizeValue;
    }

    public void setFeedbackSize(int value) {
        if (value <= 0 || value > this.BlockSizeValue) {
            throw new CryptographicException(n.a("feedback size larger than block size"));
        }
        this.FeedbackSizeValue = value;
    }

    public byte[] getIV() {
        if (this.IVValue == null) {
            this.generateIV();
        }
        return (byte[])this.IVValue.clone();
    }

    public void setIV(byte[] value) {
        if (value == null) {
            throw new ArgumentNullException("value");
        }
        if (value.length << 3 != this.BlockSizeValue) {
            throw new CryptographicException(n.a("IV length is different than block size"));
        }
        this.IVValue = (byte[])value.clone();
    }

    public byte[] getKey() {
        if (this.KeyValue == null) {
            this.generateKey();
        }
        return (byte[])this.KeyValue.clone();
    }

    public void setKey(byte[] value) {
        if (value == null) {
            throw new ArgumentNullException("value");
        }
        int n2 = value.length << 3;
        if (!KeySizes.a(this.LegalKeySizesValue, n2)) {
            throw new CryptographicException(n.a("Key size not supported by algorithm"));
        }
        this.KeySizeValue = n2;
        this.KeyValue = (byte[])value.clone();
    }

    public int getKeySize() {
        return this.KeySizeValue;
    }

    public void setKeySize(int value) {
        if (!KeySizes.a(this.LegalKeySizesValue, value)) {
            throw new CryptographicException(n.a("Key size not supported by algorithm"));
        }
        this.KeySizeValue = value;
        this.KeyValue = null;
    }

    public KeySizes[] getLegalBlockSizes() {
        return this.LegalBlockSizesValue;
    }

    public KeySizes[] getLegalKeySizes() {
        return this.LegalKeySizesValue;
    }

    public int getMode() {
        return this.ModeValue;
    }

    public void setMode(int value) {
        if (!Enum.isDefined(CipherMode.class, (long)value)) {
            throw new CryptographicException(n.a("Cipher mode not available"));
        }
        this.ModeValue = value;
    }

    public int getPadding() {
        return this.PaddingValue;
    }

    public void setPadding(int value) {
        if (!Enum.isDefined(PaddingMode.class, (long)value)) {
            throw new CryptographicException(n.a("Padding mode not available"));
        }
        this.PaddingValue = value;
    }

    public ICryptoTransform createDecryptor() {
        return this.createDecryptor(this.getKey(), this.getIV());
    }

    public abstract ICryptoTransform createDecryptor(byte[] var1, byte[] var2);

    public ICryptoTransform createEncryptor() {
        return this.createEncryptor(this.getKey(), this.getIV());
    }

    public abstract ICryptoTransform createEncryptor(byte[] var1, byte[] var2);

    public abstract void generateIV();

    public abstract void generateKey();

    public boolean validKeySize(int bitLength) {
        return KeySizes.a(this.LegalKeySizesValue, bitLength);
    }

    public static SymmetricAlgorithm create() {
        return SymmetricAlgorithm.create("System.Security.Cryptography.SymmetricAlgorithm");
    }

    public static SymmetricAlgorithm create(String algName) {
        return (SymmetricAlgorithm)CryptoConfig.createFromName(algName);
    }

    public String toString() {
        String string = ObjectExtensions.getType(this).getName().substring(ObjectExtensions.getType(this).getName().lastIndexOf(46) + 1);
        return "System.Security.Cryptography." + string;
    }
}

