/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Security.Cryptography;

import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.Security.Cryptography.CryptoConfig;
import com.aspose.html.internal.ms.System.Security.Cryptography.CryptographicException;
import com.aspose.html.internal.ms.System.Security.Cryptography.KeySizes;
import com.aspose.html.internal.ms.System.Security.Cryptography.SymmetricAlgorithm;
import com.aspose.html.internal.ms.core.System.Security.Cryptography.n;

public abstract class TripleDES
extends SymmetricAlgorithm {
    protected TripleDES() {
        this.KeySizeValue = 192;
        this.BlockSizeValue = 64;
        this.FeedbackSizeValue = 8;
        this.LegalKeySizesValue = new KeySizes[1];
        this.LegalKeySizesValue[0] = new KeySizes(128, 192, 64);
        this.LegalBlockSizesValue = new KeySizes[1];
        this.LegalBlockSizesValue[0] = new KeySizes(64, 64, 0);
    }

    @Override
    public byte[] getKey() {
        if (this.KeyValue == null) {
            this.generateKey();
            while (TripleDES.isWeakKey(this.KeyValue)) {
                this.generateKey();
            }
        }
        return (byte[])this.KeyValue.clone();
    }

    @Override
    public void setKey(byte[] value) {
        if (value == null) {
            throw new ArgumentNullException("Key");
        }
        if (TripleDES.isWeakKey(value)) {
            throw new CryptographicException(n.a("Weak Key"));
        }
        this.KeyValue = (byte[])value.clone();
    }

    public static boolean isWeakKey(byte[] rgbKey) {
        if (rgbKey == null) {
            throw new CryptographicException(n.a("Null Key"));
        }
        if (rgbKey.length == 16) {
            for (int i2 = 0; i2 < 8; ++i2) {
                if (rgbKey[i2] == rgbKey[i2 + 8]) continue;
                return false;
            }
        } else if (rgbKey.length == 24) {
            int n2;
            boolean bl2 = true;
            for (n2 = 0; n2 < 8; ++n2) {
                if (rgbKey[n2] == rgbKey[n2 + 8]) continue;
                bl2 = false;
                break;
            }
            if (!bl2) {
                for (n2 = 8; n2 < 16; ++n2) {
                    if (rgbKey[n2] == rgbKey[n2 + 8]) continue;
                    return false;
                }
            }
        } else {
            throw new CryptographicException(n.a("Wrong Key Length"));
        }
        return true;
    }

    public static TripleDES create() {
        return TripleDES.create("System.Security.Cryptography.TripleDES");
    }

    public static TripleDES create(String str) {
        return (TripleDES)CryptoConfig.createFromName(str);
    }
}

