/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Security.Cryptography.X509Certificates;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.internal.ms.System.Collections.IEnumerator;
import com.aspose.html.internal.ms.System.DateTime;
import com.aspose.html.internal.ms.System.Environment;
import com.aspose.html.internal.ms.System.Globalization.CultureInfo;
import com.aspose.html.internal.ms.System.ObjectExtensions;
import com.aspose.html.internal.ms.System.Security.Cryptography.CryptoConfig;
import com.aspose.html.internal.ms.System.Security.Cryptography.CryptographicException;
import com.aspose.html.internal.ms.System.Security.Cryptography.CryptographicUnexpectedOperationException;
import com.aspose.html.internal.ms.System.Security.Cryptography.X509Certificates.X509Certificate;
import com.aspose.html.internal.ms.System.Security.Cryptography.X509Certificates.X509Certificate2;
import com.aspose.html.internal.ms.System.Security.Cryptography.X509Certificates.X509Certificate2Enumerator;
import com.aspose.html.internal.ms.System.Security.Cryptography.X509Certificates.X509CertificateCollection;
import com.aspose.html.internal.ms.System.Security.Cryptography.X509Certificates.X509KeyUsageExtension;
import com.aspose.html.internal.ms.System.Security.Cryptography.X509Certificates.X509SubjectKeyIdentifierExtension;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.lang.Operators;

public class X509Certificate2Collection
extends X509CertificateCollection {
    static String[] a = new String[]{Environment.get_NewLine()};

    public X509Certificate2Collection() {
    }

    public X509Certificate2Collection(X509Certificate2Collection certificates) {
        this.addRange(certificates);
    }

    public X509Certificate2Collection(X509Certificate2 certificate) {
        this.add(certificate);
    }

    public X509Certificate2Collection(X509Certificate2[] certificates) {
        this.addRange(certificates);
    }

    @Override
    public X509Certificate2 get_Item(int index) {
        if (index < 0) {
            throw new ArgumentOutOfRangeException("negative index");
        }
        if (index >= this.getInnerList().size()) {
            throw new ArgumentOutOfRangeException("index >= Count");
        }
        return (X509Certificate2)this.getInnerList().get_Item(index);
    }

    public void set_Item(int index, X509Certificate2 value) {
        this.getInnerList().set_Item(index, value);
    }

    public int add(X509Certificate2 certificate) {
        if (certificate == null) {
            throw new ArgumentNullException("certificate");
        }
        return this.getInnerList().addItem(certificate);
    }

    public void addRange(X509Certificate2[] certificates) {
        if (certificates == null) {
            throw new ArgumentNullException("certificates");
        }
        for (int i2 = 0; i2 < certificates.length; ++i2) {
            this.getInnerList().addItem(certificates[i2]);
        }
    }

    public void addRange(X509Certificate2Collection certificates) {
        if (certificates == null) {
            throw new ArgumentNullException("certificates");
        }
        this.getInnerList().addRange(certificates);
    }

    public boolean contains(X509Certificate2 certificate) {
        if (certificate == null) {
            throw new ArgumentNullException("certificate");
        }
        for (X509Certificate2 x509Certificate2 : this.getInnerList()) {
            if (!x509Certificate2.equals(certificate)) continue;
            return true;
        }
        return false;
    }

    public byte[] export(int contentType) {
        return this.export(contentType, null);
    }

    public byte[] export(int contentType, String password) {
        switch (contentType) {
            case 1: 
            case 2: 
            case 3: {
                if (this.size() <= 0) break;
                return this.get_Item(this.size() - 1).export(contentType, password);
            }
            case 5: {
                break;
            }
            case 4: {
                break;
            }
            default: {
                String string = StringExtensions.format("Cannot export certificate(s) to the '{0}' format", Operators.boxing(contentType));
                throw new CryptographicException(string);
            }
        }
        return null;
    }

    public X509Certificate2Collection find(int findType, Object findValue, boolean validOnly) {
        if (findValue == null) {
            throw new ArgumentNullException("findValue");
        }
        String string = StringExtensions.Empty;
        String string2 = StringExtensions.Empty;
        int n2 = 0;
        DateTime dateTime = DateTime.MinValue.Clone();
        switch (findType) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 14: {
                try {
                    string = (String)findValue;
                    break;
                }
                catch (RuntimeException runtimeException) {
                    String string3 = StringExtensions.format("Invalid find value type '{0}', expected '{1}'.", ObjectExtensions.getType(findValue), "string");
                    throw new CryptographicException(string3, runtimeException);
                }
            }
            case 10: 
            case 11: 
            case 12: {
                try {
                    string2 = (String)findValue;
                }
                catch (RuntimeException runtimeException) {
                    String string4 = StringExtensions.format("Invalid find value type '{0}', expected '{1}'.", ObjectExtensions.getType(findValue), "X509KeyUsageFlags");
                    throw new CryptographicException(string4, runtimeException);
                }
                try {
                    CryptoConfig.encodeOID(string2);
                    break;
                }
                catch (CryptographicUnexpectedOperationException cryptographicUnexpectedOperationException) {
                    String string5 = StringExtensions.format("Invalid OID value '{0}'.", string2);
                    throw new ArgumentException("findValue", string5);
                }
            }
            case 13: {
                try {
                    n2 = (Integer)findValue;
                    break;
                }
                catch (RuntimeException runtimeException) {
                    String string6 = StringExtensions.format("Invalid find value type '{0}', expected '{1}'.", ObjectExtensions.getType(findValue), "X509KeyUsageFlags");
                    throw new CryptographicException(string6, runtimeException);
                }
            }
            case 6: 
            case 7: 
            case 8: {
                try {
                    Operators.unboxing(findValue, DateTime.class).CloneTo(dateTime);
                    break;
                }
                catch (RuntimeException runtimeException) {
                    String string7 = StringExtensions.format("Invalid find value type '{0}', expected '{1}'.", ObjectExtensions.getType(findValue), "X509DateTime");
                    throw new CryptographicException(string7, runtimeException);
                }
            }
            default: {
                String string8 = StringExtensions.format("Invalid find type '{0}'.", Operators.boxing(findType));
                throw new CryptographicException(string8);
            }
        }
        CultureInfo cultureInfo = CultureInfo.getInvariantCulture();
        X509Certificate2Collection x509Certificate2Collection = new X509Certificate2Collection();
        for (X509Certificate2 x509Certificate2 : this.getInnerList()) {
            boolean bl2 = false;
            block12 : switch (findType) {
                case 0: {
                    bl2 = StringExtensions.compare(string, x509Certificate2.getThumbprint(), true, cultureInfo) == 0 || StringExtensions.compare(string, x509Certificate2.getCertHashString(), true, cultureInfo) == 0;
                    break;
                }
                case 1: {
                    String[] stringArray;
                    for (String string9 : stringArray = StringExtensions.split(x509Certificate2.getSubjectName().format(true), a, 1)) {
                        int n3 = StringExtensions.indexOf(string9, '=');
                        boolean bl3 = bl2 = StringExtensions.indexOf(string9, string, n3, (short)3) >= 0;
                        if (bl2) break block12;
                    }
                    break;
                }
                case 2: {
                    bl2 = StringExtensions.compare(string, x509Certificate2.getSubject(), true, cultureInfo) == 0;
                    break;
                }
                case 3: {
                    String[] stringArray = x509Certificate2.getNameInfo(0, true);
                    bl2 = StringExtensions.indexOf((String)stringArray, string, (short)3) >= 0;
                    break;
                }
                case 4: {
                    bl2 = StringExtensions.compare(string, x509Certificate2.getIssuer(), true, cultureInfo) == 0;
                    break;
                }
                case 5: {
                    bl2 = StringExtensions.compare(string, x509Certificate2.get_SerialNumber(), true, cultureInfo) == 0;
                    break;
                }
                case 9: {
                    break;
                }
                case 14: {
                    X509SubjectKeyIdentifierExtension x509SubjectKeyIdentifierExtension = Operators.as(x509Certificate2.getExtensions().get_Item("2.5.29.14"), X509SubjectKeyIdentifierExtension.class);
                    if (x509SubjectKeyIdentifierExtension == null) break;
                    bl2 = StringExtensions.compare(string, x509SubjectKeyIdentifierExtension.getSubjectKeyIdentifier(), true, cultureInfo) == 0;
                    break;
                }
                case 10: {
                    bl2 = x509Certificate2.getExtensions().size() == 0;
                    break;
                }
                case 11: {
                    break;
                }
                case 12: {
                    bl2 = x509Certificate2.getExtensions().get_Item(string2) != null;
                    break;
                }
                case 13: {
                    X509KeyUsageExtension x509KeyUsageExtension = Operators.as(x509Certificate2.getExtensions().get_Item("2.5.29.15"), X509KeyUsageExtension.class);
                    if (x509KeyUsageExtension == null) {
                        bl2 = true;
                        break;
                    }
                    bl2 = (x509KeyUsageExtension.getKeyUsages() & n2) == n2;
                    break;
                }
                case 6: {
                    bl2 = DateTime.op_GreaterThanOrEqual(dateTime, x509Certificate2.getNotBefore()) && DateTime.op_LessThanOrEqual(dateTime, x509Certificate2.getNotAfter());
                    break;
                }
                case 7: {
                    bl2 = DateTime.op_LessThan(dateTime, x509Certificate2.getNotBefore());
                    break;
                }
                case 8: {
                    bl2 = DateTime.op_GreaterThan(dateTime, x509Certificate2.getNotAfter());
                }
            }
            if (!bl2) continue;
            if (validOnly) {
                try {
                    if (!x509Certificate2.verify()) continue;
                    x509Certificate2Collection.add(x509Certificate2);
                }
                catch (RuntimeException runtimeException) {}
                continue;
            }
            x509Certificate2Collection.add(x509Certificate2);
        }
        return x509Certificate2Collection;
    }

    @Override
    public IEnumerator iterator() {
        return new X509Certificate2Enumerator(this);
    }

    public void import_(byte[] rawData) {
        X509Certificate2 x509Certificate2 = new X509Certificate2();
        x509Certificate2.import_(rawData);
        this.add(x509Certificate2);
    }

    public void import_(byte[] rawData, String password, int keyStorageFlags) {
        X509Certificate2 x509Certificate2 = new X509Certificate2();
        x509Certificate2.import_(rawData, password, keyStorageFlags);
        this.add(x509Certificate2);
    }

    public void import_(String fileName) {
        X509Certificate2 x509Certificate2 = new X509Certificate2();
        x509Certificate2.import_(fileName);
        this.add(x509Certificate2);
    }

    public void import_(String fileName, String password, int keyStorageFlags) {
        X509Certificate2 x509Certificate2 = new X509Certificate2();
        x509Certificate2.import_(fileName, password, keyStorageFlags);
        this.add(x509Certificate2);
    }

    public void insert(int index, X509Certificate2 certificate) {
        if (certificate == null) {
            throw new ArgumentNullException("certificate");
        }
        if (index < 0) {
            throw new ArgumentOutOfRangeException("negative index");
        }
        if (index >= this.getInnerList().size()) {
            throw new ArgumentOutOfRangeException("index >= Count");
        }
        this.getInnerList().insertItem(index, certificate);
    }

    public void remove(X509Certificate2 certificate) {
        if (certificate == null) {
            throw new ArgumentNullException("certificate");
        }
        for (int i2 = 0; i2 < this.getInnerList().size(); ++i2) {
            X509Certificate x509Certificate = (X509Certificate)this.getInnerList().get_Item(i2);
            if (!x509Certificate.equals(certificate)) continue;
            this.getInnerList().removeAt(i2);
            return;
        }
    }

    public void removeRange(X509Certificate2[] certificates) {
        if (certificates == null) {
            throw new ArgumentNullException("certificate");
        }
        for (X509Certificate2 x509Certificate2 : certificates) {
            this.remove(x509Certificate2);
        }
    }

    public void removeRange(X509Certificate2Collection certificates) {
        if (certificates == null) {
            throw new ArgumentNullException("certificate");
        }
        for (X509Certificate2 x509Certificate2 : certificates) {
            this.remove(x509Certificate2);
        }
    }
}

