/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Security.Cryptography.X509Certificates;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.DateTime;
import com.aspose.html.internal.ms.System.Security.Cryptography.OidCollection;
import com.aspose.html.internal.ms.System.Security.Cryptography.X509Certificates.X509Certificate2Collection;
import com.aspose.time.TimeSpan;

public final class X509ChainPolicy {
    private OidCollection a;
    private OidCollection b;
    private X509Certificate2Collection c;
    private int d;
    private int e;
    private TimeSpan f = new TimeSpan();
    private int g;
    private DateTime h = new DateTime();

    public X509ChainPolicy() {
        this.reset();
    }

    public OidCollection getApplicationPolicy() {
        return this.a;
    }

    public OidCollection getCertificatePolicy() {
        return this.b;
    }

    public X509Certificate2Collection getExtraStore() {
        return this.c;
    }

    public int getRevocationFlag() {
        return this.d;
    }

    public void setRevocationFlag(int value) {
        if (value < 0 || value > 2) {
            throw new ArgumentException("RevocationFlag");
        }
        this.d = value;
    }

    public int getRevocationMode() {
        return this.e;
    }

    public void setRevocationMode(int value) {
        if (value < 0 || value > 2) {
            throw new ArgumentException("RevocationMode");
        }
        this.e = value;
    }

    public TimeSpan getUrlRetrievalTimeout() {
        return this.f;
    }

    public void setUrlRetrievalTimeout(TimeSpan value) {
        value.CloneTo(this.f);
    }

    public int getVerificationFlags() {
        return this.g;
    }

    public void setVerificationFlags(int value) {
        if ((value | 0xFFF) != 4095) {
            throw new ArgumentException("VerificationFlags");
        }
        this.g = value;
    }

    public DateTime getVerificationTime() {
        return this.h;
    }

    public void setVerificationTime(DateTime value) {
        value.CloneTo(this.h);
    }

    public void reset() {
        this.a = new OidCollection();
        this.b = new OidCollection();
        this.c = new X509Certificate2Collection();
        this.d = 2;
        this.e = 1;
        TimeSpan.Zero.CloneTo(this.f);
        this.g = 0;
        DateTime.getNow().CloneTo(this.h);
    }
}

