/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Text;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.internal.ms.System.Text.Decoder;
import com.aspose.html.internal.ms.System.Text.DecoderFallback;
import com.aspose.html.internal.ms.System.Text.DecoderReplacementFallback;
import com.aspose.html.internal.ms.System.Text.Encoder;
import com.aspose.html.internal.ms.System.Text.EncoderFallback;
import com.aspose.html.internal.ms.System.Text.EncoderReplacementFallback;
import com.aspose.html.internal.ms.System.Text.Encoding;
import com.aspose.html.internal.ms.core.mscorlib.f.a;
import com.aspose.html.internal.ms.core.mscorlib.f.f;

public class UTF32Encoding
extends Encoding {
    static final int a = 12000;
    static final int n = 12001;
    private boolean o;
    private boolean p;

    public UTF32Encoding() {
        this(false, true, false);
    }

    public UTF32Encoding(boolean bigEndian, boolean byteOrderMark) {
        this(bigEndian, byteOrderMark, false);
    }

    public UTF32Encoding(boolean bigEndian, boolean byteOrderMark, boolean throwOnInvalidCharacters) {
        super(bigEndian ? 12001 : 12000);
        this.o = bigEndian;
        this.p = byteOrderMark;
        if (throwOnInvalidCharacters) {
            this.setFallbackInternal(EncoderFallback.getExceptionFallback(), DecoderFallback.getExceptionFallback());
        } else {
            this.setFallbackInternal(new EncoderReplacementFallback("\ufffd"), new DecoderReplacementFallback("\ufffd"));
        }
        if (bigEndian) {
            this.body_name = "utf-32BE";
            this.encoding_name = "UTF-32 (Big-Endian)";
            this.header_name = "utf-32BE";
            this.web_name = "utf-32BE";
        } else {
            this.body_name = "utf-32";
            this.encoding_name = "Unicode (UTF-32)";
            this.header_name = "utf-32";
            this.web_name = "utf-32";
        }
        this.windows_code_page = 12000;
    }

    @Override
    public int getByteCount(char[] chars, int index, int count) {
        if (chars == null) {
            throw new ArgumentNullException("chars");
        }
        if (index < 0 || index > chars.length) {
            throw new ArgumentOutOfRangeException("index", UTF32Encoding._("ArgRange_Array"));
        }
        if (count < 0 || count > chars.length - index) {
            throw new ArgumentOutOfRangeException("count", UTF32Encoding._("ArgRange_Array"));
        }
        f f2 = new f(this.o, this.getEncoderFallback());
        return f2.a(chars, index, count);
    }

    @Override
    public int getBytes(char[] chars, int charIndex, int charCount, byte[] bytes, int byteIndex) {
        int n2 = bytes.length - byteIndex;
        int n3 = this.getByteCount(chars, charIndex, charCount);
        if (n2 < n3) {
            throw new ArgumentException(UTF32Encoding._("Arg_InsufficientSpace"));
        }
        f f2 = new f(this.o, this.getEncoderFallback());
        f2.a(chars, charIndex, charCount, bytes, byteIndex);
        return n3;
    }

    @Override
    public Encoder getEncoder() {
        return new UTF32Encoder(this.o, this.getEncoderFallback());
    }

    @Override
    public int getMaxByteCount(int charCount) {
        if (charCount < 0) {
            throw new ArgumentOutOfRangeException("charCount", "Non-negative number required.");
        }
        return (charCount + 1) * 4;
    }

    @Override
    public int getMaxCharCount(int byteCount) {
        if (byteCount < 0) {
            throw new ArgumentOutOfRangeException("byteCount", "Non-negative number required.");
        }
        return byteCount / 2 + 2;
    }

    @Override
    public byte[] getPreamble() {
        if (this.p) {
            byte[] byArray = new byte[4];
            if (this.o) {
                byArray[2] = -2;
                byArray[3] = -1;
            } else {
                byArray[0] = -1;
                byArray[1] = -2;
            }
            return byArray;
        }
        return new byte[0];
    }

    @Override
    public boolean equals(Object value) {
        UTF32Encoding uTF32Encoding = value instanceof UTF32Encoding ? (UTF32Encoding)value : null;
        return uTF32Encoding != null && this.codePage == uTF32Encoding.codePage && this.o == uTF32Encoding.o && this.p == uTF32Encoding.p && super.equals(value);
    }

    @Override
    public int hashCode() {
        int n2 = super.hashCode();
        if (this.o) {
            n2 ^= 0x1F;
        }
        if (this.p) {
            n2 ^= 0x3F;
        }
        return n2;
    }

    @Override
    public int getCharCount(byte[] bytes, int index, int count) {
        com.aspose.html.internal.ms.core.mscorlib.e.f f2 = new com.aspose.html.internal.ms.core.mscorlib.e.f(this.o, this.getDecoderFallback());
        return f2.a(bytes, index, count);
    }

    @Override
    public int getChars(byte[] bytes, int byteIndex, int byteCount, char[] chars, int charIndex) {
        com.aspose.html.internal.ms.core.mscorlib.e.f f2 = new com.aspose.html.internal.ms.core.mscorlib.e.f(this.o, this.getDecoderFallback());
        return f2.a(bytes, byteIndex, byteCount, chars, charIndex);
    }

    @Override
    public Decoder getDecoder() {
        return new UTF32Decoder(this.o, this.getDecoderFallback());
    }

    private static final class UTF32Decoder
    extends com.aspose.html.internal.ms.core.mscorlib.e.a {
        public UTF32Decoder(boolean bigEndian, DecoderFallback fallback) {
            super(new com.aspose.html.internal.ms.core.mscorlib.e.f(bigEndian, fallback));
        }
    }

    private static class UTF32Encoder
    extends a {
        private UTF32Encoder(boolean bigEndian, EncoderFallback fallback) {
            super(new f(bigEndian, fallback));
        }
    }
}

