/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Threading;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.internal.ms.System.Globalization.CultureInfo;
import com.aspose.html.internal.ms.System.Guid;
import com.aspose.html.internal.ms.System.IntPtr;
import com.aspose.html.internal.ms.System.InvalidOperationException;
import com.aspose.html.internal.ms.System.MulticastDelegate;
import com.aspose.html.internal.ms.System.NotSupportedException;
import com.aspose.html.internal.ms.System.Runtime.ConstrainedExecution.CriticalFinalizerObject;
import com.aspose.html.internal.ms.System.Runtime.ConstrainedExecution.ReliabilityContractAttribute;
import com.aspose.html.internal.ms.System.Runtime.InteropServices.InAttribute;
import com.aspose.html.internal.ms.System.Runtime.InteropServices._Thread;
import com.aspose.html.internal.ms.System.SecurityException;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.ThreadStaticAttribute;
import com.aspose.html.internal.ms.System.Threading.CompressedStack;
import com.aspose.html.internal.ms.System.Threading.ExecutionContext;
import com.aspose.html.internal.ms.System.Threading.ParameterizedThreadStart;
import com.aspose.html.internal.ms.System.Threading.ThreadAbortException;
import com.aspose.html.internal.ms.System.Threading.ThreadInterruptedException;
import com.aspose.html.internal.ms.System.Threading.ThreadStart;
import com.aspose.html.internal.ms.System.Threading.ThreadStateException;
import com.aspose.time.TimeSpan;
import java.util.Locale;

public final class Thread
extends CriticalFinalizerObject
implements _Thread {
    private java.lang.Thread a;
    private CultureInfo b;
    private CultureInfo c;
    private int d = 2;
    private boolean e = false;
    private String f;
    private int g = 8;
    private Object h = new Object();
    private Object i = null;
    private boolean j = false;
    private static int k = 0;
    @ThreadStaticAttribute
    private static volatile ThreadLocal<Thread> l = new ThreadLocal();
    @ThreadStaticAttribute
    private static volatile ThreadLocal<ExecutionContext> m = new ThreadLocal();
    private Object n;
    private MulticastDelegate o;

    private Thread(java.lang.Thread thread) {
        this.a = thread;
        this.f = thread.getName();
    }

    public Thread(final ThreadStart start) {
        if (start == null) {
            throw new ArgumentNullException("Null ThreadStart");
        }
        ThreadStart threadStart = new ThreadStart(){

            @Override
            public void invoke() {
                start.invoke();
            }
        };
        this.o = threadStart;
        this.a = this.a(threadStart);
    }

    public Thread(final ThreadStart start, int maxStackSize) {
        if (start == null) {
            throw new ArgumentNullException("start");
        }
        ThreadStart threadStart = new ThreadStart(){

            @Override
            public void invoke() {
                start.invoke();
            }
        };
        this.o = threadStart;
        this.a = this.a(threadStart, maxStackSize);
    }

    public Thread(final ParameterizedThreadStart start) {
        if (start == null) {
            throw new ArgumentNullException("start");
        }
        ParameterizedThreadStart parameterizedThreadStart = new ParameterizedThreadStart(){

            @Override
            public void invoke(Object obj) {
                start.invoke(obj);
            }
        };
        this.o = parameterizedThreadStart;
        this.a = this.a(parameterizedThreadStart);
    }

    public Thread(final ParameterizedThreadStart start, int maxStackSize) {
        if (start == null) {
            throw new ArgumentNullException("start");
        }
        ParameterizedThreadStart parameterizedThreadStart = new ParameterizedThreadStart(){

            @Override
            public void invoke(Object obj) {
                start.invoke(obj);
            }
        };
        this.o = parameterizedThreadStart;
        this.a = this.a(parameterizedThreadStart, maxStackSize);
    }

    private java.lang.Thread a(final ThreadStart threadStart) {
        return new java.lang.Thread(this.a(), new Runnable(){

            @Override
            public void run() {
                threadStart.invoke();
            }
        }, this.b());
    }

    public static Thread getCurrentThread() {
        Thread thread = l.get();
        if (thread == null) {
            thread = new Thread(java.lang.Thread.currentThread());
            l.set(thread);
        }
        return thread;
    }

    public static void clearCurrentThreadLocals() {
        l.remove();
        m.remove();
    }

    private java.lang.Thread a(final ParameterizedThreadStart parameterizedThreadStart) {
        return new java.lang.Thread(this.a(), new Runnable(){

            @Override
            public void run() {
                parameterizedThreadStart.invoke(Thread.this.i);
            }
        }, this.b());
    }

    private java.lang.Thread a(final ParameterizedThreadStart parameterizedThreadStart, int n2) {
        return new java.lang.Thread(this.a(), new Runnable(){

            @Override
            public void run() {
                parameterizedThreadStart.invoke(Thread.this.i);
            }
        }, this.b(), n2);
    }

    private java.lang.Thread a(final ThreadStart threadStart, int n2) {
        return new java.lang.Thread(this.a(), new Runnable(){

            @Override
            public void run() {
                threadStart.invoke();
            }
        }, this.b(), n2);
    }

    private ThreadGroup a() {
        return java.lang.Thread.currentThread().getThreadGroup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String b() {
        Object object = this.h;
        synchronized (object) {
        }
        return StringExtensions.format("{0}_{1}", this.a(), ++k);
    }

    public void abort() {
        try {
            this.g |= 0x80;
            this.a.checkAccess();
            if (this.a.isAlive()) {
                if ((this.g & 0x40) == 64) {
                    throw new ThreadStateException();
                }
                this.a.stop();
                this.g = 256;
                throw new ThreadAbortException();
            }
            this.j = true;
        }
        catch (java.lang.SecurityException securityException) {
            throw new SecurityException(securityException.getMessage());
        }
    }

    public void abort(Object stateInfo) {
        this.set_AbortReason(stateInfo);
        try {
            this.g |= 0x80;
            this.a.checkAccess();
            if (!this.a.isAlive()) {
                this.j = true;
            }
            if ((this.g & 0x40) == 64) {
                throw new ThreadStateException();
            }
            this.a.stop();
            this.g = 256;
            throw new ThreadAbortException();
        }
        catch (java.lang.SecurityException securityException) {
            throw new SecurityException(securityException.getMessage());
        }
    }

    public Object get_AbortReason() {
        return this.n;
    }

    public void set_AbortReason(Object abortReason) {
        this.n = abortReason;
    }

    @Override
    public void finalize() throws Throwable {
        super.finalize();
    }

    public void interrupt() {
        try {
            this.g = 16;
            this.a.interrupt();
        }
        catch (java.lang.SecurityException securityException) {
            throw new SecurityException(securityException.getMessage());
        }
    }

    public void join() {
        try {
            this.g |= 0x20;
            this.a.join();
        }
        catch (InterruptedException interruptedException) {
            throw new ThreadInterruptedException();
        }
    }

    public boolean join(int timeout) {
        if (timeout < -1) {
            throw new ArgumentOutOfRangeException("timeout");
        }
        try {
            if (timeout == -1) {
                timeout = 0;
            } else if (timeout == 0) {
                timeout = 1;
            }
            this.g |= 0x20;
            this.a.join(timeout);
        }
        catch (InterruptedException interruptedException) {
            throw new ThreadInterruptedException();
        }
        return !this.a.isAlive();
    }

    public boolean join(TimeSpan timeout) {
        try {
            long l2 = (long)timeout.getTotalMilliseconds();
            if (l2 < 0L || l2 > Integer.MAX_VALUE) {
                throw new ArgumentOutOfRangeException("timeout", "timeout out of range");
            }
            this.g |= 0x20;
            this.a.join(l2);
        }
        catch (InterruptedException interruptedException) {
            throw new ThreadInterruptedException();
        }
        return !this.a.isAlive();
    }

    @Deprecated
    public void resume() {
        try {
            if (!this.a.isAlive() || (this.g & 0x40) != 64) {
                throw new ThreadStateException("The thread has not been started, is dead, or is not in the suspended state.");
            }
            this.a.resume();
            if (this.a.isAlive()) {
                this.g ^= 0x40;
            }
        }
        catch (java.lang.SecurityException securityException) {
            throw new SecurityException(securityException.getMessage());
        }
    }

    public static void sleep(int timeout) {
        if (timeout < -1) {
            throw new ArgumentOutOfRangeException("timeout");
        }
        try {
            Thread.getCurrentThread().g |= 0x20;
            if (timeout == -1) {
                java.lang.Thread.sleep(Long.MAX_VALUE);
            } else {
                java.lang.Thread.sleep(timeout);
            }
            Thread.getCurrentThread().g ^= 0x20;
        }
        catch (java.lang.SecurityException securityException) {
            throw new SecurityException(securityException.getMessage());
        }
        catch (InterruptedException interruptedException) {
            throw new ThreadInterruptedException(interruptedException.getMessage());
        }
    }

    public static void sleep(TimeSpan timeout) {
        try {
            long l2 = (long)timeout.getTotalMilliseconds();
            if (l2 < 0L || l2 > Integer.MAX_VALUE) {
                throw new ArgumentOutOfRangeException("timeout", "timeout out of range");
            }
            Thread.getCurrentThread().g |= 0x20;
            java.lang.Thread.sleep(l2);
            Thread.getCurrentThread().g ^= 0x20;
        }
        catch (java.lang.SecurityException securityException) {
            throw new SecurityException(securityException.getMessage());
        }
        catch (InterruptedException interruptedException) {
            throw new ThreadInterruptedException(interruptedException.getMessage());
        }
    }

    public void start() {
        try {
            if (!this.j) {
                if (this.a.isAlive()) {
                    throw new ThreadStateException();
                }
            } else {
                throw new ThreadStateException("Thread was aborted");
            }
            this.a.checkAccess();
            this.a.start();
            this.g = 0;
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            throw new ThreadStateException(illegalThreadStateException.getMessage());
        }
    }

    public void start(Object param) {
        if (this.o instanceof ThreadStart) {
            throw new InvalidOperationException("The thread was created with a ThreadStart delegate that does not accept a parameter.");
        }
        this.i = param;
        try {
            if (!this.j) {
                if (this.a.isAlive()) {
                    throw new ThreadStateException();
                }
                this.a.checkAccess();
                this.a.start();
                this.g = 0;
            }
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            throw new ThreadStateException(illegalThreadStateException.getMessage());
        }
    }

    @Deprecated
    public void suspend() {
        try {
            this.g = 2;
            this.a.suspend();
            this.g = 64;
        }
        catch (java.lang.SecurityException securityException) {
            throw new SecurityException(securityException.getMessage());
        }
    }

    public void setCurrentCulture(CultureInfo value) {
        if (value == null) {
            throw new ArgumentNullException("value");
        }
        if (value.isNeutralCulture()) {
            throw new NotSupportedException("Neutral cultures cannot be used in formatting and parsing and therefore cannot be set as the thread's current culture");
        }
        this.b = value;
    }

    public CultureInfo getCurrentCulture() {
        if (this.b == null) {
            this.b = CultureInfo.DEFAULT_CULTURE == null ? CultureInfo.fromJava(Locale.getDefault()) : CultureInfo.DEFAULT_CULTURE;
        }
        return this.b;
    }

    public void setCurrentUICulture(CultureInfo value) {
        if (value == null) {
            throw new ArgumentNullException("value");
        }
        this.c = value;
    }

    public CultureInfo getCurrentUICulture() {
        if (this.c == null) {
            this.c = CultureInfo.getCurrentCulture();
        }
        return this.c;
    }

    @ReliabilityContractAttribute(consistencyGuarantee=3, cer=1)
    public ExecutionContext get_ExecutionContext() {
        ExecutionContext executionContext = m.get();
        if (executionContext == null) {
            executionContext = new ExecutionContext();
            m.set(executionContext);
        }
        return executionContext;
    }

    @Deprecated
    public CompressedStack getCompressedStack() {
        CompressedStack compressedStack = this.get_ExecutionContext().getSecurityContext().getCompressedStack();
        return compressedStack == null || compressedStack.a() ? null : compressedStack.createCopy();
    }

    @Deprecated
    public void setCompressedStack(CompressedStack stack) {
        this.get_ExecutionContext().getSecurityContext().setCompressedStack(stack);
    }

    @Deprecated
    public int get_ApartmentState() {
        return this.d;
    }

    @Deprecated
    public void set_ApartmentState(int value) {
        if (value < 0 || value > 2) {
            throw new ArgumentException("value");
        }
        this.d = value;
    }

    public boolean get_IsAlive() {
        return this.a.isAlive() && !this.a.isInterrupted();
    }

    public boolean get_IsBackground() {
        if ((this.get_ThreadState() & 0x10) != 16) {
            return this.a.isDaemon();
        }
        throw new ThreadStateException();
    }

    public void set_IsBackground(boolean value) {
        try {
            this.a.setDaemon(value);
            if (value) {
                this.g |= 4;
            } else if ((this.g & 4) == 4) {
                this.g ^= 4;
            }
        }
        catch (java.lang.SecurityException securityException) {
            throw new SecurityException(securityException.getMessage());
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            throw new ThreadStateException(illegalThreadStateException.getMessage());
        }
    }

    public boolean get_IsThreadPoolThread() {
        return false;
    }

    public long get_ManagedThreadId() {
        return this.a.getId();
    }

    public String get_Name() {
        return this.f;
    }

    public void set_Name(String value) {
        if (this.e) {
            throw new InvalidOperationException("This property has already been set and cannot be modified.");
        }
        if (value != null) {
            this.a.setName(value);
        }
        this.f = value;
        this.e = true;
    }

    public int get_Priority() {
        int n2 = this.a.getPriority();
        switch (n2) {
            case 9: 
            case 10: {
                return 4;
            }
            case 7: 
            case 8: {
                return 3;
            }
            default: {
                return 2;
            }
            case 3: 
            case 4: {
                return 1;
            }
            case 1: 
            case 2: 
        }
        return 0;
    }

    public void set_Priority(int value) {
        if (value < 0 || value > 4) {
            throw new ArgumentException("value");
        }
        this.a.setPriority(value * 2 + 2);
    }

    public int get_ThreadState() {
        if (!this.a.isAlive()) {
            if (this.a.isInterrupted()) {
                return 16;
            }
            if ((this.g & 8) != 8) {
                return 16;
            }
        }
        return this.g;
    }

    @Override
    public void getIDsOfNames(@InAttribute Guid[] riid, IntPtr rgszNames, long cNames, long lcid, IntPtr rgDispId) {
    }

    @Override
    public void getTypeInfo(long iTInfo, long lcid, IntPtr ppTInfo) {
    }

    @Override
    public void getTypeInfoCount(long[] pcTInfo) {
    }

    @Override
    public void invoke(long dispIdMember, @InAttribute Guid[] riid, long lcid, short wFlags, IntPtr pDispParams, IntPtr pVarResult, IntPtr pExcepInfo, IntPtr puArgErr) {
    }
}

