/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Xml;

import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.Xml.IStaticXsltContext;
import com.aspose.html.internal.ms.System.Xml.IXmlNamespaceResolver;
import com.aspose.html.internal.ms.System.Xml.NodeTest;
import com.aspose.html.internal.ms.System.Xml.XPathException;
import com.aspose.html.internal.ms.System.Xml.XPathNavigator;
import com.aspose.html.internal.ms.System.Xml.XmlQualifiedName;

class NodeNameTest
extends NodeTest {
    protected XmlQualifiedName _name;
    protected boolean resolvedName = false;

    public NodeNameTest(int axis, XmlQualifiedName name, IStaticXsltContext ctx) {
        super(axis);
        if (ctx != null) {
            name = ctx.lookupQName(name.toString());
            this.resolvedName = true;
        }
        this._name = name;
    }

    public NodeNameTest(int axis, XmlQualifiedName name, boolean resolvedName) {
        super(axis);
        this._name = name;
        this.resolvedName = resolvedName;
    }

    NodeNameTest(NodeNameTest source, int axis) {
        super(axis);
        this._name = source._name;
        this.resolvedName = source.resolvedName;
    }

    public String toString() {
        return StringExtensions.concat(this._axis.toString(), "::", this._name.toString());
    }

    public XmlQualifiedName getName() {
        return this._name;
    }

    @Override
    public boolean match(IXmlNamespaceResolver nsm, XPathNavigator nav) {
        if (nav.getNodeType() != this._axis.getNodeType()) {
            return false;
        }
        if (!"".equals(this._name.getName()) && !StringExtensions.equals(this._name.getName(), nav.getLocalName())) {
            return false;
        }
        String string = "";
        if (!"".equals(this._name.getNamespace())) {
            if (this.resolvedName) {
                string = this._name.getNamespace();
            } else if (nsm != null) {
                string = nsm.lookupNamespace(this._name.getNamespace());
            }
            if (string == null) {
                throw new XPathException(StringExtensions.concat("Invalid namespace prefix: ", this._name.getNamespace()));
            }
        }
        return StringExtensions.equals(string, nav.getNamespaceURI());
    }

    @Override
    public void getInfo(String[] name, String[] ns, int[] nodetype, IXmlNamespaceResolver nsm) {
        nodetype[0] = this._axis.getNodeType();
        name[0] = !"".equals(this._name.getName()) ? this._name.getName() : null;
        ns[0] = "";
        if (nsm != null && !"".equals(this._name.getNamespace())) {
            ns[0] = this.resolvedName ? this._name.getNamespace() : nsm.lookupNamespace(this._name.getNamespace());
            if (ns[0] == null) {
                throw new XPathException(StringExtensions.concat("Invalid namespace prefix: ", this._name.getNamespace()));
            }
        }
    }
}

