/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Xml;

import com.aspose.html.internal.ms.System.ComponentModel.DefaultValueAttribute;
import com.aspose.html.internal.ms.System.Exception;
import com.aspose.html.internal.ms.System.Guid;
import com.aspose.html.internal.ms.System.InvalidOperationException;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.Xml.ValidationEventHandler;
import com.aspose.html.internal.ms.System.Xml.XmlAttributeAttribute;
import com.aspose.html.internal.ms.System.Xml.XmlElementAttribute;
import com.aspose.html.internal.ms.System.Xml.XmlIgnoreAttribute;
import com.aspose.html.internal.ms.System.Xml.XmlQualifiedName;
import com.aspose.html.internal.ms.System.Xml.XmlSchema;
import com.aspose.html.internal.ms.System.Xml.XmlSchemaAnnotated;
import com.aspose.html.internal.ms.System.Xml.XmlSchemaAnnotation;
import com.aspose.html.internal.ms.System.Xml.XmlSchemaComplexType;
import com.aspose.html.internal.ms.System.Xml.XmlSchemaDatatype;
import com.aspose.html.internal.ms.System.Xml.XmlSchemaForm;
import com.aspose.html.internal.ms.System.Xml.XmlSchemaObject;
import com.aspose.html.internal.ms.System.Xml.XmlSchemaReader;
import com.aspose.html.internal.ms.System.Xml.XmlSchemaSimpleType;
import com.aspose.html.internal.ms.System.Xml.XmlSchemaType;
import com.aspose.html.internal.ms.System.Xml.XmlSchemaUse;
import com.aspose.html.internal.ms.System.Xml.XmlSchemaUtil;

public class XmlSchemaAttribute
extends XmlSchemaAnnotated {
    private Object a;
    private XmlSchemaSimpleType b;
    private String c;
    private String d;
    private String e;
    private String f;
    private Object g;
    private int h = 0;
    private String i;
    private String j;
    private XmlQualifiedName k;
    private XmlQualifiedName l;
    private XmlSchemaSimpleType m;
    private XmlQualifiedName n = XmlQualifiedName.Empty;
    private int o = 0;
    private int p;
    private XmlSchemaAttribute q;
    private static final String r = "attribute";

    boolean getParentIsSchema() {
        return this.getParent() instanceof XmlSchema;
    }

    public XmlSchemaAttribute() {
        this.k = XmlQualifiedName.Empty;
        this.l = XmlQualifiedName.Empty;
    }

    @DefaultValueAttribute(stringValue="", type=String.class)
    @XmlAttributeAttribute(attributeName="default")
    public String getDefaultValue() {
        return this.c;
    }

    @DefaultValueAttribute(stringValue="", type=String.class)
    @XmlAttributeAttribute(attributeName="default")
    public void setDefaultValue(String value) {
        this.d = null;
        this.c = value;
    }

    @DefaultValueAttribute(stringValue="", type=String.class)
    @XmlAttributeAttribute(attributeName="fixed")
    public String getFixedValue() {
        return this.d;
    }

    @DefaultValueAttribute(stringValue="", type=String.class)
    @XmlAttributeAttribute(attributeName="fixed")
    public void setFixedValue(String value) {
        this.c = null;
        this.d = value;
    }

    @DefaultValueAttribute(intValue=0, type=XmlSchemaForm.class)
    @XmlAttributeAttribute(attributeName="form")
    public int getForm() {
        return this.h;
    }

    @DefaultValueAttribute(intValue=0, type=XmlSchemaForm.class)
    @XmlAttributeAttribute(attributeName="form")
    public void setForm(int value) {
        this.h = value;
    }

    @XmlAttributeAttribute(attributeName="name")
    public String getName() {
        return this.i;
    }

    @XmlAttributeAttribute(attributeName="name")
    public void setName(String value) {
        this.i = value;
    }

    @XmlAttributeAttribute(attributeName="ref")
    public XmlQualifiedName getRefName() {
        return this.l;
    }

    @XmlAttributeAttribute(attributeName="ref")
    public void setRefName(XmlQualifiedName value) {
        this.l = value;
    }

    @XmlAttributeAttribute(attributeName="type")
    public XmlQualifiedName getSchemaTypeName() {
        return this.n;
    }

    @XmlAttributeAttribute(attributeName="type")
    public void setSchemaTypeName(XmlQualifiedName value) {
        this.n = value;
    }

    @XmlElementAttribute(elementName="simpleType")
    public XmlSchemaSimpleType getSchemaType() {
        return this.m;
    }

    @XmlElementAttribute(elementName="simpleType")
    public void setSchemaType(XmlSchemaSimpleType value) {
        this.m = value;
    }

    @DefaultValueAttribute(intValue=0, type=XmlSchemaUse.class)
    @XmlAttributeAttribute(attributeName="use")
    public int getUse() {
        return this.o;
    }

    @DefaultValueAttribute(intValue=0, type=XmlSchemaUse.class)
    @XmlAttributeAttribute(attributeName="use")
    public void setUse(int value) {
        this.o = value;
    }

    @XmlIgnoreAttribute
    public XmlQualifiedName getQualifiedName() {
        return this.k;
    }

    @XmlIgnoreAttribute
    @Deprecated
    public Object getAttributeType() {
        if (this.q != null) {
            return this.q.getAttributeType();
        }
        return this.a;
    }

    @XmlIgnoreAttribute
    public XmlSchemaSimpleType getAttributeSchemaType() {
        if (this.q != null) {
            return this.q.getAttributeSchemaType();
        }
        return this.b;
    }

    String getValidatedDefaultValue() {
        return this.e;
    }

    String getValidatedFixedValue() {
        return this.f;
    }

    Object getValidatedFixedTypedValue() {
        return this.g;
    }

    int getValidatedUse() {
        return this.p;
    }

    @Override
    void setParent(XmlSchemaObject parent) {
        super.setParent(parent);
        if (this.m != null) {
            this.m.setParent(this);
        }
    }

    @Override
    int compile(ValidationEventHandler h2, XmlSchema schema) {
        if (Guid.op_Equality(this.getCompilationId(), schema.getCompilationId())) {
            return 0;
        }
        this.errorCount = 0;
        if (this.getParentIsSchema() || this.isRedefineChild) {
            if (this.getRefName() != null && !this.getRefName().isEmpty()) {
                this.error(h2, "ref must be absent in the top level <attribute>");
            }
            if (this.getForm() != 0) {
                this.error(h2, "form must be absent in the top level <attribute>");
            }
            if (this.getUse() != 0) {
                this.error(h2, "use must be absent in the top level <attribute>");
            }
            this.j = this.getAncestorSchema().getTargetNamespace();
            this.a(h2, schema, true);
        } else if (this.getRefName() == null || this.getRefName().isEmpty()) {
            this.j = this.h == 1 || this.h == 0 && schema.getAttributeFormDefault() == 1 ? this.getAncestorSchema().getTargetNamespace() : "";
            this.a(h2, schema, true);
        } else {
            if (this.i != null) {
                this.error(h2, "name must be absent if ref is present");
            }
            if (this.h != 0) {
                this.error(h2, "form must be absent if ref is present");
            }
            if (this.m != null) {
                this.error(h2, "simpletype must be absent if ref is present");
            }
            if (this.n != null && !this.n.isEmpty()) {
                this.error(h2, "type must be absent if ref is present");
            }
            this.a(h2, schema, false);
        }
        this.setCompilationId(schema.getCompilationId().Clone());
        return this.errorCount;
    }

    private void a(ValidationEventHandler validationEventHandler, XmlSchema xmlSchema, boolean bl2) {
        if (bl2) {
            if (this.getName() == null) {
                this.error(validationEventHandler, "Required attribute name must be present");
            } else if (!XmlSchemaUtil.checkNCName(this.getName())) {
                this.error(validationEventHandler, "attribute name must be NCName");
            } else if ("xmlns".equals(this.getName())) {
                this.error(validationEventHandler, "attribute name must not be xmlns");
            } else {
                this.k = new XmlQualifiedName(this.getName(), this.j);
            }
            if (this.getSchemaType() != null) {
                if (this.getSchemaTypeName() != null && !this.getSchemaTypeName().isEmpty()) {
                    this.error(validationEventHandler, "attribute can't have both a type and <simpleType> content");
                }
                this.errorCount += this.getSchemaType().compile(validationEventHandler, xmlSchema);
            }
            if (this.getSchemaTypeName() != null && !XmlSchemaUtil.checkQName(this.getSchemaTypeName())) {
                this.error(validationEventHandler, this.getSchemaTypeName() + " is not a valid QName");
            }
        } else {
            if (this.getRefName() == null || this.getRefName().isEmpty()) {
                throw new InvalidOperationException("Error: Should Never Happen. refname must be present");
            }
            this.k = this.getRefName();
        }
        if (!(!"http://www.w3.org/2001/XMLSchema-instance".equals(this.getAncestorSchema().getTargetNamespace()) || "nil".equals(this.getName()) || "type".equals(this.getName()) || "schemaLocation".equals(this.getName()) || "noNamespaceSchemaLocation".equals(this.getName()))) {
            this.error(validationEventHandler, StringExtensions.concat("targetNamespace can't be ", "http://www.w3.org/2001/XMLSchema-instance"));
        }
        if (this.getDefaultValue() != null && this.getFixedValue() != null) {
            this.error(validationEventHandler, "default and fixed must not both be present in an Attribute");
        }
        if (this.getDefaultValue() != null && this.getUse() != 0 && this.getUse() != 1) {
            this.error(validationEventHandler, "if default is present, use must be optional");
        }
        XmlSchemaUtil.compileID(this.getId(), this, xmlSchema.getIDCollection(), validationEventHandler);
    }

    @Override
    int validate(ValidationEventHandler h2, XmlSchema schema) {
        Object object;
        if (this.isValidated(schema.ValidationId.Clone())) {
            return this.errorCount;
        }
        if (this.getSchemaType() != null) {
            this.getSchemaType().validate(h2, schema);
            this.a = this.getSchemaType();
        } else if (this.getSchemaTypeName() != null && XmlQualifiedName.op_Inequality(this.getSchemaTypeName(), XmlQualifiedName.Empty)) {
            object = schema.findSchemaType(this.getSchemaTypeName());
            if (object instanceof XmlSchemaComplexType) {
                this.error(h2, "An attribute can't have complexType Content");
            } else if (object != null) {
                this.errorCount += ((XmlSchemaObject)object).validate(h2, schema);
                this.a = object;
            } else if (XmlQualifiedName.op_Equality(this.getSchemaTypeName(), XmlSchemaComplexType.AnyTypeName)) {
                this.a = XmlSchemaComplexType.getAnyType();
            } else if (XmlSchemaUtil.isBuiltInDatatypeName(this.getSchemaTypeName())) {
                this.a = XmlSchemaDatatype.fromName(this.getSchemaTypeName());
                if (this.a == null) {
                    this.error(h2, "Invalid xml schema namespace datatype was specified.");
                }
            } else if (!schema.isNamespaceAbsent(this.getSchemaTypeName().getNamespace())) {
                this.error(h2, StringExtensions.concat("Referenced schema type ", this.getSchemaTypeName(), " was not found in the corresponding schema."));
            }
        }
        if (this.getRefName() != null && XmlQualifiedName.op_Inequality(this.getRefName(), XmlQualifiedName.Empty)) {
            this.q = schema.findAttribute(this.getRefName());
            if (this.q != null) {
                this.errorCount += this.q.validate(h2, schema);
            } else if (!schema.isNamespaceAbsent(this.getRefName().getNamespace())) {
                this.error(h2, StringExtensions.concat("Referenced attribute ", this.getRefName(), " was not found in the corresponding schema."));
            }
        }
        if (this.a == null) {
            this.a = XmlSchemaSimpleType.getAnySimpleType();
        }
        if (this.c != null || this.d != null) {
            Object object2 = object = this.a instanceof XmlSchemaDatatype ? (XmlSchemaDatatype)this.a : null;
            if (object == null) {
                object = ((XmlSchemaSimpleType)this.a).getDatatype();
            }
            if (((XmlSchemaDatatype)object).getTokenizedType() == 10) {
                this.error(h2, "By the defection of the W3C XML Schema specification, it is impossible to supply QName default or fixed values.");
            } else {
                try {
                    if (this.c != null) {
                        this.e = ((XmlSchemaDatatype)object).normalize(this.c);
                        ((XmlSchemaDatatype)object).parseValue(this.e, null, null);
                    }
                }
                catch (Exception exception) {
                    XmlSchemaAttribute.error(h2, "The Attribute's default value is invalid with its type definition.", exception);
                }
                try {
                    if (this.d != null) {
                        this.f = ((XmlSchemaDatatype)object).normalize(this.d);
                        this.g = ((XmlSchemaDatatype)object).parseValue(this.f, null, null);
                    }
                }
                catch (Exception exception) {
                    XmlSchemaAttribute.error(h2, "The Attribute's fixed value is invalid with its type definition.", exception);
                }
            }
        }
        this.p = this.getUse() == 0 ? 1 : this.getUse();
        if (this.a != null) {
            XmlSchemaSimpleType xmlSchemaSimpleType = this.b = this.a instanceof XmlSchemaSimpleType ? (XmlSchemaSimpleType)this.a : null;
            if (this.a == XmlSchemaSimpleType.getAnySimpleType()) {
                this.b = XmlSchemaSimpleType.XsAnySimpleType;
            }
            if (this.b == null) {
                this.b = XmlSchemaType.getBuiltInSimpleType(this.getSchemaTypeName());
            }
        }
        schema.ValidationId.CloneTo(this.ValidationId);
        return this.errorCount;
    }

    boolean attributeEquals(XmlSchemaAttribute other) {
        return StringExtensions.equals(this.getId(), other.getId()) && !XmlQualifiedName.op_Inequality(this.getQualifiedName(), other.getQualifiedName()) && this.getAttributeType() == other.getAttributeType() && this.getValidatedUse() == other.getValidatedUse() && StringExtensions.equals(this.getValidatedDefaultValue(), other.getValidatedDefaultValue()) && StringExtensions.equals(this.getValidatedFixedValue(), other.getValidatedFixedValue());
    }

    static XmlSchemaAttribute read(XmlSchemaReader reader, ValidationEventHandler h2) {
        Object object;
        XmlSchemaAttribute xmlSchemaAttribute = new XmlSchemaAttribute();
        reader.moveToElement();
        if (!"http://www.w3.org/2001/XMLSchema".equals(reader.getNamespaceURI()) || !r.equals(reader.getLocalName())) {
            XmlSchemaAttribute.error(h2, StringExtensions.concat("Should not happen :1: XmlSchemaAttribute.Read, name=", reader.getName()), null);
            reader.skipToEnd();
            return null;
        }
        xmlSchemaAttribute.setLineNumber(reader.getLineNumber());
        xmlSchemaAttribute.setLinePosition(reader.getLinePosition());
        xmlSchemaAttribute.setSourceUri(reader.getBaseURI());
        while (reader.moveToNextAttribute()) {
            Exception exception;
            if ("default".equals(reader.getName())) {
                xmlSchemaAttribute.c = reader.getValue();
                continue;
            }
            if ("fixed".equals(reader.getName())) {
                xmlSchemaAttribute.d = reader.getValue();
                continue;
            }
            if ("form".equals(reader.getName())) {
                exception = null;
                object = new Exception[]{exception};
                xmlSchemaAttribute.h = XmlSchemaUtil.readFormAttribute(reader, object);
                exception = object[0];
                if (exception == null) continue;
                XmlSchemaAttribute.error(h2, StringExtensions.concat(reader.getValue(), " is not a valid value for form attribute"), exception);
                continue;
            }
            if ("id".equals(reader.getName())) {
                xmlSchemaAttribute.setId(reader.getValue());
                continue;
            }
            if ("name".equals(reader.getName())) {
                xmlSchemaAttribute.i = reader.getValue();
                continue;
            }
            if ("ref".equals(reader.getName())) {
                exception = null;
                object = new Exception[]{exception};
                xmlSchemaAttribute.l = XmlSchemaUtil.readQNameAttribute(reader, object);
                exception = object[0];
                if (exception == null) continue;
                XmlSchemaAttribute.error(h2, StringExtensions.concat(reader.getValue(), " is not a valid value for ref attribute"), exception);
                continue;
            }
            if ("type".equals(reader.getName())) {
                exception = null;
                object = new Exception[]{exception};
                xmlSchemaAttribute.n = XmlSchemaUtil.readQNameAttribute(reader, object);
                exception = object[0];
                if (exception == null) continue;
                XmlSchemaAttribute.error(h2, StringExtensions.concat(reader.getValue(), " is not a valid value for type attribute"), exception);
                continue;
            }
            if ("use".equals(reader.getName())) {
                exception = null;
                object = new Exception[]{exception};
                xmlSchemaAttribute.o = XmlSchemaUtil.readUseAttribute(reader, object);
                exception = object[0];
                if (exception == null) continue;
                XmlSchemaAttribute.error(h2, StringExtensions.concat(reader.getValue(), " is not a valid value for use attribute"), exception);
                continue;
            }
            if ("".equals(reader.getNamespaceURI()) && !"xmlns".equals(reader.getName()) || "http://www.w3.org/2001/XMLSchema".equals(reader.getNamespaceURI())) {
                XmlSchemaAttribute.error(h2, StringExtensions.concat(reader.getName(), " is not a valid attribute for attribute"), null);
                continue;
            }
            XmlSchemaUtil.readUnhandledAttribute(reader, xmlSchemaAttribute);
        }
        reader.moveToElement();
        if (reader.isEmptyElement()) {
            return xmlSchemaAttribute;
        }
        int n2 = 1;
        while (reader.readNextElement()) {
            if (reader.getNodeType() == 15) {
                if (r.equals(reader.getLocalName())) break;
                XmlSchemaAttribute.error(h2, StringExtensions.concat("Should not happen :2: XmlSchemaAttribute.Read, name=", reader.getName()), null);
                break;
            }
            if (n2 <= 1 && "annotation".equals(reader.getLocalName())) {
                n2 = 2;
                object = XmlSchemaAnnotation.read(reader, h2);
                if (object == null) continue;
                xmlSchemaAttribute.setAnnotation((XmlSchemaAnnotation)object);
                continue;
            }
            if (n2 <= 2 && "simpleType".equals(reader.getLocalName())) {
                n2 = 3;
                object = XmlSchemaSimpleType.read(reader, h2);
                if (object == null) continue;
                xmlSchemaAttribute.m = object;
                continue;
            }
            reader.raiseInvalidElementError();
        }
        return xmlSchemaAttribute;
    }
}

