/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Xml;

import com.aspose.html.internal.ms.System.Collections.ArrayList;
import com.aspose.html.internal.ms.System.Exception;
import com.aspose.html.internal.ms.System.Guid;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.Xml.ValidationEventHandler;
import com.aspose.html.internal.ms.System.Xml.XmlAttributeAttribute;
import com.aspose.html.internal.ms.System.Xml.XmlElementAttribute;
import com.aspose.html.internal.ms.System.Xml.XmlIgnoreAttribute;
import com.aspose.html.internal.ms.System.Xml.XmlQualifiedName;
import com.aspose.html.internal.ms.System.Xml.XmlSchema;
import com.aspose.html.internal.ms.System.Xml.XmlSchemaAnnotation;
import com.aspose.html.internal.ms.System.Xml.XmlSchemaComplexType;
import com.aspose.html.internal.ms.System.Xml.XmlSchemaDatatype;
import com.aspose.html.internal.ms.System.Xml.XmlSchemaObject;
import com.aspose.html.internal.ms.System.Xml.XmlSchemaObjectCollection;
import com.aspose.html.internal.ms.System.Xml.XmlSchemaReader;
import com.aspose.html.internal.ms.System.Xml.XmlSchemaSimpleType;
import com.aspose.html.internal.ms.System.Xml.XmlSchemaSimpleTypeContent;
import com.aspose.html.internal.ms.System.Xml.XmlSchemaType;
import com.aspose.html.internal.ms.System.Xml.XmlSchemaUtil;

public class XmlSchemaSimpleTypeUnion
extends XmlSchemaSimpleTypeContent {
    private XmlSchemaObjectCollection a = new XmlSchemaObjectCollection();
    private XmlQualifiedName[] b;
    private static final String c = "union";
    private Object[] d;
    private XmlSchemaSimpleType[] e;

    @XmlElementAttribute(elementName="simpleType", type=XmlSchemaSimpleType.class)
    public XmlSchemaObjectCollection getBaseTypes() {
        return this.a;
    }

    @XmlAttributeAttribute(attributeName="memberTypes")
    public XmlQualifiedName[] getMemberTypes() {
        return this.b;
    }

    @XmlAttributeAttribute(attributeName="memberTypes")
    public void setMemberTypes(XmlQualifiedName[] value) {
        this.b = value;
    }

    @XmlIgnoreAttribute
    public XmlSchemaSimpleType[] getBaseMemberTypes() {
        return this.e;
    }

    Object[] getValidatedTypes() {
        return this.d;
    }

    @Override
    void setParent(XmlSchemaObject parent) {
        super.setParent(parent);
        for (XmlSchemaObject xmlSchemaObject : this.getBaseTypes()) {
            xmlSchemaObject.setParent(this);
        }
    }

    @Override
    int compile(ValidationEventHandler h2, XmlSchema schema) {
        if (Guid.op_Equality(this.getCompilationId(), schema.getCompilationId())) {
            return 0;
        }
        this.errorCount = 0;
        int n2 = this.getBaseTypes().size();
        for (XmlSchemaObject xmlSchemaObject : this.a) {
            if (xmlSchemaObject != null && xmlSchemaObject instanceof XmlSchemaSimpleType) {
                XmlSchemaSimpleType xmlSchemaSimpleType = (XmlSchemaSimpleType)xmlSchemaObject;
                this.errorCount += xmlSchemaSimpleType.compile(h2, schema);
                continue;
            }
            this.error(h2, "baseTypes can't have objects other than a simpletype");
        }
        if (this.b != null) {
            for (int i2 = 0; i2 < this.b.length; ++i2) {
                if (this.b[i2] == null || !XmlSchemaUtil.checkQName(this.getMemberTypes()[i2])) {
                    this.error(h2, "Invalid membertype");
                    this.b[i2] = XmlQualifiedName.Empty;
                    continue;
                }
                n2 += this.getMemberTypes().length;
            }
        }
        if (n2 == 0) {
            this.error(h2, "Atleast one simpletype or membertype must be present");
        }
        XmlSchemaUtil.compileID(this.getId(), this, schema.getIDCollection(), h2);
        this.setCompilationId(schema.getCompilationId().Clone());
        return this.errorCount;
    }

    @Override
    int validate(ValidationEventHandler h2, XmlSchema schema) {
        if (this.isValidated(schema.ValidationId.Clone())) {
            return this.errorCount;
        }
        ArrayList arrayList = new ArrayList();
        if (this.getMemberTypes() != null) {
            for (XmlQualifiedName xmlQualifiedName : this.getMemberTypes()) {
                XmlSchemaSimpleType xmlSchemaSimpleType;
                Object object = null;
                XmlSchemaType xmlSchemaType = schema.findSchemaType(xmlQualifiedName);
                XmlSchemaSimpleType xmlSchemaSimpleType2 = xmlSchemaSimpleType = xmlSchemaType instanceof XmlSchemaSimpleType ? (XmlSchemaSimpleType)xmlSchemaType : null;
                if (xmlSchemaSimpleType != null) {
                    this.errorCount += ((XmlSchemaObject)xmlSchemaSimpleType).validate(h2, schema);
                    object = xmlSchemaSimpleType;
                } else if (XmlQualifiedName.op_Equality(xmlQualifiedName, XmlSchemaComplexType.AnyTypeName)) {
                    object = XmlSchemaSimpleType.getAnySimpleType();
                } else if ("http://www.w3.org/2001/XMLSchema".equals(xmlQualifiedName.getNamespace()) || "http://www.w3.org/2003/11/xpath-datatypes".equals(xmlQualifiedName.getNamespace())) {
                    object = XmlSchemaDatatype.fromName(xmlQualifiedName);
                    if (object == null) {
                        this.error(h2, "Invalid schema type name was specified: " + xmlQualifiedName);
                    }
                } else if (!schema.isNamespaceAbsent(xmlQualifiedName.getNamespace())) {
                    this.error(h2, StringExtensions.concat("Referenced base schema type ", xmlQualifiedName, " was not found in the corresponding schema."));
                }
                arrayList.addItem(object);
            }
        }
        if (this.getBaseTypes() != null) {
            for (XmlSchemaSimpleType xmlSchemaSimpleType : this.getBaseTypes()) {
                xmlSchemaSimpleType.validate(h2, schema);
                arrayList.addItem(xmlSchemaSimpleType);
            }
        }
        this.d = arrayList.toArray();
        if (this.d != null) {
            this.e = new XmlSchemaSimpleType[this.d.length];
            for (int i2 = 0; i2 < this.d.length; ++i2) {
                XmlSchemaSimpleType xmlSchemaSimpleType;
                Object object = this.d[i2];
                XmlSchemaSimpleType xmlSchemaSimpleType3 = xmlSchemaSimpleType = object instanceof XmlSchemaSimpleType ? (XmlSchemaSimpleType)object : null;
                if (xmlSchemaSimpleType == null && object != null) {
                    xmlSchemaSimpleType = XmlSchemaType.getBuiltInSimpleType(((XmlSchemaDatatype)object).getTypeCode());
                }
                this.e[i2] = xmlSchemaSimpleType;
            }
        }
        schema.ValidationId.CloneTo(this.ValidationId);
        return this.errorCount;
    }

    static XmlSchemaSimpleTypeUnion read(XmlSchemaReader reader, ValidationEventHandler h2) {
        Object object;
        XmlSchemaSimpleTypeUnion xmlSchemaSimpleTypeUnion = new XmlSchemaSimpleTypeUnion();
        reader.moveToElement();
        if (!"http://www.w3.org/2001/XMLSchema".equals(reader.getNamespaceURI()) || !c.equals(reader.getLocalName())) {
            XmlSchemaSimpleTypeUnion.error(h2, StringExtensions.concat("Should not happen :1: XmlSchemaSimpleTypeUnion.Read, name=", reader.getName()), null);
            reader.skip();
            return null;
        }
        xmlSchemaSimpleTypeUnion.setLineNumber(reader.getLineNumber());
        xmlSchemaSimpleTypeUnion.setLinePosition(reader.getLinePosition());
        xmlSchemaSimpleTypeUnion.setSourceUri(reader.getBaseURI());
        while (reader.moveToNextAttribute()) {
            if ("id".equals(reader.getName())) {
                xmlSchemaSimpleTypeUnion.setId(reader.getValue());
                continue;
            }
            if ("memberTypes".equals(reader.getName())) {
                Exception exception = null;
                object = XmlSchemaUtil.splitList(reader.getValue());
                xmlSchemaSimpleTypeUnion.b = new XmlQualifiedName[((String[])object).length];
                for (int i2 = 0; i2 < ((String[])object).length; ++i2) {
                    Exception[] exceptionArray = new Exception[]{exception};
                    xmlSchemaSimpleTypeUnion.b[i2] = XmlSchemaUtil.toQName(reader, object[i2], exceptionArray);
                    exception = exceptionArray[0];
                    if (exception == null) continue;
                    XmlSchemaSimpleTypeUnion.error(h2, StringExtensions.concat("'", object[i2], "' is not a valid memberType"), exception);
                }
                continue;
            }
            if ("".equals(reader.getNamespaceURI()) && !"xmlns".equals(reader.getName()) || "http://www.w3.org/2001/XMLSchema".equals(reader.getNamespaceURI())) {
                XmlSchemaSimpleTypeUnion.error(h2, StringExtensions.concat(reader.getName(), " is not a valid attribute for union"), null);
                continue;
            }
            XmlSchemaUtil.readUnhandledAttribute(reader, xmlSchemaSimpleTypeUnion);
        }
        reader.moveToElement();
        if (reader.isEmptyElement()) {
            return xmlSchemaSimpleTypeUnion;
        }
        int n2 = 1;
        while (reader.readNextElement()) {
            if (reader.getNodeType() == 15) {
                if (c.equals(reader.getLocalName())) break;
                XmlSchemaSimpleTypeUnion.error(h2, StringExtensions.concat("Should not happen :2: XmlSchemaSimpleTypeUnion.Read, name=", reader.getName()), null);
                break;
            }
            if (n2 <= 1 && "annotation".equals(reader.getLocalName())) {
                n2 = 2;
                object = XmlSchemaAnnotation.read(reader, h2);
                if (object == null) continue;
                xmlSchemaSimpleTypeUnion.setAnnotation((XmlSchemaAnnotation)object);
                continue;
            }
            if (n2 <= 2 && "simpleType".equals(reader.getLocalName())) {
                n2 = 2;
                object = XmlSchemaSimpleType.read(reader, h2);
                if (object == null) continue;
                xmlSchemaSimpleTypeUnion.a.add((XmlSchemaObject)object);
                continue;
            }
            reader.raiseInvalidElementError();
        }
        return xmlSchemaSimpleTypeUnion;
    }
}

