/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Xml;

import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.Uri;

class XmlSchemaUri
extends Uri {
    public String value;

    static boolean hasValidScheme(String src) {
        int n2 = StringExtensions.indexOf(src, ':');
        if (n2 < 0) {
            return false;
        }
        block3: for (int i2 = 0; i2 < n2; ++i2) {
            switch (src.charAt(i2)) {
                case '+': 
                case '-': 
                case '.': {
                    continue block3;
                }
                default: {
                    if (Character.isLetterOrDigit(src.charAt(i2))) continue block3;
                    return false;
                }
            }
        }
        return true;
    }

    public XmlSchemaUri(String src) {
        this(src, XmlSchemaUri.hasValidScheme(src));
    }

    private XmlSchemaUri(String src, boolean formal) {
        super(formal ? src : StringExtensions.concat("anyuri:", src), !formal);
        this.value = src;
    }

    public static boolean op_Equality(XmlSchemaUri v1, XmlSchemaUri v2) {
        return StringExtensions.equals(v1.value, v2.value);
    }

    public static boolean op_Inequality(XmlSchemaUri v1, XmlSchemaUri v2) {
        return !StringExtensions.equals(v1.value, v2.value);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof XmlSchemaUri) {
            return XmlSchemaUri.op_Equality((XmlSchemaUri)obj, this);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public String toString() {
        return this.value;
    }
}

