/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing;

import com.aspose.html.drawing.Color;
import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.Drawing.Bitmap;
import com.aspose.html.internal.ms.System.Drawing.Graphics;
import com.aspose.html.internal.ms.System.Drawing.Image;
import com.aspose.html.internal.ms.System.Drawing.Point;
import com.aspose.html.internal.ms.System.Drawing.SizeF;
import com.aspose.html.internal.ms.System.Exception;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;

public class GraphicsUtils {
    private static final double[] a = new double[]{1.0, 1.0, 1.0, (double)GraphicsUtils.getDefaultScreenResolution() / 72.0, GraphicsUtils.getDefaultScreenResolution(), (double)GraphicsUtils.getDefaultScreenResolution() / 300.0, (double)GraphicsUtils.getDefaultScreenResolution() / (double)25.4f};
    private static int b;
    private static float c;
    private static float d;

    public static boolean unitPixelOrDisplay(int gu2) {
        return gu2 == 1 || gu2 == 2 || gu2 == 0;
    }

    public static int compareDpi(float first, float second) {
        return GraphicsUtils.compareFloat(first, second, 0.03f);
    }

    public static int compareFloat(double first, double second) {
        return GraphicsUtils.compareFloat(first, second, 0.005f);
    }

    public static int compareFloat(double first, double second, float diff) {
        double d2 = first - second;
        return Math.abs(d2) < (double)diff ? 0 : (int)Math.signum(d2);
    }

    public static float roundFloat(double value) {
        return GraphicsUtils.roundFloat(value, 8);
    }

    public static float roundFloat(double value, int digits) {
        double d2 = value;
        if (digits > 0 && digits <= 8 && Math.abs(value) < 1.0E7) {
            double d3 = (long)Math.pow(10.0, digits);
            d2 = (double)Math.round(d2 * d3) / d3;
        }
        return (float)d2;
    }

    public static int getDefaultScreenResolution() {
        return GraphicsUtils.isHeadless() ? 96 : Toolkit.getDefaultToolkit().getScreenResolution();
    }

    public static Dimension getScreenSize() {
        return GraphicsUtils.isHeadless() ? new Dimension(800, 600) : Toolkit.getDefaultToolkit().getScreenSize();
    }

    public static boolean isHeadless() {
        if (b == 0) {
            boolean bl2 = GraphicsEnvironment.isHeadless();
            if (!bl2) {
                try {
                    Toolkit.getDefaultToolkit();
                }
                catch (Exception exception) {
                    bl2 = true;
                }
            }
            b = bl2 ? 2 : 1;
        }
        return b > 1;
    }

    public static double[] getUnitConversion() {
        return a;
    }

    public static float unitConversion(int fromUnit, int toUnit, float nSrc) {
        double d2 = 0.0;
        double d3 = 0.0;
        switch (fromUnit) {
            case 1: {
                d2 = nSrc / GraphicsUtils.getSystemDpiY();
                break;
            }
            case 5: {
                d2 = nSrc / 300.0f;
                break;
            }
            case 4: {
                d2 = nSrc;
                break;
            }
            case 6: {
                d2 = nSrc / 25.4f;
                break;
            }
            case 0: 
            case 2: {
                d2 = nSrc / GraphicsUtils.getSystemDpiY();
                break;
            }
            case 3: {
                d2 = nSrc / 72.0f;
                break;
            }
            default: {
                throw new ArgumentException("Invalid GraphicsUnit");
            }
        }
        switch (toUnit) {
            case 1: {
                d3 = d2 * (double)GraphicsUtils.getSystemDpiY();
                break;
            }
            case 5: {
                d3 = d2 * 300.0;
                break;
            }
            case 4: {
                d3 = d2;
                break;
            }
            case 6: {
                d3 = d2 * (double)25.4f;
                break;
            }
            case 0: 
            case 2: {
                d3 = d2 * (double)GraphicsUtils.getSystemDpiY();
                break;
            }
            case 3: {
                d3 = d2 * 72.0;
                break;
            }
            default: {
                throw new ArgumentException("Invalid GraphicsUnit");
            }
        }
        return (float)d3;
    }

    public static float getSystemDpiX() {
        if (c == 0.0f) {
            Bitmap bitmap = new Bitmap(1, 1);
            Graphics graphics = Graphics.fromImage(bitmap);
            c = graphics.getDpiX();
            d = graphics.getDpiY();
        }
        return c;
    }

    public static float getSystemDpiY() {
        if (d == 0.0f) {
            Bitmap bitmap = new Bitmap(1, 1);
            Graphics graphics = Graphics.fromImage(bitmap);
            c = graphics.getDpiX();
            d = graphics.getDpiY();
        }
        return d;
    }

    public static SizeF convertDpi(SizeF value, float dpiXFrom, float dpiYFrom, float dpiXTo, float dpiYTo) {
        return new SizeF(GraphicsUtils.convertDpi(value.getWidth(), dpiXFrom, dpiXTo), GraphicsUtils.convertDpi(value.getHeight(), dpiYFrom, dpiYTo));
    }

    public static float convertDpi(float value, float dpiFrom, float dpiTo) {
        return value * dpiTo / dpiFrom;
    }

    public static float changeUnitOfValueOld(int fromUnit, int toUnit, float newDpi, float srcValue) {
        float f2 = srcValue;
        double d2 = 0.0;
        double d3 = f2;
        float f3 = GraphicsUtils.getSystemDpiY();
        if (!(fromUnit != toUnit || newDpi == f3 || fromUnit == 1 && toUnit == 2 || toUnit == 1 && fromUnit == 2 || toUnit == 2 && fromUnit == 2)) {
            return f2 * newDpi / f3;
        }
        if (!(fromUnit == toUnit || fromUnit == 1 && toUnit == 2 || toUnit == 1 && fromUnit == 2)) {
            switch (fromUnit) {
                case 1: {
                    d2 = f2 / f3;
                    break;
                }
                case 5: {
                    d2 = f2 / 300.0f;
                    break;
                }
                case 4: {
                    d2 = f2;
                    break;
                }
                case 6: {
                    d2 = f2 / 25.4f;
                    break;
                }
                case 0: 
                case 2: {
                    d2 = f2 / f3;
                    break;
                }
                case 3: {
                    d2 = f2 / 72.0f;
                    break;
                }
                default: {
                    throw new ArgumentException("Invalid GraphicsUnit");
                }
            }
            switch (toUnit) {
                case 1: {
                    d3 = d2 * (double)newDpi;
                    break;
                }
                case 5: {
                    d3 = d2 * 300.0 * (double)(newDpi / f3);
                    break;
                }
                case 4: {
                    d3 = d2 * (double)(newDpi / f3);
                    break;
                }
                case 6: {
                    d3 = d2 * (double)25.4f * (double)(newDpi / f3);
                    break;
                }
                case 0: 
                case 2: {
                    d3 = d2 * (double)newDpi;
                    break;
                }
                case 3: {
                    d3 = d2 * (double)newDpi;
                    break;
                }
                default: {
                    throw new ArgumentException("Invalid GraphicsUnit");
                }
            }
        }
        float f4 = (float)d3;
        return f4;
    }

    public static float changeUnitOfValue(int fromUnit, int toUnit, float newDpi, float srcValue) {
        float f2 = srcValue;
        double d2 = 0.0;
        double d3 = f2;
        float f3 = GraphicsUtils.getSystemDpiY();
        if (!(fromUnit != toUnit || newDpi == f3 || fromUnit == 1 && toUnit == 2 || toUnit == 1 && fromUnit == 2 || toUnit == 2 && fromUnit == 2)) {
            return f2 * newDpi / f3;
        }
        if (!(fromUnit == toUnit || fromUnit == 1 && toUnit == 2 || toUnit == 1 && fromUnit == 2)) {
            switch (fromUnit) {
                case 1: {
                    d2 = f2 / f3;
                    break;
                }
                case 5: {
                    d2 = f2 / 300.0f;
                    break;
                }
                case 4: {
                    d2 = f2;
                    break;
                }
                case 6: {
                    d2 = f2 / 25.4f;
                    break;
                }
                case 0: 
                case 2: {
                    d2 = f2 / f3;
                    break;
                }
                case 3: {
                    d2 = f2 / 72.0f;
                    break;
                }
                default: {
                    throw new ArgumentException("Invalid GraphicsUnit");
                }
            }
            switch (toUnit) {
                case 1: {
                    d3 = d2 * (double)newDpi;
                    break;
                }
                case 5: {
                    d3 = d2 * (double)newDpi;
                    break;
                }
                case 4: {
                    d3 = d2 * (double)newDpi;
                    break;
                }
                case 6: {
                    d3 = d2 * (double)newDpi;
                    break;
                }
                case 0: 
                case 2: {
                    d3 = d2 * (double)newDpi;
                    break;
                }
                case 3: {
                    d3 = d2 * (double)newDpi;
                    break;
                }
                default: {
                    throw new ArgumentException("Invalid GraphicsUnit");
                }
            }
        }
        float f4 = (float)d3;
        return f4;
    }

    public static AffineTransform getFinalTransform(AffineTransform transform, int pageUnit, float pageScale) {
        double d2;
        AffineTransform affineTransform = null;
        if (pageUnit != 1 && Math.abs((d2 = (double)pageScale * a[pageUnit]) - 1.0) > (double)1.4E-45f) {
            affineTransform = AffineTransform.getScaleInstance(d2, d2);
        }
        if (affineTransform != null) {
            affineTransform.concatenate(transform);
        } else {
            affineTransform = transform;
        }
        return affineTransform;
    }

    public static Bitmap smoothSimple(Bitmap src) {
        int n2;
        int n3;
        Bitmap bitmap = null;
        if (Image.isIndexedPixelFormat(src.getPixelFormat())) {
            bitmap = new Bitmap(src.getWidth(), src.getHeight(), 2498570);
            Graphics graphics = Graphics.fromImage(bitmap);
            graphics.drawImage((Image)src, new Point(0, 0));
        } else {
            bitmap = (Bitmap)src.deepClone();
        }
        int n4 = src.getWidth();
        int n5 = src.getHeight();
        int[][][] nArray = new int[n4][n5][4];
        for (n3 = 0; n3 < n4; ++n3) {
            for (n2 = 0; n2 < n5; ++n2) {
                Color color = src.getPixel(n3, n2);
                nArray[n3][n2][0] = color.getA() & 0xFF;
                nArray[n3][n2][1] = color.getR() & 0xFF;
                nArray[n3][n2][2] = color.getG() & 0xFF;
                nArray[n3][n2][3] = color.getB() & 0xFF;
            }
        }
        for (n3 = 0; n3 < n4; ++n3) {
            for (n2 = 0; n2 < n5; ++n2) {
                int n6 = 0;
                int n7 = 0;
                int n8 = 0;
                int n9 = 0;
                n6 += nArray[n3][n2][0];
                n7 += nArray[n3][n2][1];
                n8 += nArray[n3][n2][2];
                n9 += nArray[n3][n2][3];
                int n10 = Math.max(0, n3 - 1);
                int n11 = Math.min(n4 - 1, n3 + 1);
                int n12 = Math.max(0, n2 - 1);
                int n13 = Math.min(n5 - 1, n2 + 1);
                n6 += nArray[n10][n2][0];
                n7 += nArray[n10][n2][1];
                n8 += nArray[n10][n2][2];
                n9 += nArray[n10][n2][3];
                n6 += nArray[n3][n13][0];
                n7 += nArray[n3][n13][1];
                n8 += nArray[n3][n13][2];
                n9 += nArray[n3][n13][3];
                n6 += nArray[n3][n12][0];
                n7 += nArray[n3][n12][1];
                n8 += nArray[n3][n12][2];
                n9 += nArray[n3][n12][3];
                bitmap.setPixel(n3, n2, Color.fromArgb(((n6 += nArray[n11][n2][0]) / 5 + nArray[n3][n2][0]) / 2, ((n7 += nArray[n11][n2][1]) / 5 + nArray[n3][n2][1]) / 2, ((n8 += nArray[n11][n2][2]) / 5 + nArray[n3][n2][2]) / 2, ((n9 += nArray[n11][n2][3]) / 5 + nArray[n3][n2][3]) / 2));
            }
        }
        return bitmap;
    }

    static {
        c = 0.0f;
        d = 0.0f;
    }
}

