/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

public abstract class AwtUtils {
    public static int[] getColors(BufferedImage image) {
        WritableRaster writableRaster = image.getRaster();
        int n2 = image.getHeight();
        int n3 = image.getWidth();
        int[] nArray = new int[n3 * n2];
        switch (image.getType()) {
            case 0: 
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                AwtUtils.a(image, n3, n2, nArray);
                break;
            }
            case 1: {
                AwtUtils.a(writableRaster, nArray);
                break;
            }
            case 2: {
                AwtUtils.b(writableRaster, nArray);
                break;
            }
            case 4: {
                AwtUtils.c(writableRaster, nArray);
                break;
            }
            case 5: {
                AwtUtils.a(writableRaster, n3, n2, nArray);
                break;
            }
            case 6: {
                AwtUtils.b(writableRaster, n3, n2, nArray);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unexpected image type %s", image.getType()));
            }
        }
        return nArray;
    }

    private static void a(BufferedImage bufferedImage, int n2, int n3, int[] nArray) {
        ColorModel colorModel = bufferedImage.getColorModel();
        WritableRaster writableRaster = bufferedImage.getRaster();
        Object object = AwtUtils.createDataBufferData(writableRaster);
        int n4 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            for (int i3 = 0; i3 < n2; ++i3) {
                int n5 = colorModel.getRGB(writableRaster.getDataElements(i3, i2, object));
                nArray[n4++] = n5;
            }
        }
    }

    private static void a(Raster raster, int[] nArray) {
        DataBufferInt dataBufferInt = (DataBufferInt)raster.getDataBuffer();
        int[] nArray2 = dataBufferInt.getData();
        System.arraycopy(nArray2, 0, nArray, 0, nArray.length);
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray[i2] = AwtUtils.verifyA(nArray[i2]);
        }
    }

    public static int verifyA(int argb) {
        int n2 = argb >>> 24 & 0xFF;
        int n3 = argb >>> 16 & 0xFF;
        int n4 = argb >>> 8 & 0xFF;
        int n5 = argb & 0xFF;
        if (n2 != 0) {
            return argb;
        }
        n2 = 255;
        return (n2 << 24) + (n3 << 16) + (n4 << 8) + n5;
    }

    private static void b(Raster raster, int[] nArray) {
        DataBufferInt dataBufferInt = (DataBufferInt)raster.getDataBuffer();
        int[] nArray2 = dataBufferInt.getData();
        System.arraycopy(nArray2, 0, nArray, 0, nArray.length);
    }

    private static void c(Raster raster, int[] nArray) {
        DataBufferInt dataBufferInt = (DataBufferInt)raster.getDataBuffer();
        int[] nArray2 = dataBufferInt.getData();
        for (int i2 = 0; i2 < nArray2.length; ++i2) {
            int n2;
            int n3 = nArray2[i2];
            int n4 = n3 >> 16 & 0xFF;
            int n5 = n3 >> 8 & 0xFF;
            int n6 = n3 & 0xFF;
            nArray[i2] = n2 = 0xFF000000 | n6 << 16 | n5 << 8 | n4;
        }
    }

    private static void a(Raster raster, int n2, int n3, int[] nArray) {
        DataBufferByte dataBufferByte = (DataBufferByte)raster.getDataBuffer();
        byte[] byArray = dataBufferByte.getData();
        int n4 = 0;
        int n5 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            for (int i3 = 0; i3 < n2; ++i3) {
                int n6 = byArray[n5++] & 0xFF;
                int n7 = byArray[n5++] & 0xFF;
                int n8 = byArray[n5++] & 0xFF;
                int n9 = 0xFF000000 | n8 << 16 | n7 << 8 | n6;
                nArray[n4++] = n9;
            }
        }
    }

    private static void b(Raster raster, int n2, int n3, int[] nArray) {
        DataBufferByte dataBufferByte = (DataBufferByte)raster.getDataBuffer();
        byte[] byArray = dataBufferByte.getData();
        int n4 = 0;
        int n5 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            for (int i3 = 0; i3 < n2; ++i3) {
                int n6 = byArray[n5++] & 0xFF;
                int n7 = byArray[n5++] & 0xFF;
                int n8 = byArray[n5++] & 0xFF;
                int n9 = byArray[n5++] & 0xFF;
                int n10 = n6 << 24 | n9 << 16 | n8 << 8 | n7;
                nArray[n4++] = n10;
            }
        }
    }

    public static void setColors(int[] argbColors, BufferedImage dstImage) {
        WritableRaster writableRaster = dstImage.getRaster();
        int n2 = dstImage.getHeight();
        int n3 = dstImage.getWidth();
        switch (dstImage.getType()) {
            case 0: 
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                AwtUtils.b(dstImage, n3, n2, argbColors);
                break;
            }
            case 1: 
            case 2: {
                AwtUtils.d(writableRaster, argbColors);
                break;
            }
            case 4: {
                AwtUtils.e(writableRaster, argbColors);
                break;
            }
            case 5: {
                AwtUtils.c(writableRaster, n3, n2, argbColors);
                break;
            }
            case 6: {
                AwtUtils.d(writableRaster, n3, n2, argbColors);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unexpected image type %s", dstImage.getType()));
            }
        }
    }

    private static void b(BufferedImage bufferedImage, int n2, int n3, int[] nArray) {
        ColorModel colorModel = bufferedImage.getColorModel();
        WritableRaster writableRaster = bufferedImage.getRaster();
        Object object = AwtUtils.createDataBufferData(writableRaster);
        int n4 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            for (int i3 = 0; i3 < n2; ++i3) {
                int n5 = nArray[n4++];
                writableRaster.setDataElements(i3, i2, colorModel.getDataElements(n5, object));
            }
        }
    }

    private static void d(Raster raster, int[] nArray) {
        DataBufferInt dataBufferInt = (DataBufferInt)raster.getDataBuffer();
        int[] nArray2 = dataBufferInt.getData();
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
    }

    private static void e(Raster raster, int[] nArray) {
        DataBufferInt dataBufferInt = (DataBufferInt)raster.getDataBuffer();
        int[] nArray2 = dataBufferInt.getData();
        for (int i2 = 0; i2 < nArray2.length; ++i2) {
            int n2;
            int n3 = nArray[i2];
            int n4 = n3 >> 16 & 0xFF;
            int n5 = n3 >> 8 & 0xFF;
            int n6 = n3 & 0xFF;
            nArray2[i2] = n2 = 0xFF000000 | n6 << 16 | n5 << 8 | n4;
        }
    }

    private static void c(Raster raster, int n2, int n3, int[] nArray) {
        DataBufferByte dataBufferByte = (DataBufferByte)raster.getDataBuffer();
        byte[] byArray = dataBufferByte.getData();
        int n4 = 0;
        int n5 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            for (int i3 = 0; i3 < n2; ++i3) {
                int n6 = nArray[n4++];
                byte by2 = (byte)(n6 >> 16 & 0xFF);
                byte by3 = (byte)(n6 >> 8 & 0xFF);
                byte by4 = (byte)(n6 & 0xFF);
                byArray[n5++] = by4;
                byArray[n5++] = by3;
                byArray[n5++] = by2;
            }
        }
    }

    private static void d(Raster raster, int n2, int n3, int[] nArray) {
        DataBufferByte dataBufferByte = (DataBufferByte)raster.getDataBuffer();
        byte[] byArray = dataBufferByte.getData();
        int n4 = 0;
        int n5 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            for (int i3 = 0; i3 < n2; ++i3) {
                int n6 = nArray[n4++];
                byte by2 = (byte)(n6 >> 24 & 0xFF);
                byte by3 = (byte)(n6 >> 16 & 0xFF);
                byte by4 = (byte)(n6 >> 8 & 0xFF);
                byte by5 = (byte)(n6 & 0xFF);
                byArray[n5++] = by2;
                byArray[n5++] = by5;
                byArray[n5++] = by4;
                byArray[n5++] = by3;
            }
        }
    }

    public static Object createDataBufferData(Raster raster) {
        int n2 = raster.getDataBuffer().getDataType();
        switch (n2) {
            case 0: {
                return new byte[raster.getNumBands()];
            }
            case 1: {
                return new short[raster.getNumBands()];
            }
            case 3: {
                return new int[raster.getNumBands()];
            }
            case 4: {
                return new float[raster.getNumBands()];
            }
            case 5: {
                return new double[raster.getNumBands()];
            }
        }
        throw new IllegalArgumentException("Unknown data buffer type: " + n2);
    }
}

