/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core;

import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.internal.ms.System.Array;
import com.aspose.html.internal.ms.System.IndexOutOfRangeException;

public class ArrayHelper {
    public static boolean areArraysEqual(Array array1, Array array2) {
        int n2;
        int n3 = array1 == null ? 0 : array1.getLength();
        int n4 = n2 = array2 == null ? 0 : array2.getLength();
        if (n3 == n2) {
            if (n3 > 0) {
                for (int i2 = 0; i2 < n3; ++i2) {
                    Object object = array1.getValue(i2);
                    Object object2 = array2.getValue(i2);
                    if (object == null && object2 == null) continue;
                    if (object != null && object2 != null) {
                        if (object.equals(object2)) continue;
                        return false;
                    }
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public static void validateArrayOffsets(Array array, int offset, int count) {
        ArrayHelper.validateArrayOffsets(array, offset, count, "array", "offset", "count");
    }

    public static void validateArrayOffsets(Array array, int offset, int count, String arrayParameterName, String offsetParameterName, String countParameterName) {
        ArrayHelper.validateArrayNotNull(array, arrayParameterName);
        ArrayHelper.validateParameterIsPositive(count, countParameterName);
        ArrayHelper.validateParameterIsPositive(offset, offsetParameterName);
        if (array.getLength() <= offset && offset != 0) {
            throw new ArgumentOutOfRangeException(offsetParameterName, "The specified starting offset lies outside of the array bounds.");
        }
        if (array.getLength() < offset + count) {
            throw new ArgumentOutOfRangeException(countParameterName, "The specified ending offset lies outside of the array bounds.");
        }
    }

    public static void validateParameterIsPositive(int parameter, String parameterName) {
        if (parameter < 0) {
            throw new ArgumentOutOfRangeException(parameterName, "Non-negative number required.");
        }
    }

    public static void validateParameterIsPositive(long parameter, String parameterName) {
        if (parameter < 0L) {
            throw new ArgumentOutOfRangeException(parameterName, "Non-negative number required.");
        }
    }

    public static void validateArrayNotNull(Array array, String arrayParameterName) {
        if (array == null) {
            throw new ArgumentNullException(arrayParameterName);
        }
    }

    public static byte[] copyByte(byte[] source) {
        byte[] byArray = null;
        if (source != null) {
            byArray = new byte[source.length];
            System.arraycopy(source, 0, byArray, 0, source.length);
        }
        return byArray;
    }

    public static short[] copyInt16(short[] source) {
        short[] sArray = null;
        if (source != null) {
            sArray = new short[source.length];
            System.arraycopy(source, 0, sArray, 0, source.length);
        }
        return sArray;
    }

    public static int[] copyUInt16(int[] source) {
        int[] nArray = null;
        if (source != null) {
            nArray = new int[source.length];
            System.arraycopy(source, 0, nArray, 0, source.length);
        }
        return nArray;
    }

    public static int[] copyInt32(int[] source) {
        int[] nArray = null;
        if (source != null) {
            nArray = new int[source.length];
            System.arraycopy(source, 0, nArray, 0, source.length);
        }
        return nArray;
    }

    public static long[] copyUInt32(long[] source) {
        long[] lArray = null;
        if (source != null) {
            lArray = new long[source.length];
            System.arraycopy(source, 0, lArray, 0, source.length);
        }
        return lArray;
    }

    public static byte[] copySByte(byte[] source) {
        byte[] byArray = null;
        if (source != null) {
            byArray = new byte[source.length];
            System.arraycopy(source, 0, byArray, 0, source.length);
        }
        return byArray;
    }

    public static float[] copySingle(float[] source) {
        float[] fArray = null;
        if (source != null) {
            fArray = new float[source.length];
            System.arraycopy(source, 0, fArray, 0, source.length);
        }
        return fArray;
    }

    public static double[] copyDouble(double[] source) {
        double[] dArray = null;
        if (source != null) {
            dArray = new double[source.length];
            System.arraycopy(source, 0, dArray, 0, source.length);
        }
        return dArray;
    }

    public static int[] getColors(int size) {
        return new int[size];
    }

    public static void clear(byte[] array, int index, int length) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (length < 0) {
            throw new IndexOutOfRangeException("Non-negative number required.");
        }
        if (index > array.length - length) {
            throw new IndexOutOfRangeException("index + length > size");
        }
        for (int i2 = index; i2 < index + length; ++i2) {
            array[i2] = 0;
        }
    }

    public static void clear(int[] array, int index, int length) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (length < 0) {
            throw new IndexOutOfRangeException("Non-negative number required.");
        }
        if (index > array.length - length) {
            throw new IndexOutOfRangeException("index + length > size");
        }
        for (int i2 = index; i2 < index + length; ++i2) {
            array[i2] = 0;
        }
    }

    public static void clear(long[] array, int index, int length) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (length < 0) {
            throw new IndexOutOfRangeException("Non-negative number required.");
        }
        if (index > array.length - length) {
            throw new IndexOutOfRangeException("index + length > size");
        }
        for (int i2 = index; i2 < index + length; ++i2) {
            array[i2] = 0L;
        }
    }
}

