/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core;

import com.aspose.html.internal.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.internal.ms.System.Array;
import com.aspose.html.internal.ms.System.Buffer;
import com.aspose.html.internal.ms.System.OutOfMemoryException;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.Rectangle;

public class BufferHelper {
    private static int a;

    public static int getMaxAllowedAllocation() {
        return a;
    }

    public static void setMaxAllowedAllocation(int value) {
        a = value;
    }

    public static byte[] allocate(long bytesCount) {
        if (bytesCount <= 0L) {
            throw new ArgumentOutOfRangeException("bytesCount", "Expected positive number of bytes.");
        }
        long l2 = bytesCount;
        byte[] byArray = null;
        int n2 = 2;
        while (byArray == null) {
            try {
                if (a > 0 && l2 > (long)a) {
                    throw new OutOfMemoryException();
                }
                byArray = new byte[(int)l2];
            }
            catch (OutOfMemoryException outOfMemoryException) {
                long l3 = l2 / (long)n2;
                if (l2 > 1L && l3 == 0L) {
                    l3 = 1L;
                }
                l2 = l3;
                n2 <<= 1;
                if (l2 != 0L) continue;
                throw outOfMemoryException;
            }
        }
        return byArray;
    }

    public static int[] allocateInt(long bytesCount) {
        long l2 = bytesCount;
        int[] nArray = null;
        int n2 = 2;
        while (nArray == null) {
            try {
                if (a > 0 && l2 > (long)a) {
                    throw new OutOfMemoryException();
                }
                nArray = new int[(int)l2];
            }
            catch (OutOfMemoryException outOfMemoryException) {
                long l3 = l2 / (long)n2;
                if (l2 > 1L && l3 == 0L) {
                    l3 = 1L;
                }
                l2 = l3;
                n2 <<= 1;
                if (l2 != 0L) continue;
                throw outOfMemoryException;
            }
        }
        return nArray;
    }

    public static byte[] fillDataSubset(byte[] data, int width, int height, byte[] subset, Rectangle desiredSubset, boolean alwaysCopy) {
        int n2 = desiredSubset.getRight();
        int n3 = desiredSubset.getLeft();
        int n4 = desiredSubset.getTop();
        int n5 = desiredSubset.getBottom();
        int n6 = desiredSubset.getWidth();
        int n7 = desiredSubset.getHeight();
        if (n3 == 0 && n2 == width && n4 == 0 && n5 == height) {
            if (alwaysCopy) {
                int n8 = width * height;
                Buffer.blockCopy(Array.boxing(data), 0, Array.boxing(subset), 0, n8);
            } else {
                subset = data;
            }
        } else {
            boolean bl2;
            boolean bl3 = bl2 = n3 == 0 && n2 == width;
            if (bl2) {
                int n9 = n4 * width;
                int n10 = n6 * n7;
                Buffer.blockCopy(Array.boxing(data), n9, Array.boxing(subset), 0, n10);
            } else {
                int n11 = n6;
                int n12 = n4 * width + n3;
                for (int i2 = 0; i2 < n7; ++i2) {
                    int n13 = n12 + i2 * width;
                    Buffer.blockCopy(Array.boxing(data), n13, Array.boxing(subset), i2 * n11, n11);
                }
            }
        }
        return subset;
    }
}

