/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core;

import com.aspose.html.internal.ms.System.DoubleExtensions;
import com.aspose.html.internal.ms.System.msMath;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.ArrayHelper;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.Cache;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.ColorHelper;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.ColorInfo;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.DisposableObject;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.Point;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.Rectangle;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.Resampler;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.StreamContainer;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IPartialPixelLoader;
import java.awt.Color;

class LanczosResampler
extends Resampler {
    private static final int a = 3;
    private final int b;
    private final int c;
    private final double[][] d;
    private FilterProcessor e;

    public LanczosResampler(int width, int height, int newWidth, int newHeight, IPartialPixelLoader finalProcessor) {
        super(width, height, newWidth, newHeight, finalProcessor);
        this.b = width;
        this.c = height;
        this.d = LanczosResampler.a(this.getScaleX(), this.getScaleY());
    }

    @Override
    public void process(Rectangle pixelsRectangle, int[] pixels, Point start, Point end) {
        if (pixelsRectangle.getWidth() == this.b && pixelsRectangle.getHeight() == this.c && pixelsRectangle.getLeft() == 0 & pixelsRectangle.getTop() == 0) {
            FastFilterProcessor fastFilterProcessor = new FastFilterProcessor(this.b, this.c, this.d);
            fastFilterProcessor.setData(pixels);
            for (int i2 = 0; i2 < pixelsRectangle.getHeight(); ++i2) {
                this.a(fastFilterProcessor, i2);
            }
        } else {
            boolean bl2;
            int n2;
            if (this.e == null) {
                n2 = 7 * this.b;
                this.e = new FastFilterProcessor(this.b, this.c, this.d);
                bl2 = false;
                try {
                    this.e.prepareData(n2);
                    bl2 = true;
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    // empty catch block
                }
                if (!bl2) {
                    this.e = new SlowFilterProcessor(this.b, this.c, this.d);
                    this.e.prepareData(n2);
                }
            }
            for (n2 = 0; n2 < pixelsRectangle.getHeight(); ++n2) {
                this.e.fillData(pixels, n2 * pixelsRectangle.getWidth(), pixelsRectangle.getWidth(), pixelsRectangle.getTop() + n2);
                if (pixelsRectangle.getRight() % this.b != 0) continue;
                boolean bl3 = bl2 = pixelsRectangle.getBottom() == this.c && n2 == pixelsRectangle.getHeight() - 1;
                if (bl2) {
                    for (int i3 = 0; i3 <= 3; ++i3) {
                        this.a(this.e, pixelsRectangle.getTop() + n2 + i3 - 3);
                    }
                    continue;
                }
                this.a(this.e, pixelsRectangle.getTop() + n2 - 3);
            }
        }
    }

    @Override
    protected void releaseManagedResources() {
        if (this.e != null) {
            this.e.dispose();
        }
        super.releaseManagedResources();
    }

    private static double[][] a(double d2, double d3) {
        double[][] dArray = new double[7][7];
        for (int i2 = -3; i2 <= 3; ++i2) {
            double d4 = (double)i2 * d3;
            double d5 = 3.0 * msMath.sin(d4 * Math.PI) * msMath.sin(d4 * Math.PI / 3.0) / (Math.PI * Math.PI * d4 * d4);
            if (DoubleExtensions.isNaN(d5)) {
                d5 = 1.0;
            }
            for (int i3 = -3; i3 <= 3; ++i3) {
                double d6;
                double d7 = (double)i3 * d2;
                double d8 = 3.0 * msMath.sin(d7 * Math.PI) * msMath.sin(d7 * Math.PI / 3.0) / (Math.PI * Math.PI * d7 * d7);
                if (DoubleExtensions.isNaN(d8)) {
                    d8 = 1.0;
                }
                dArray[i3 + 3][i2 + 3] = d6 = d8 * d5;
            }
        }
        return dArray;
    }

    private void a(FilterProcessor filterProcessor, int n2) {
        Rectangle rectangle;
        if (n2 >= 0 && (rectangle = this.getProjectedRectangle(new Rectangle(0, n2, this.b, 1)).Clone()).getWidth() > 0 && rectangle.getHeight() > 0) {
            int n3 = rectangle.getLeft();
            int n4 = rectangle.getTop();
            ColorInfo colorInfo = ColorHelper.allocate(rectangle.Clone());
            int n5 = colorInfo.getRectangle().getWidth();
            int n6 = 0;
            int n7 = rectangle.getWidth() * rectangle.getHeight();
            int n8 = colorInfo.getRectangle().getWidth();
            int n9 = colorInfo.getRectangle().getHeight();
            int n10 = 0;
            int n11 = 0;
            double d2 = this.getInvertScaleX();
            double d3 = this.getInvertScaleY();
            IPartialPixelLoader iPartialPixelLoader = this.getFinalProcessor();
            while (n6 < n7) {
                int n12;
                int n13 = n3 + n10 + n8;
                if (n13 > rectangle.getRight()) {
                    n8 -= n13 - rectangle.getRight();
                }
                if ((n12 = n4 + n11 + n9) > rectangle.getBottom()) {
                    n9 -= n12 - rectangle.getBottom();
                }
                for (int i2 = 0; i2 < n9; ++i2) {
                    for (int i3 = 0; i3 < n8; ++i3) {
                        int n14 = (int)(d2 * ((double)(i3 + n3 + n10) + 0.5));
                        int n15 = (int)(d3 * ((double)(i2 + n4 + n11) + 0.5));
                        Color color = filterProcessor.applyLanczosFilter(n14, n15);
                        colorInfo.getColors()[i3 + i2 * n5] = ColorHelper.toArgb(color);
                    }
                }
                Rectangle rectangle2 = new Rectangle(n3 + n10, n4 + n11, n8, n9);
                iPartialPixelLoader.process(rectangle2.Clone(), colorInfo.getColors(), rectangle2.getLocation().Clone(), new Point(rectangle2.getRight(), rectangle2.getBottom()));
                n6 += n8 * n9;
                if (n9 > 1) {
                    n11 += n9;
                    continue;
                }
                if ((n10 += n8) < rectangle.getWidth()) continue;
                n10 = 0;
                ++n11;
                n8 = colorInfo.getRectangle().getWidth();
            }
        }
    }

    private static class SlowFilterProcessor
    extends FilterProcessor {
        private StreamContainer a;
        private int b;
        private int c;

        public SlowFilterProcessor(int width, int height, double[][] lancrosFilter) {
            super(width, height, lancrosFilter);
        }

        @Override
        public void prepareData(int size) {
            this.a = Cache.allocate(size * 4);
        }

        @Override
        public void fillData(int[] pixels, int startIndex, int count, int realRowIndex) {
            if ((long)this.b == this.a.getLength()) {
                this.b = 0;
            }
            this.a.seek(this.b * 4, 0);
            byte[] byArray = new byte[4];
            for (int i2 = 0; i2 < count; ++i2) {
                int n2 = pixels[startIndex++];
                byArray[0] = (byte)(n2 >> 24);
                byArray[1] = (byte)(n2 >> 16 & 0xFF);
                byArray[2] = (byte)(n2 >> 8 & 0xFF);
                byArray[3] = (byte)(n2 & 0xFF);
                this.a.write(byArray);
                ++this.b;
            }
            this.c = realRowIndex;
        }

        @Override
        public Color applyLanczosFilter(int indexX, int indexY) {
            int n2;
            int n3;
            int n4 = msMath.max(0, indexX - 3);
            int n5 = msMath.min(this.width - 1, indexX + 3);
            int n6 = msMath.max(0, indexY - 3);
            int n7 = msMath.min(this.height - 1, indexY + 3);
            long l2 = this.b - (this.c - n7) * this.width;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            double d6 = 0.0;
            for (n3 = n7; n3 >= n6; --n3) {
                if ((l2 -= (long)this.width) < 0L) {
                    l2 = this.a.getLength() - (long)this.width;
                }
                this.a.seek((l2 + (long)n4) * 4L, 0);
                byte[] byArray = new byte[4];
                for (n2 = n4; n2 <= n5; ++n2) {
                    double d7 = this.lancrosFilter[n2 - indexX + 3][n3 - indexY + 3];
                    this.a.read(byArray);
                    byte by2 = byArray[0];
                    byte by3 = byArray[1];
                    byte by4 = byArray[2];
                    byte by5 = byArray[3];
                    d2 += d7 * (double)(by2 & 0xFF);
                    d3 += d7 * (double)(by3 & 0xFF);
                    d4 += d7 * (double)(by4 & 0xFF);
                    d5 += d7 * (double)(by5 & 0xFF);
                    d6 += d7;
                }
            }
            n3 = (int)(d3 / d6 + 0.5);
            int n8 = (int)(d4 / d6 + 0.5);
            n2 = (int)(d5 / d6 + 0.5);
            int n9 = (int)(d2 / d6 + 0.5);
            if (n3 < 0) {
                n3 = 0;
            }
            if (n8 < 0) {
                n8 = 0;
            }
            if (n2 < 0) {
                n2 = 0;
            }
            if (n9 < 0) {
                n9 = 0;
            }
            if (n3 > 255) {
                n3 = 255;
            }
            if (n8 > 255) {
                n8 = 255;
            }
            if (n2 > 255) {
                n2 = 255;
            }
            if (n9 > 255) {
                n9 = 255;
            }
            return ColorHelper.fromArgb(n9, n3, n8, n2);
        }

        @Override
        protected void releaseManagedResources() {
            this.a.dispose();
            super.releaseManagedResources();
        }
    }

    private static class FastFilterProcessor
    extends FilterProcessor {
        private int[] a;
        private int b;
        private int c;

        public FastFilterProcessor(int width, int height, double[][] lancrosFilter) {
            super(width, height, lancrosFilter);
        }

        public void setData(int[] pixels) {
            this.a = pixels;
            this.c = pixels.length / this.width - 1;
            this.b = this.a.length;
        }

        @Override
        public void prepareData(int size) {
            this.a = ArrayHelper.getColors(size);
        }

        @Override
        public void fillData(int[] pixels, int startIndex, int count, int realRowIndex) {
            if (this.b == this.a.length) {
                this.b = 0;
            }
            for (int i2 = 0; i2 < count; ++i2) {
                int n2 = pixels[startIndex++];
                this.a[this.b++] = n2;
            }
            this.c = realRowIndex;
        }

        @Override
        public Color applyLanczosFilter(int indexX, int indexY) {
            int n2;
            int n3;
            int n4 = msMath.max(0, indexX - 3);
            int n5 = msMath.min(this.width - 1, indexX + 3);
            int n6 = msMath.max(0, indexY - 3);
            int n7 = msMath.min(this.height - 1, indexY + 3);
            int n8 = this.b - (this.c - n7) * this.width;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            double d6 = 0.0;
            for (n3 = n7; n3 >= n6; --n3) {
                if ((n8 -= this.width) < 0) {
                    n8 = this.a.length - this.width;
                }
                for (n2 = n4; n2 <= n5; ++n2) {
                    double d7 = this.lancrosFilter[n2 - indexX + 3][n3 - indexY + 3];
                    int n9 = this.a[n2 + n8];
                    byte by2 = (byte)(n9 >> 24);
                    byte by3 = (byte)(n9 >> 16 & 0xFF);
                    byte by4 = (byte)(n9 >> 8 & 0xFF);
                    byte by5 = (byte)(n9 & 0xFF);
                    d2 += d7 * (double)(by2 & 0xFF);
                    d3 += d7 * (double)(by3 & 0xFF);
                    d4 += d7 * (double)(by4 & 0xFF);
                    d5 += d7 * (double)(by5 & 0xFF);
                    d6 += d7;
                }
            }
            n3 = (int)(d3 / d6 + 0.5);
            n2 = (int)(d4 / d6 + 0.5);
            int n10 = (int)(d5 / d6 + 0.5);
            int n11 = (int)(d2 / d6 + 0.5);
            if (n3 < 0) {
                n3 = 0;
            }
            if (n2 < 0) {
                n2 = 0;
            }
            if (n10 < 0) {
                n10 = 0;
            }
            if (n11 < 0) {
                n11 = 0;
            }
            if (n3 > 255) {
                n3 = 255;
            }
            if (n2 > 255) {
                n2 = 255;
            }
            if (n10 > 255) {
                n10 = 255;
            }
            if (n11 > 255) {
                n11 = 255;
            }
            return ColorHelper.fromArgb(n11, n3, n2, n10);
        }
    }

    private static abstract class FilterProcessor
    extends DisposableObject {
        protected final double[][] lancrosFilter;
        protected final int width;
        protected final int height;

        protected FilterProcessor(int width, int height, double[][] lancrosFilter) {
            this.lancrosFilter = lancrosFilter;
            this.width = width;
            this.height = height;
        }

        public abstract void prepareData(int var1);

        public abstract void fillData(int[] var1, int var2, int var3, int var4);

        public abstract Color applyLanczosFilter(int var1, int var2);
    }
}

