/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core;

import com.aspose.html.internal.ms.System.Globalization.CultureInfo;
import com.aspose.html.internal.ms.System.SerializableAttribute;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.msMath;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.PointF;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.Size;
import com.aspose.html.internal.ms.lang.Struct;

@SerializableAttribute
public class Point
extends Struct<Point> {
    static final String PointFormat = "{{X={0}, Y={1}}}";
    private static final Point a = new Point();
    private int b;
    private int c;

    public Point() {
    }

    public Point(int x2, int y2) {
        this.b = x2;
        this.c = y2;
    }

    public Point(Size size) {
        this.b = size.getWidth();
        this.c = size.getHeight();
    }

    public Point(int dw2) {
        this.b = (short)Point.a(dw2);
        this.c = (short)Point.b(dw2);
    }

    public static Point getEmpty() {
        return a;
    }

    public boolean isEmpty() {
        return this.b == 0 && this.c == 0;
    }

    public int getX() {
        return this.b;
    }

    public void setX(int value) {
        this.b = value;
    }

    public int getY() {
        return this.c;
    }

    public void setY(int value) {
        this.c = value;
    }

    public static Point add(Point point, Size size) {
        return new Point(point.getX() + size.getWidth(), point.getY() + size.getHeight());
    }

    public static Point subtract(Point point, Size size) {
        return new Point(point.getX() - size.getWidth(), point.getY() - size.getHeight());
    }

    public static Point ceiling(PointF point) {
        return new Point((int)msMath.ceiling(point.getX()), (int)msMath.ceiling(point.getY()));
    }

    public static Point round(PointF point) {
        return new Point((int)msMath.round(point.getX()), (int)msMath.round(point.getY()));
    }

    public static Point truncate(PointF point) {
        return new Point((int)point.getX(), (int)point.getY());
    }

    public static Point op_Addition(Point point, Size size) {
        return Point.add(point.Clone(), size.Clone());
    }

    public static Point op_Subtraction(Point point, Size size) {
        return Point.subtract(point.Clone(), size.Clone());
    }

    public static boolean op_Equality(Point point1, Point point2) {
        return point1.b == point2.b && point1.c == point2.c;
    }

    public static boolean op_Inequality(Point point1, Point point2) {
        return !Point.op_Equality(point1, point2);
    }

    public static Size to_Size(Point point) {
        return new Size(point.getX(), point.getY());
    }

    public static PointF to_PointF(Point point) {
        return new PointF(point.getX(), point.getY());
    }

    public void offset(Point point) {
        this.offset(point.getX(), point.getY());
    }

    public void offset(int dx2, int dy2) {
        this.setX(this.getX() + dx2);
        this.setY(this.getY() + dy2);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Point)) {
            return false;
        }
        Point point = ((Point)obj).Clone();
        return point.getX() == this.getX() && point.getY() == this.getY();
    }

    public int hashCode() {
        return this.b ^ this.c;
    }

    public String toString() {
        return StringExtensions.format(CultureInfo.getCurrentCulture(), PointFormat, this.b, this.c);
    }

    private static int a(int n2) {
        return n2 & 0xFFFF;
    }

    private static int b(int n2) {
        return n2 >> 16 & 0xFFFF;
    }

    @Override
    public void CloneTo(Point that) {
        that.b = this.b;
        that.c = this.c;
    }

    @Override
    public Point Clone() {
        Point point = new Point();
        this.CloneTo(point);
        return point;
    }

    public Object clone() {
        return this.Clone();
    }

    public static boolean equals(Point obj1, Point obj2) {
        return obj1.equals(obj2);
    }
}

