/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.colorconverters;

import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.internal.ms.System.Int32Extensions;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.msMath;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.ColorPalette;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.PixelDataFormat;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.Rectangle;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IColorPalette;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IIndexedColorConverter;
import com.aspose.html.internal.ms.lang.Operators;

public abstract class ColorConverter {
    public final Rectangle DesiredRectangle = new Rectangle();
    public final int DestinationEndBit;
    public final int DestinationEndByte;
    public final PixelDataFormat DestinationFormat;
    public final int DestinationLineSize;
    public final int DestinationPixelSize;
    public final int DestinationStartBit;
    public final int DestinationStartByte;
    public final int Height;
    public final int LineSize;
    public final int RightmostDestinationByte;
    public final PixelDataFormat SourceFormat;
    public final int SourcePixelSize;
    public final int Width;
    private final int a;

    protected ColorConverter(int width, int height, int lineSize, PixelDataFormat sourceFormat, Rectangle desiredRectangle, PixelDataFormat destinationFormat, int destinationLineSize) {
        this.Width = width;
        this.Height = height;
        this.LineSize = lineSize;
        this.SourceFormat = sourceFormat;
        desiredRectangle.CloneTo(this.DesiredRectangle);
        this.DestinationLineSize = destinationLineSize;
        this.DestinationFormat = destinationFormat;
        this.DestinationPixelSize = destinationFormat.getBitsPerPixel();
        this.DestinationStartBit = this.DesiredRectangle.getLeft() * this.DestinationPixelSize;
        this.DestinationEndBit = this.DesiredRectangle.getRight() * this.DestinationPixelSize - 1;
        this.DestinationStartByte = this.DestinationStartBit / 8;
        this.DestinationEndByte = this.DestinationEndBit / 8;
        int n2 = this.DestinationEndByte - this.DestinationStartByte + 1;
        if (destinationLineSize < n2) {
            throw new ArgumentOutOfRangeException("destinationLineSize", StringExtensions.concat("Expected at least ", Int32Extensions.toString(n2), " bytes for the line size, otherwise the destination data does not fit."));
        }
        this.SourcePixelSize = sourceFormat.getBitsPerPixel();
        int n3 = (this.SourcePixelSize * this.Width + 7) / 8;
        if (lineSize < n3) {
            throw new ArgumentOutOfRangeException("lineSize", StringExtensions.concat("Expected at least ", Int32Extensions.toString(n3), " bytes for the line size, otherwise the source data does not fit."));
        }
        this.RightmostDestinationByte = (width * this.DestinationPixelSize - 1) / 8;
        this.a = (this.DesiredRectangle.getRight() * this.SourcePixelSize - 1) / 8;
    }

    public int convert(Rectangle rectangle, byte[] data, int dataOffset, byte[] outputData, int outputDataOffset) {
        if (data == null) {
            throw new ArgumentNullException("data");
        }
        if (data.length - dataOffset <= 0 || data.length - dataOffset > data.length) {
            throw new ArgumentOutOfRangeException("dataOffset", "Incorrect data offset.");
        }
        if (outputData == null) {
            throw new ArgumentNullException("outputData");
        }
        if (outputData.length - outputDataOffset < 0 || outputData.length - outputDataOffset > outputData.length) {
            throw new ArgumentOutOfRangeException("outputDataOffset", "Incorrect output data offset.");
        }
        int n2 = 0;
        Rectangle rectangle2 = Rectangle.intersect(this.DesiredRectangle.Clone(), rectangle.Clone()).Clone();
        int n3 = rectangle2.getWidth();
        int n4 = rectangle2.getHeight();
        int n5 = rectangle2.getLeft();
        int n6 = rectangle.getLeft();
        if (n3 > 0 && n4 > 0) {
            int n7 = n5 * this.SourcePixelSize;
            int n8 = (rectangle2.getTop() - rectangle.getTop()) * this.LineSize;
            int n9 = n7 / 8 - n6 * this.SourcePixelSize / 8;
            int n10 = n9 + n8 + dataOffset;
            int n11 = this.getDestinationLineBytesCount(n7, n3, n4);
            n2 = n11 * n4;
            if (outputData.length - outputDataOffset < n2) {
                String string = StringExtensions.format("Not enough data to convert to, expected {0} bytes but got only {1} free bytes", Operators.boxing(n2), Operators.boxing(outputData.length - outputDataOffset));
                throw new ArgumentOutOfRangeException("outputData", string);
            }
            this.convert(data, n10, n7, n3, n4, outputData, outputDataOffset, n11);
        }
        return n2;
    }

    protected static IColorPalette correctPaletteEntries(IColorPalette sourcePalette, int pixelSize) {
        int n2 = (int)msMath.pow(2.0, pixelSize);
        IColorPalette iColorPalette = sourcePalette;
        if (sourcePalette.getEntriesCount() < n2) {
            int[] nArray = sourcePalette.getArgb32Entries();
            int[] nArray2 = new int[n2];
            System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
            iColorPalette = new ColorPalette(nArray2);
        }
        return iColorPalette;
    }

    protected static byte[] getConversionMap(IIndexedColorConverter indexedConverter, PixelDataFormat sourceFormat, PixelDataFormat destFormat, int sourcePixelEntries, int destPixelEntries) {
        if (indexedConverter == null) {
            throw new ArgumentNullException("indexedConverter");
        }
        byte[] byArray = new byte[sourcePixelEntries];
        indexedConverter.fillIndexedtoIndexedMap(byArray, sourceFormat, destFormat);
        for (int i2 = 0; i2 < sourcePixelEntries; ++i2) {
            if ((byArray[i2] & 0xFF) < destPixelEntries) continue;
            throw new ArgumentOutOfRangeException("indexedConverter", StringExtensions.concat("The converted value at map index ", Int32Extensions.toString(i2), " is not valid since it goes out of destination entries range."));
        }
        return byArray;
    }

    protected abstract void convert(byte[] var1, int var2, int var3, int var4, int var5, byte[] var6, int var7, int var8);

    protected int getDestinationLineBytesCount(int bitStart, int samplesCount, int linesCount) {
        int n2 = bitStart / this.SourcePixelSize * this.DestinationPixelSize;
        int n3 = n2 / 8;
        int n4 = (n2 + samplesCount * this.DestinationPixelSize - 1) / 8;
        int n5 = n4 - n3 + 1;
        if (n3 == 0 && n4 == this.RightmostDestinationByte && linesCount > 1) {
            n5 = this.DestinationLineSize;
        } else {
            int n6;
            int n7;
            int n8 = this.SourcePixelSize / this.DestinationPixelSize;
            if (n8 > 1 && (n7 = (n6 = bitStart + samplesCount * this.SourcePixelSize - 1) / 8) % n8 < n8 - 1 && n7 != this.a) {
                --n5;
            }
        }
        return n5;
    }
}

