/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.colorconverters;

import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.PixelDataFormat;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.Rectangle;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.colorconverters.ColorConverter;

public final class FastColorConverter
extends ColorConverter {
    private final boolean a;

    public FastColorConverter(int width, int height, int lineSize, Rectangle desiredRectangle, int destinationLineSize, PixelDataFormat pixelFormat) {
        super(width, height, lineSize, pixelFormat, desiredRectangle.Clone(), pixelFormat, destinationLineSize);
        this.a = this.DestinationLineSize == this.LineSize;
    }

    @Override
    protected void convert(byte[] data, int offset, int bitStart, int samplesCount, int linesCount, byte[] outputData, int outputOffset, int destinationBytesPerLine) {
        boolean bl2;
        int n2 = (bitStart + samplesCount * this.SourcePixelSize - 1) / 8;
        int n3 = bitStart / 8;
        boolean bl3 = bl2 = this.a && linesCount > 1 && n3 == 0 && n2 == this.RightmostDestinationByte;
        if (bl2) {
            System.arraycopy(data, offset, outputData, outputOffset, destinationBytesPerLine * linesCount);
        } else {
            int n4 = n2 - n3 + 1;
            int n5 = offset;
            for (int i2 = 0; i2 < linesCount; ++i2) {
                System.arraycopy(data, n5, outputData, i2 * destinationBytesPerLine + outputOffset, n4);
                n5 += this.LineSize;
            }
        }
    }
}

