/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.colorconverters;

import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.msMath;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.PixelDataFormat;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.Rectangle;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.colorconverters.ColorConverter;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IColorPalette;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IIndexedColorConverter;

public final class MapColorConverter
extends ColorConverter {
    private static final int a = 256;
    private final byte[] b;

    public MapColorConverter(int width, int height, int lineSize, IColorPalette sourcePalette, PixelDataFormat sourcePixelFormat, Rectangle desiredRectangle, int destinationLineSize, IColorPalette destinationPalette, int ditheringMethod, IIndexedColorConverter indexedConverter, int fallbackIndex) {
        super(width, height, lineSize, sourcePixelFormat, desiredRectangle.Clone(), sourcePixelFormat, destinationLineSize);
        int n2;
        if (sourcePalette == null) {
            throw new ArgumentNullException("sourcePalette");
        }
        if (destinationPalette == null) {
            throw new ArgumentNullException("destinationPalette");
        }
        this.b = new byte[256];
        int n3 = (int)msMath.pow(2.0, this.SourcePixelSize);
        byte[] byArray = null;
        int n4 = 8 / this.SourcePixelSize;
        int n5 = n2 = n3 - 1;
        if (ditheringMethod == 2) {
            byArray = MapColorConverter.getConversionMap(indexedConverter, sourcePixelFormat, sourcePixelFormat, n3, n3);
            for (int i2 = 0; i2 < 256; ++i2) {
                int n6 = 8 - this.SourcePixelSize;
                byte by2 = 0;
                for (int i3 = 0; i3 < n4; ++i3) {
                    int n7 = i2 >> n6 & n2;
                    int n8 = byArray[n7] & 0xFF;
                    by2 = (byte)(by2 & 0xFF | n8 << n6 & 0xFF);
                    n6 -= this.SourcePixelSize;
                }
                this.b[i2] = by2;
            }
        } else {
            int[] nArray = MapColorConverter.correctPaletteEntries(sourcePalette, this.SourcePixelSize).getArgb32Entries();
            for (int i4 = 0; i4 < 256; ++i4) {
                int n9 = 8 - this.SourcePixelSize;
                byte by3 = 0;
                for (int i5 = 0; i5 < n4; ++i5) {
                    int n10 = i4 >> n9 & n2;
                    int n11 = nArray[n10];
                    int n12 = destinationPalette.getNearestColorIndex(n11);
                    if (n12 > n5) {
                        n12 = fallbackIndex;
                    }
                    by3 = (byte)(by3 & 0xFF | n12 << n9 & 0xFF);
                    n9 -= this.SourcePixelSize;
                }
                this.b[i4] = by3;
            }
        }
    }

    @Override
    protected void convert(byte[] data, int offset, int bitStart, int samplesCount, int linesCount, byte[] outputData, int outputOffset, int destinationBytesPerLine) {
        int n2 = (bitStart + samplesCount * this.SourcePixelSize - 1) / 8;
        int n3 = bitStart / 8;
        int n4 = n2 - n3 + 1;
        for (int i2 = 0; i2 < linesCount; ++i2) {
            int n5 = offset + this.LineSize * i2;
            int n6 = i2 * destinationBytesPerLine + outputOffset;
            for (int i3 = 0; i3 < n4; ++i3) {
                byte by2;
                outputData[n6 + i3] = by2 = this.b[data[n5 + i3] & 0xFF];
            }
        }
    }
}

