/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg;

import com.aspose.html.internal.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.internal.ms.System.NotImplementedException;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.IccProfileHelper;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.LoadOptions;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.PixelDataFormat;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.Point;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.Rectangle;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.datawriters.CMYKWriter;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.datawriters.GrayscaleWriter;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.datawriters.RgbWriter;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.datawriters.YCCKWriter;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.datawriters.YCbCrWriter;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.imageoptions.JpegOptions;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IPartialArgb32PixelLoader;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IPartialRawDataLoader;

public abstract class JpegDataWriter
implements IPartialArgb32PixelLoader,
IPartialRawDataLoader {
    protected IPartialRawDataLoader dataLoader;
    protected PixelDataFormat targetPixelSettings;

    public static JpegDataWriter getWriter(IPartialRawDataLoader rawDataAccumulator, JpegOptions options) {
        JpegDataWriter jpegDataWriter;
        switch (options.getColorType()) {
            case 4: {
                jpegDataWriter = new RgbWriter(rawDataAccumulator);
                break;
            }
            case 0: {
                jpegDataWriter = new GrayscaleWriter(rawDataAccumulator);
                break;
            }
            case 1: {
                jpegDataWriter = new YCbCrWriter(rawDataAccumulator);
                break;
            }
            case 2: {
                jpegDataWriter = new CMYKWriter(rawDataAccumulator);
                break;
            }
            case 3: {
                if (options.getRGBColorProfile() == null) {
                    options.setRGBColorProfile(IccProfileHelper.getDefaultRGBProfile());
                } else {
                    options.getRGBColorProfile().getStream().seek(0L, 0);
                }
                if (options.getCMYKColorProfile() == null) {
                    options.setCMYKColorProfile(IccProfileHelper.getDefaultCmykProfile());
                } else {
                    options.getCMYKColorProfile().getStream().seek(0L, 0);
                }
                jpegDataWriter = new YCCKWriter(rawDataAccumulator, options.getRGBColorProfile().getStream(), options.getCMYKColorProfile().getStream());
                break;
            }
            default: {
                throw new ArgumentOutOfRangeException();
            }
        }
        return jpegDataWriter;
    }

    @Override
    public void process(Rectangle pixelsRectangle, int[] pixels, Point start, Point end) {
        byte[] byArray = new byte[pixelsRectangle.getWidth() * pixelsRectangle.getHeight() * this.targetPixelSettings.getChannelsCount()];
        this.convert(pixels, byArray);
        this.dataLoader.process(pixelsRectangle.Clone(), byArray, start.Clone(), end.Clone());
    }

    @Override
    public void process(Rectangle rectangle, byte[] data, Point start, Point end) {
        this.dataLoader.process(rectangle.Clone(), data, start.Clone(), end.Clone());
    }

    @Override
    public void process(Rectangle rectangle, byte[] data, Point start, Point end, LoadOptions loadOptions) {
        throw new NotImplementedException();
    }

    protected abstract void convert(int[] var1, byte[] var2);
}

