/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg;

import com.aspose.html.internal.ms.System.Collections.Generic.List;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.JpegRawDataReader;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.JpegStream;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.constants.JpegConstants;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.constants.JpegOrder;

public class QTable {
    public byte Qi;
    public int[] Table = new int[JpegConstants.BlockSize2];

    public byte getPrecision() {
        return (byte)((this.Qi & 0xFF) >> 4);
    }

    public void setPrecision(byte value) {
        this.Qi = (byte)(this.Qi & 0xFF | (value & 0xFF) << 4);
    }

    public byte getTableDestination() {
        return (byte)(this.Qi & 0xFF & 0xF);
    }

    public void setTableDestination(byte value) {
        this.Qi = (byte)(this.Qi & 0xFF & 0x168 | value & 0xFF);
    }

    public static QTable prepareQuantizationTable(byte qs, byte[] qBytes, int quality, boolean baseline) {
        QTable qTable = new QTable();
        qTable.setTableDestination(qs);
        qTable.setPrecision((byte)0);
        for (int i2 = 0; i2 < JpegConstants.BlockSize2; ++i2) {
            int n2 = ((qBytes[i2] & 0xFF) * quality + 50) / 100;
            if (n2 <= 0) {
                n2 = 1;
            }
            if (n2 > Short.MAX_VALUE) {
                n2 = Short.MAX_VALUE;
            }
            if (baseline && n2 > 255) {
                n2 = 255;
            }
            qTable.Table[i2] = n2 & 0xFFFF;
        }
        return qTable;
    }

    public static QTable[] read(JpegRawDataReader stream) {
        List<QTable> list = new List<QTable>();
        int n2 = 0;
        int[] nArray = new int[]{0};
        stream.getTwoBytes(nArray);
        n2 = nArray[0];
        int n3 = 2;
        while (n3 < n2) {
            QTable qTable = new QTable();
            int n4 = 0;
            int[] nArray2 = new int[]{0};
            stream.getByte(nArray2);
            n4 = nArray2[0];
            qTable.Qi = (byte)n4;
            ++n3;
            for (int i2 = 0; i2 < JpegConstants.BlockSize2; ++i2) {
                int[] nArray3;
                int n5 = 0;
                if ((qTable.getPrecision() & 0xFF) == 0) {
                    nArray3 = new int[]{0};
                    stream.getByte(nArray3);
                    n5 = nArray3[0];
                    ++n3;
                } else {
                    nArray3 = new int[]{0};
                    stream.getTwoBytes(nArray3);
                    n5 = nArray3[0];
                    n3 += 2;
                }
                qTable.Table[JpegOrder.NaturalOrder[i2]] = n5 & 0xFFFF;
            }
            list.addItem(qTable);
        }
        return list.toArray(new QTable[0]);
    }

    static void write(JpegStream stream, QTable[] tables) {
        stream.writeByte((byte)-1);
        stream.writeByte((byte)-37);
        int n2 = 2;
        for (QTable qTable : tables) {
            n2 = 65 + JpegConstants.BlockSize2 * (qTable.getPrecision() & 0xFF) + (n2 & 0xFFFF) & 0xFFFF;
        }
        stream.writeShort(n2);
        for (QTable qTable : tables) {
            stream.writeByte(qTable.Qi);
            for (int i2 = 0; i2 < JpegConstants.BlockSize2; ++i2) {
                if ((qTable.getPrecision() & 0xFF) == 0) {
                    stream.writeByte((byte)(qTable.Table[JpegOrder.NaturalOrder[i2]] & 0xFF));
                    continue;
                }
                stream.writeShort(qTable.Table[JpegOrder.NaturalOrder[i2]]);
            }
        }
    }
}

