/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.png.coder;

import com.aspose.html.internal.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.internal.ms.System.Collections.Generic.List;
import com.aspose.html.internal.ms.System.IO.MemoryStream;
import com.aspose.html.internal.ms.System.IO.Stream;
import com.aspose.html.internal.ms.System.NotSupportedException;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.BufferHelper;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.LoadOptions;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.PixelDataFormat;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.Point;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.RawDataSettings;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.Rectangle;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.ValueResult;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.colorconverters.ColorConverter;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.colorconverters.ColorConverterFactory;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.compressors.ZlibDecoder;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.exceptions.FrameworkException;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.exceptions.imageformats.PngImageException;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.png.PngFileSettings;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.png.chunks.DataChunk;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.png.chunks.PngChunk;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.png.coder.PngCompressedDataBufferReader;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.png.coder.PngImageDataScaler;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.png.coder.PngImageScalerFactory;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.png.coder.PngRawDataConverter;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.png.coder.ProgressivePngDataLoader;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.png.colorconverters.GrayscaleAlphaPngColorDeconverter;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.png.colorconverters.GrayscalePngColorDeconverter;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.png.colorconverters.PalettePngColorDeconverter;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.png.colorconverters.PngColorDeconverter;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.png.colorconverters.RGBAColorDeconverter;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.png.colorconverters.RGBPngColorDeconverter;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.png.filters.UnpackPngFilter;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IPartialArgb32PixelLoader;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IPartialRawDataLoader;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IRasterImageArgb32PixelLoader;
import com.aspose.html.internal.ms.lang.Operators;

public class PngImagePixelLoader
implements IRasterImageArgb32PixelLoader {
    private final List<DataChunk> a;
    private final PngFileSettings b;
    private final LoadOptions c;
    private boolean d;

    public PngImagePixelLoader(PngFileSettings pngFileSettings, PngChunk[] chunks, LoadOptions loadOptions) {
        this.b = pngFileSettings;
        this.c = loadOptions;
        this.a = new List();
        for (PngChunk pngChunk : chunks) {
            if (!Operators.is(pngChunk, DataChunk.class)) continue;
            this.a.addItem(Operators.as(pngChunk, DataChunk.class));
        }
    }

    @Override
    public boolean isRawDataAvailable() {
        return false;
    }

    public PngFileSettings getPngFileSettings() {
        return this.b;
    }

    @Override
    public RawDataSettings getRawDataSettings() {
        RawDataSettings rawDataSettings = new RawDataSettings();
        rawDataSettings.setColorPalette(this.getPngFileSettings().getPalette());
        rawDataSettings.setCustomColorConverter(null);
        rawDataSettings.setFallbackIndex(0);
        rawDataSettings.setIndexedColorConverter(null);
        rawDataSettings.setLineSize(this.getPngFileSettings().lineByteLen(Operators.castToInt32(this.b.getWidth(), 10)));
        switch (this.getPngFileSettings().getColorType()) {
            case 0: {
                rawDataSettings.setPixelDataFormat(PixelDataFormat.getGrayscale());
                break;
            }
            case 2: {
                rawDataSettings.setPixelDataFormat(PixelDataFormat.getRgb24BppPng());
                break;
            }
            case 3: {
                rawDataSettings.setPixelDataFormat(PixelDataFormat.getRgbIndexed8Bpp());
                break;
            }
            case 4: {
                rawDataSettings.setPixelDataFormat(PixelDataFormat.getGrayscaleAlpha());
                break;
            }
            case 6: {
                rawDataSettings.setPixelDataFormat(PixelDataFormat.getRgba32Bpp());
                break;
            }
            default: {
                throw new PngImageException("Unsupported color mode.", new ArgumentOutOfRangeException("Unsupported color mode."));
            }
        }
        return rawDataSettings;
    }

    @Override
    public void loadPartialArgb32Pixels(Rectangle rectangle, IPartialArgb32PixelLoader partialLoader) {
        PngColorDeconverter pngColorDeconverter;
        switch (this.getPngFileSettings().getColorType()) {
            case 0: {
                pngColorDeconverter = new GrayscalePngColorDeconverter(partialLoader, this.b);
                break;
            }
            case 2: {
                pngColorDeconverter = new RGBPngColorDeconverter(partialLoader, this.b);
                break;
            }
            case 3: {
                pngColorDeconverter = new PalettePngColorDeconverter(partialLoader, this.getPngFileSettings().getPalette(), this.b);
                break;
            }
            case 4: {
                pngColorDeconverter = new GrayscaleAlphaPngColorDeconverter(partialLoader, this.b);
                break;
            }
            case 6: {
                pngColorDeconverter = new RGBAColorDeconverter(partialLoader, this.b);
                break;
            }
            default: {
                throw new PngImageException("Unsupported color mode.", new ArgumentOutOfRangeException("Unsupported color mode."));
            }
        }
        this.loadRawData(rectangle.Clone(), this.getRawDataSettings(), pngColorDeconverter);
    }

    @Override
    public void loadRawData(Rectangle rectangle, RawDataSettings rawDataSettings, IPartialRawDataLoader rawDataLoader) {
        IPartialRawDataLoader iPartialRawDataLoader;
        Object object;
        RawDataSettings rawDataSettings2 = this.getRawDataSettings();
        if (rawDataSettings2.getPixelDataFormat().getPixelFormat() != rawDataSettings.getPixelDataFormat().getPixelFormat() || rawDataSettings2.getPixelDataFormat().getBitsPerPixel() != rawDataSettings.getPixelDataFormat().getBitsPerPixel() || rawDataSettings2.getPixelDataFormat().getChannelsCount() != rawDataSettings.getPixelDataFormat().getChannelsCount()) {
            object = ColorConverterFactory.getConverter(Operators.castToInt32(this.getPngFileSettings().getWidth(), 10), Operators.castToInt32(this.getPngFileSettings().getHeight(), 10), this.b.lineByteLen(Operators.castToInt32(this.b.getWidth(), 10)), this.getPngFileSettings().getPalette(), rawDataSettings2.getPixelDataFormat(), rectangle.Clone(), rawDataSettings.getColorPalette(), rawDataSettings.getPixelDataFormat(), rectangle.getWidth() * rawDataSettings.getPixelDataFormat().getBitsPerPixel() / 8, rawDataSettings.getDitheringMethod(), rawDataSettings.getIndexedColorConverter(), rawDataSettings.getCustomColorConverter(), rawDataSettings.getFallbackIndex());
            iPartialRawDataLoader = new PngRawDataConverter((ColorConverter)object, rawDataLoader);
        } else {
            iPartialRawDataLoader = rawDataLoader;
        }
        object = new MemoryStream(this.b());
        switch (this.getPngFileSettings().getInterlace()) {
            case 0: {
                UnpackPngFilter unpackPngFilter = new UnpackPngFilter(this.b.lineByteLen(Operators.castToInt32(this.getPngFileSettings().getWidth(), 10)), Operators.castToInt32(this.getPngFileSettings().getBitDepth(), 6), this.b.getChannelsCount());
                byte[] byArray = unpackPngFilter.process(((MemoryStream)object).toArray());
                PngImageDataScaler pngImageDataScaler = PngImageScalerFactory.getScaler(Operators.castToInt32(this.b.getBitDepth(), 6), Operators.castToInt32(this.b.getWidth(), 10), Operators.castToInt32(this.b.getHeight(), 10), this.b.getColorType() == 3);
                if (pngImageDataScaler != null) {
                    byArray = pngImageDataScaler.scaleBytes(byArray);
                }
                if ((long)rectangle.getHeight() == Operators.castToUInt32(this.b.getHeight(), 10) && (long)rectangle.getWidth() == Operators.castToUInt32(this.b.getWidth(), 10) && rectangle.getX() == 0 && rectangle.getY() == 0) {
                    iPartialRawDataLoader.process(rectangle.Clone(), byArray, new Point(rectangle.getX(), rectangle.getY()), new Point(rectangle.getRight(), rectangle.getBottom()), this.c);
                    break;
                }
                byte[] byArray2 = BufferHelper.allocate(rectangle.getHeight() * rectangle.getWidth() * this.b.getChannelsCount());
                int n2 = Operators.castToInt32((long)(this.b.getChannelsCount() * rectangle.getX()) + (long)rectangle.getY() * Operators.castToInt64(this.b.getWidth(), 10) * (long)this.b.getChannelsCount(), 11);
                int n3 = 0;
                for (int i2 = 0; i2 < rectangle.getHeight(); ++i2) {
                    System.arraycopy(byArray, n2, byArray2, n3, this.b.getChannelsCount() * rectangle.getWidth());
                    n2 += Operators.castToInt32(this.b.getWidth(), 10) * this.b.getChannelsCount();
                    n3 += this.b.getChannelsCount() * rectangle.getWidth();
                }
                iPartialRawDataLoader.process(rectangle.Clone(), byArray2, new Point(rectangle.getX(), rectangle.getY()), new Point(rectangle.getRight(), rectangle.getBottom()));
                break;
            }
            case 1: {
                ProgressivePngDataLoader progressivePngDataLoader = new ProgressivePngDataLoader(iPartialRawDataLoader, this.getPngFileSettings());
                progressivePngDataLoader.process(rectangle.Clone(), ((MemoryStream)object).toArray(), rectangle.getLocation().Clone(), new Point(rectangle.getRight(), rectangle.getBottom()));
                break;
            }
            default: {
                throw new FrameworkException(StringExtensions.format("This interlace {0} method is not supported yet.", Operators.boxing(this.b.getInterlace())), new NotSupportedException());
            }
        }
    }

    private int a() {
        if (Operators.castToInt32(this.getPngFileSettings().getInterlace(), 6) == 0) {
            return Operators.castToInt32(Operators.castToUInt32(Operators.castToInt64(this.getPngFileSettings().getHeight(), 10) * (long)(this.b.lineByteLen(Operators.castToInt32(this.b.getWidth(), 10)) + 1), 11), 11);
        }
        if (Operators.castToInt32(this.getPngFileSettings().getInterlace(), 6) == 1) {
            int n2 = 0;
            for (int i2 = 0; i2 < 7; ++i2) {
                int n3 = ProgressivePngDataLoader.pngPassCols(Operators.castToInt32(this.getPngFileSettings().getWidth(), 10), i2);
                int n4 = ProgressivePngDataLoader.pngPassRows(Operators.castToInt32(this.getPngFileSettings().getHeight(), 10), i2);
                n2 += n4 * (this.b.lineByteLen(n3) + 1);
            }
            return n2;
        }
        throw new FrameworkException("Interlace not supported.", new PngImageException(StringExtensions.format("Interlace {0} method is not supported.", Operators.boxing(this.getPngFileSettings().getInterlace()))));
    }

    private byte[] b() {
        int n2;
        byte[] byArray;
        Object object;
        MemoryStream memoryStream = new MemoryStream();
        for (int i2 = 0; i2 < this.a.size(); ++i2) {
            object = this.a.get_Item(i2);
            Stream stream = ((DataChunk)object).getStreamContainer();
            stream.seek(((DataChunk)object).getStartPosition(), 0);
            byArray = new byte[((DataChunk)object).getLength()];
            n2 = stream.read(byArray, 0, ((DataChunk)object).getLength());
            memoryStream.write(byArray, 0, n2);
        }
        memoryStream.seek(0L, 0);
        MemoryStream memoryStream2 = new MemoryStream();
        object = new ZlibDecoder(new PngCompressedDataBufferReader(memoryStream.toArray()), true);
        int n3 = this.a();
        byArray = new byte[n3];
        n2 = 0;
        ValueResult valueResult = ((ZlibDecoder)object).inflate(byArray, n2, byArray.length).Clone();
        this.d = !valueResult.Success;
        int n4 = valueResult.Success ? valueResult.Value : n3;
        memoryStream2.write(byArray, 0, n4);
        return memoryStream2.toArray();
    }
}

