/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.png.coder;

import com.aspose.html.internal.ms.System.NotImplementedException;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.BufferHelper;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.LoadOptions;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.Point;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.Rectangle;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.png.PngFileSettings;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.png.coder.PngImageDataScaler;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.png.coder.PngImageScalerFactory;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.png.filters.UnpackPngFilter;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IPartialRawDataLoader;
import com.aspose.html.internal.ms.lang.Operators;

class ProgressivePngDataLoader
implements IPartialRawDataLoader {
    private final IPartialRawDataLoader a;
    private final PngFileSettings b;

    public ProgressivePngDataLoader(IPartialRawDataLoader finalProcessor, PngFileSettings pngFileSettings) {
        this.a = finalProcessor;
        this.b = pngFileSettings;
    }

    public static int pngPassColShift(int pass) {
        return pass > 1 ? 7 - pass >> 1 : 3;
    }

    public static int pngPassCols(int width, int pass) {
        return width + ((1 << ProgressivePngDataLoader.pngPassColShift(pass)) - 1 - ProgressivePngDataLoader.pngPassStartCol(pass)) >> ProgressivePngDataLoader.pngPassColShift(pass);
    }

    public static int pngPassRowShift(int pass) {
        return pass > 2 ? 8 - pass >> 1 : 3;
    }

    public static int pngPassRows(int height, int pass) {
        return height + ((1 << ProgressivePngDataLoader.pngPassRowShift(pass)) - 1 - ProgressivePngDataLoader.pngPassStartRow(pass)) >> ProgressivePngDataLoader.pngPassRowShift(pass);
    }

    public static int pngPassStartCol(int pass) {
        return (1 & pass) << 3 - (pass + 1 >> 1) & 7;
    }

    public static int pngPassStartRow(int pass) {
        return (1 & ~pass) << 3 - (pass >> 1) & 7;
    }

    private int a(int n2, int n3) {
        return (n2 << ProgressivePngDataLoader.pngPassColShift(n3)) + ProgressivePngDataLoader.pngPassStartCol(n3);
    }

    private int b(int n2, int n3) {
        return (n2 << ProgressivePngDataLoader.pngPassRowShift(n3)) + ProgressivePngDataLoader.pngPassStartRow(n3);
    }

    @Override
    public void process(Rectangle rectangle, byte[] data, Point start, Point end) {
        byte[] byArray = BufferHelper.allocate((long)this.b.getChannelsCount() * Operators.castToInt64(this.b.getWidth(), 10) * Operators.castToInt64(this.b.getHeight(), 10));
        int n2 = 0;
        int n3 = 0;
        while ((n3 & 0xFF) < 7) {
            int n4 = ProgressivePngDataLoader.pngPassRows((int)(this.b.getHeight() & 0xFFFFFFFFL), n3 & 0xFF);
            int n5 = ProgressivePngDataLoader.pngPassCols((int)(this.b.getWidth() & 0xFFFFFFFFL), n3 & 0xFF);
            if (n4 != 0 && n5 != 0) {
                byte[] byArray2 = BufferHelper.allocate(n4 * (this.b.lineByteLen(n5) + 1));
                System.arraycopy(data, n2, byArray2, 0, byArray2.length);
                n2 += byArray2.length;
                UnpackPngFilter unpackPngFilter = new UnpackPngFilter(this.b.lineByteLen(n5), this.b.getBitDepth() & 0xFF, this.b.getChannelsCount());
                byArray2 = unpackPngFilter.process(byArray2);
                if ((this.b.getBitDepth() & 0xFF) != 8) {
                    PngImageDataScaler pngImageDataScaler = PngImageScalerFactory.getScaler(this.b.getBitDepth() & 0xFF, n5, n4, this.b.getColorType() == 3);
                    byArray2 = pngImageDataScaler.scaleBytes(byArray2);
                }
                int n6 = 0;
                int n7 = this.b.getChannelsCount();
                for (int i2 = 0; i2 < n4; ++i2) {
                    int n8 = this.b(i2, n3 & 0xFF);
                    for (int i3 = 0; i3 < n5; ++i3) {
                        int n9 = this.a(i3, n3 & 0xFF);
                        if (!rectangle.contains(n9, n8)) continue;
                        int n10 = n9 - rectangle.getLeft();
                        int n11 = n8 - rectangle.getTop();
                        System.arraycopy(byArray2, n6 + i3 * n7, byArray, (rectangle.getWidth() * n11 + n10) * n7, n7);
                    }
                    n6 += n5 * n7;
                }
            }
            n3 = (byte)(n3 + 1);
        }
        this.a.process(rectangle.Clone(), byArray, start.Clone(), end.Clone());
    }

    @Override
    public void process(Rectangle rectangle, byte[] data, Point start, Point end, LoadOptions loadOptions) {
        throw new NotImplementedException();
    }
}

