/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff;

import com.aspose.html.internal.ms.System.DoubleExtensions;
import com.aspose.html.internal.ms.System.ObjectExtensions;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.UInt32Extensions;
import com.aspose.html.internal.ms.System.msMath;
import com.aspose.html.internal.ms.lang.Operators;

public class TiffRational {
    public static final double EPSILON = 1.0E-6;
    private long a;
    private long b;

    public TiffRational() {
    }

    public TiffRational(long value) {
        this.b = value;
        this.a = 1L;
    }

    public TiffRational(long nominator, long denominator) {
        this.b = nominator;
        this.a = denominator;
    }

    public long getDenominator() {
        return this.a;
    }

    public long getNominator() {
        return this.b;
    }

    public float getValue() {
        return Operators.castToFloat(this.b, 10) / Operators.castToFloat(this.a, 10);
    }

    public double getValueD() {
        return Operators.castToDouble(this.b, 10) / Operators.castToDouble(this.a, 10);
    }

    public static TiffRational approximateFraction(double value, double epsilon) {
        long l2 = 1L;
        long l3 = 1L;
        double d2 = Operators.castToDouble(Operators.castToUInt32(l2, 10) / Operators.castToUInt32(l3, 10), 10);
        while (msMath.abs(d2 - value) > epsilon) {
            l2 = d2 < value ? ++l2 : Operators.castToUInt32(msMath.round(value * Operators.castToDouble(++l3, 10)), 14);
            d2 = Operators.castToDouble(l2, 10) / Operators.castToDouble(l3, 10);
        }
        return new TiffRational(l2, l3);
    }

    public static TiffRational approximateFraction(double value) {
        return TiffRational.approximateFraction(value, 1.0E-6);
    }

    public static TiffRational approximateFraction(float value, double epsilon) {
        long l2 = 1L;
        long l3 = 1L;
        double d2 = Operators.castToDouble(Operators.castToUInt32(l2, 10) / Operators.castToUInt32(l3, 10), 10);
        while (msMath.abs(d2 - (double)value) > epsilon) {
            l2 = d2 < (double)value ? ++l2 : Operators.castToUInt32(msMath.round(value * Operators.castToFloat(++l3, 10)), 14);
            d2 = Operators.castToDouble(l2, 10) / Operators.castToDouble(l3, 10);
        }
        return new TiffRational(l2, l3);
    }

    public static TiffRational approximateFraction(float value) {
        return TiffRational.approximateFraction(value, 1.0E-6);
    }

    public String toString() {
        return StringExtensions.concat(DoubleExtensions.toString(this.getValueD(), "F2"), " (", UInt32Extensions.toString(this.b), "/", UInt32Extensions.toString(this.a), Operators.boxing(Character.valueOf(')')));
    }

    public static boolean op_Equality(TiffRational rational1, TiffRational rational2) {
        boolean bl2 = !ObjectExtensions.referenceEquals(rational1, null) && !ObjectExtensions.referenceEquals(rational2, null) ? Operators.castToUInt32(rational1.b, 10) == Operators.castToUInt32(rational2.b, 10) && Operators.castToUInt32(rational1.a, 10) == Operators.castToUInt32(rational2.a, 10) : ObjectExtensions.referenceEquals(rational1, null) && ObjectExtensions.referenceEquals(rational2, null);
        return bl2;
    }

    public static boolean op_Inequality(TiffRational rational1, TiffRational rational2) {
        return !TiffRational.op_Equality(rational1, rational2);
    }

    public boolean equals(Object obj) {
        return TiffRational.op_Equality(this, Operators.as(obj, TiffRational.class));
    }

    public int hashCode() {
        return Operators.castToInt32(Operators.castToUInt32(this.b, 10) ^ Operators.castToUInt32(this.a, 10), 10);
    }
}

