/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.codecs.readers;

import com.aspose.html.internal.ms.System.Array;
import com.aspose.html.internal.ms.System.Enum;
import com.aspose.html.internal.ms.System.Int32Extensions;
import com.aspose.html.internal.ms.System.OutOfMemoryException;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.LoadOptions;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.OperationResult;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.PartialProcessor;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.Point;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.Rectangle;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.exceptions.imageformats.TiffImageException;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.TiffCodecDataReader;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.codecs.ccitt.CcittFaxDecode;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.codecs.ccitt.ColorUpdater;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.codecs.ccitt.StripReader;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.codecs.ccitt.StripReaderResult;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.consts.TiffConsts;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.enums.TiffCompressions;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.filemanagement.TiffStream;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.imageoptions.TiffOptions;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IPartialArgb32PixelLoader;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IPartialProcessor;

public class TiffCcittReader
extends TiffCodecDataReader {
    private static int a;
    private final LoadOptions b;

    public TiffCcittReader(TiffOptions options, int width, int height, LoadOptions loadOptions) {
        super(options, width, height);
        this.b = loadOptions;
    }

    public static int getMaxAllowedAllocation() {
        return a;
    }

    public static void setMaxAllowedAllocation(int value) {
        a = value;
    }

    @Override
    public void decode(TiffStream stream, Rectangle rectangle, IPartialArgb32PixelLoader partialLoader) {
        PartialLoader partialLoader2 = new PartialLoader(this, stream, partialLoader, rectangle.Clone());
        PartialProcessor.process(rectangle.Clone(), partialLoader2);
    }

    private static class PartialLoader
    implements IPartialProcessor {
        private final IPartialArgb32PixelLoader a;
        private final CcittDecoder b;

        public PartialLoader(TiffCcittReader codec, TiffStream stream, IPartialArgb32PixelLoader loader, Rectangle desiredArea) {
            this.a = loader;
            long[] lArray = codec.getOptions().getStripOffsets();
            int n2 = codec.getRowsPerStrip();
            StripReader stripReader = new StripReader(stream.getStream(), codec.getOptions(), codec.getHeight(), lArray.length, n2);
            int n3 = stripReader.seekToLineStrip(desiredArea.getY());
            ColorUpdater colorUpdater = new ColorUpdater(desiredArea.Clone(), codec.getWidth(), n3, codec.getOptions().getPhotometric() == 0);
            LoadOptions loadOptions = codec.b;
            switch (codec.getCompression()) {
                case 2: {
                    this.b = new CcittRleDecoder(codec.getWidth(), stripReader, colorUpdater, loadOptions, desiredArea.Clone());
                    break;
                }
                case 3: {
                    long l2 = codec.getOptions().getFaxT4Options();
                    if ((l2 & 2L) == 2L) {
                        throw new TiffImageException("Uncompressed mode is not supported for CcittFax3.");
                    }
                    if ((l2 & 1L) == 1L) {
                        this.b = new CcittFax3Decoder2D(codec.getWidth(), stripReader, colorUpdater, loadOptions, desiredArea.Clone());
                        break;
                    }
                    this.b = new CcittFax3Decoder1D(codec.getWidth(), stripReader, colorUpdater, loadOptions, desiredArea.Clone());
                    break;
                }
                case 4: {
                    this.b = new CcittFax4Decoder(codec.getWidth(), stripReader, colorUpdater, loadOptions, desiredArea.Clone());
                    break;
                }
                default: {
                    throw new TiffImageException(StringExtensions.concat("The compression ", Enum.getName(TiffCompressions.class, codec.getCompression()), " is not supported"));
                }
            }
        }

        @Override
        public void process(Rectangle areaToProcess) {
            int n2 = areaToProcess.getWidth() * areaToProcess.getHeight();
            if (TiffCcittReader.getMaxAllowedAllocation() > 0 && n2 > TiffCcittReader.getMaxAllowedAllocation()) {
                throw new OutOfMemoryException();
            }
            int[] nArray = this.b.decode(areaToProcess.Clone());
            PartialCcittDataProcessor partialCcittDataProcessor = new PartialCcittDataProcessor(nArray, this.a, areaToProcess.Clone());
            PartialProcessor.process(areaToProcess.Clone(), partialCcittDataProcessor);
        }

        private static class CcittExpander
        extends Decoder {
            private final int a;
            private int[] b;
            private int c;
            private int d;
            private int e;

            public CcittExpander(ColorUpdater colorUpdater, int width, StripReader stripReader, LoadOptions loadOptions) {
                super(stripReader, colorUpdater, loadOptions);
                this.a = width;
            }

            public void beginNewLine(int[] newLineChanges) {
                this.b = newLineChanges;
                this.c = 0;
                this.d = 0;
                this.e = 0;
            }

            public void expand() {
                CcittFaxDecode[] ccittFaxDecodeArray = new CcittFaxDecode[this.a * 2];
                int n2 = 0;
                if (this.b == null) {
                    this.skipRowOrStrip("Cannot perform 2d decoding. Missing changes from previous row.");
                    this.e = this.a;
                } else {
                    while (this.e < this.a) {
                        StripReaderResult stripReaderResult = this.StripReader.findEntity(7, true).Clone();
                        if (stripReaderResult.Result != 0) {
                            this.skipRowOrStrip(stripReaderResult.ErrorMessage);
                            this.e = this.a;
                            break;
                        }
                        int n3 = stripReaderResult.StripEntity;
                        CcittFaxDecode ccittFaxDecode = CcittFaxDecode.fromArray(TiffConsts.getFaxMainTable(), n3);
                        this.StripReader.clearCurrentData(ccittFaxDecode.getCodeWidth() & 0xFF);
                        ccittFaxDecodeArray[n2++] = ccittFaxDecode;
                        switch (ccittFaxDecode.getCodeState()) {
                            case 1: {
                                if (this.c + 1 >= this.b.length) {
                                    this.skipRowOrStrip("Cannot do pass. There is no more changes exist.");
                                    this.e = this.a;
                                    break;
                                }
                                this.d += this.b[this.c++];
                                this.d += this.b[this.c++];
                                int n4 = this.d - this.e;
                                this.ColorUpdater.updateColors(n4);
                                this.e += n4;
                                break;
                            }
                            case 2: {
                                int n5 = 13;
                                int n6 = 12;
                                if (this.ColorUpdater.getCurrentColorIndex() == 0) {
                                    n5 = 12;
                                    n6 = 13;
                                }
                                if (!this.a(n5) || !this.a(n6)) break;
                                while (this.c < this.b.length - 1 && this.d + this.b[this.c] <= this.e) {
                                    this.d += this.b[this.c++];
                                    this.d += this.b[this.c++];
                                }
                                break;
                            }
                            case 3: {
                                this.b(0);
                                break;
                            }
                            case 4: {
                                this.b(ccittFaxDecode.getPixelLength());
                                break;
                            }
                            case 5: {
                                this.b(-ccittFaxDecode.getPixelLength());
                                break;
                            }
                            case 12: {
                                int n7 = this.a - this.e;
                                if (n7 <= 0) break;
                                this.ColorUpdater.updateColors(n7);
                                this.e += n7;
                            }
                        }
                    }
                }
            }

            private boolean a(int n2) {
                int n3 = 0;
                int[] nArray = TiffConsts.getFaxWhiteLut();
                if (this.ColorUpdater.getCurrentColorIndex() == 1) {
                    nArray = TiffConsts.getFaxBlackLut();
                }
                boolean bl2 = false;
                boolean bl3 = true;
                while (!bl2) {
                    StripReaderResult stripReaderResult = this.StripReader.findEntity(n2, true).Clone();
                    int n4 = stripReaderResult.StripEntity;
                    int n5 = stripReaderResult.Result;
                    if (n4 <= 0 || n5 != 0) {
                        this.skipRowOrStrip(stripReaderResult.ErrorMessage);
                        this.e = this.a;
                        bl3 = false;
                        break;
                    }
                    CcittFaxDecode ccittFaxDecode = CcittFaxDecode.fromArray(nArray, n4);
                    this.StripReader.clearCurrentData(ccittFaxDecode.getCodeWidth() & 0xFF);
                    switch (ccittFaxDecode.getCodeState()) {
                        case 7: 
                        case 8: {
                            this.ColorUpdater.updateColors(n3 += ccittFaxDecode.getPixelLength());
                            this.ColorUpdater.changeCurrentColor();
                            this.e += n3;
                            bl2 = true;
                            break;
                        }
                        case 9: 
                        case 10: 
                        case 11: {
                            n3 += ccittFaxDecode.getPixelLength();
                            break;
                        }
                        case 0: 
                        case 12: {
                            this.skipRowOrStrip("EOL has been found");
                            this.e = this.a;
                            bl2 = true;
                            bl3 = false;
                        }
                    }
                }
                return bl3;
            }

            private void b(int n2) {
                int n3;
                int n4 = this.d;
                if (this.c < this.b.length) {
                    n4 += this.b[this.c];
                }
                int n5 = 1;
                if (this.e > 0 || n4 + n2 < 0) {
                    while (this.c + n5 + 1 < this.b.length && (n4 <= this.e || n4 + n2 <= this.e)) {
                        n4 += this.b[this.c + n5++];
                        n4 += this.b[this.c + n5++];
                    }
                }
                if ((n3 = (n4 += n2) - this.e) <= 0 && this.c > 0) {
                    this.skipRowOrStrip("Vertical code is incorrect.");
                    this.e = this.a;
                } else {
                    this.ColorUpdater.updateColors(n3);
                    this.ColorUpdater.changeCurrentColor();
                    this.e = n4;
                    if (this.d > this.e) {
                        if (this.c == 0) {
                            this.skipRowOrStrip("Cannot adjust reference position backwards. No more changes exist.");
                            this.e = this.a;
                        } else {
                            this.d -= this.b[--this.c];
                        }
                    } else if (this.c < this.b.length) {
                        this.d += this.b[this.c++];
                        while (this.d < this.a && this.c < this.b.length - 1 && this.d + this.b[this.c] <= this.e) {
                            this.d += this.b[this.c++];
                            this.d += this.b[this.c++];
                        }
                    }
                }
            }
        }

        private static abstract class RleDecoder
        extends CcittDecoder {
            private final int a;
            private int b;
            private int c;

            protected RleDecoder(int width, StripReader stripReader, ColorUpdater colorUpdater, LoadOptions loadOptions, Rectangle fullDesiredArea) {
                super(stripReader, colorUpdater, loadOptions, fullDesiredArea.Clone());
                this.a = width;
            }

            protected void decodeRleSymbols() {
                int n2;
                if (this.ColorUpdater.isNewLine()) {
                    this.c = 0;
                }
                boolean bl2 = true;
                boolean bl3 = true;
                int n3 = this.ColorUpdater.getCurrentColorIndex();
                while (this.c < this.a && bl2) {
                    CcittFaxDecode ccittFaxDecode;
                    int n4;
                    int n5 = 13;
                    int[] nArray = TiffConsts.getFaxBlackLut();
                    if (n3 == 0) {
                        nArray = TiffConsts.getFaxWhiteLut();
                        n5 = 12;
                    }
                    StripReaderResult stripReaderResult = this.StripReader.findEntity(n5, true).Clone();
                    if (stripReaderResult.Result == 2) {
                        this.skipRowOrStrip(stripReaderResult.ErrorMessage);
                        this.c = this.a;
                        bl3 = false;
                        break;
                    }
                    if (stripReaderResult.Result == 0) {
                        n4 = stripReaderResult.StripEntity;
                        ccittFaxDecode = CcittFaxDecode.fromArray(nArray, n4);
                    } else {
                        ccittFaxDecode = CcittFaxDecode.getEOL();
                    }
                    this.StripReader.clearCurrentData(ccittFaxDecode.getCodeWidth() & 0xFF);
                    switch (ccittFaxDecode.getCodeState()) {
                        case 7: 
                        case 8: {
                            n4 = this.b + ccittFaxDecode.getPixelLength();
                            this.c += n4;
                            this.b = 0;
                            this.ColorUpdater.updateColors(n4);
                            this.ColorUpdater.changeCurrentColor();
                            n3 = this.ColorUpdater.getCurrentColorIndex();
                            break;
                        }
                        case 9: 
                        case 10: 
                        case 11: {
                            this.b += ccittFaxDecode.getPixelLength();
                            break;
                        }
                        case 12: {
                            bl2 = false;
                        }
                    }
                }
                if (bl3 && (n2 = this.a - this.c) > 0) {
                    this.ColorUpdater.updateColors(n2);
                }
            }
        }

        private static class CcittRleDecoder
        extends RleDecoder {
            public CcittRleDecoder(int width, StripReader stripReader, ColorUpdater colorUpdater, LoadOptions loadOptions, Rectangle fullDesiredArea) {
                super(width, stripReader, colorUpdater, loadOptions, fullDesiredArea.Clone());
            }

            @Override
            protected void performDecoding() {
                while (this.ColorUpdater.canFill()) {
                    if (this.ColorUpdater.isEof()) {
                        this.ColorUpdater.skipToNextLine();
                        this.seekNextStrip();
                        this.StripReader.shiftToByteBoundary();
                    }
                    this.decodeRleSymbols();
                }
            }
        }

        private static class CcittFax3Decoder1D
        extends RleDecoder {
            public CcittFax3Decoder1D(int width, StripReader stripReader, ColorUpdater colorUpdater, LoadOptions loadOptions, Rectangle fullDesiredArea) {
                super(width, stripReader, colorUpdater, loadOptions, fullDesiredArea.Clone());
            }

            @Override
            protected void performDecoding() {
                while (this.ColorUpdater.canFill()) {
                    if (this.ColorUpdater.isEof()) {
                        this.ColorUpdater.skipToNextLine();
                        this.seekNextStrip();
                    }
                    if (this.ColorUpdater.isNewLine()) {
                        OperationResult operationResult = CcittFax3Decoder1D.synchronizeEOL(this.StripReader).Clone();
                        if (!operationResult.Success) {
                            this.skipRowOrStrip(operationResult.ErrorMessage);
                            continue;
                        }
                    }
                    this.decodeRleSymbols();
                }
            }
        }

        private static class CcittFax3Decoder2D
        extends RleDecoder {
            private final CcittExpander a;
            private boolean b;
            private int[] c;

            public CcittFax3Decoder2D(int width, StripReader stripReader, ColorUpdater colorUpdater, LoadOptions loadOptions, Rectangle fullDesiredArea) {
                super(width, stripReader, colorUpdater, loadOptions, fullDesiredArea.Clone());
                this.a = new CcittExpander(colorUpdater, width, stripReader, loadOptions);
            }

            @Override
            protected final void performDecoding() {
                while (this.ColorUpdater.canFill()) {
                    if (this.ColorUpdater.isEof()) {
                        this.c = this.ColorUpdater.getChanges();
                        this.ColorUpdater.skipToNextLine();
                        if (this.seekNextStrip()) {
                            this.c = null;
                        }
                    }
                    if (this.ColorUpdater.isNewLine()) {
                        OperationResult operationResult = CcittFax3Decoder2D.synchronizeEOL(this.StripReader).Clone();
                        if (!operationResult.Success) {
                            this.skipRowOrStrip(operationResult.ErrorMessage);
                            continue;
                        }
                        StripReaderResult stripReaderResult = this.StripReader.findEntity(1, true);
                        if (stripReaderResult.Result != 0) {
                            this.skipRowOrStrip(stripReaderResult.ErrorMessage);
                            continue;
                        }
                        this.b = stripReaderResult.StripEntity != 0;
                        this.StripReader.clearCurrentData(1);
                        if (!this.b) {
                            this.a.beginNewLine(this.c);
                        }
                    }
                    if (this.b) {
                        this.decodeRleSymbols();
                        continue;
                    }
                    this.a.expand();
                }
            }
        }

        private static class CcittFax4Decoder
        extends CcittDecoder {
            private final CcittExpander a;
            private final int b;

            public CcittFax4Decoder(int width, StripReader stripReader, ColorUpdater colorUpdater, LoadOptions loadOptions, Rectangle fullDesiredArea) {
                super(stripReader, colorUpdater, loadOptions, fullDesiredArea.Clone());
                this.a = new CcittExpander(colorUpdater, width, stripReader, loadOptions);
                this.a.beginNewLine(new int[]{width, 0});
                this.b = width;
            }

            @Override
            protected void performDecoding() {
                while (this.ColorUpdater.canFill()) {
                    if (this.ColorUpdater.isEof()) {
                        int[] nArray = this.ColorUpdater.getChanges();
                        this.ColorUpdater.skipToNextLine();
                        if (this.seekNextStrip()) {
                            nArray = new int[]{this.b, 0};
                        }
                        this.a.beginNewLine(nArray);
                    }
                    this.a.expand();
                }
            }
        }

        private static abstract class CcittDecoder
        extends Decoder {
            private final int a;
            private boolean b;

            protected CcittDecoder(StripReader stripReader, ColorUpdater colorUpdater, LoadOptions loadOptions, Rectangle fullDesiredArea) {
                super(stripReader, colorUpdater, loadOptions);
                this.a = fullDesiredArea.getLeft();
            }

            public int[] decode(Rectangle area) {
                int[] nArray = new int[area.getWidth() * area.getHeight()];
                this.b = this.a == area.getLeft();
                this.ColorUpdater.setColorArea(nArray, area.Clone());
                this.performDecoding();
                return nArray;
            }

            protected static OperationResult synchronizeEOL(StripReader stripReader) {
                StripReaderResult stripReaderResult;
                OperationResult operationResult;
                boolean bl2;
                block11: {
                    bl2 = true;
                    operationResult = new OperationResult();
                    operationResult.Success = true;
                    while (true) {
                        stripReaderResult = stripReader.findEntity(11, false).Clone();
                        if (stripReaderResult.Result == 2) {
                            bl2 = false;
                            operationResult.ErrorMessage = stripReaderResult.ErrorMessage;
                            operationResult.Success = false;
                        } else {
                            if (stripReaderResult.Result != 0) break;
                            if (stripReader.getBits(11) != 0) {
                                stripReader.clearCurrentData(1);
                                continue;
                            }
                        }
                        break block11;
                        break;
                    }
                    bl2 = false;
                }
                if (bl2) {
                    block12: {
                        while (true) {
                            stripReaderResult = stripReader.findEntity(8, false).Clone();
                            if (stripReaderResult.Result == 2) {
                                bl2 = false;
                                operationResult.ErrorMessage = stripReaderResult.ErrorMessage;
                                operationResult.Success = false;
                            } else {
                                if (stripReaderResult.Result != 0) break;
                                if (stripReader.getBits(8) == 0) {
                                    stripReader.clearCurrentData(8);
                                    continue;
                                }
                            }
                            break block12;
                            break;
                        }
                        bl2 = false;
                    }
                    if (bl2) {
                        while (stripReader.getBits(1) == 0) {
                            stripReader.clearCurrentData(1);
                        }
                        stripReader.clearCurrentData(1);
                    }
                }
                return operationResult;
            }

            protected abstract void performDecoding();

            protected boolean seekNextStrip() {
                int n2;
                boolean bl2 = false;
                if (this.b && (n2 = this.StripReader.getNextStripLineIndex()) == this.ColorUpdater.getCurrentLineIndex()) {
                    int n3 = this.ColorUpdater.getCurrentLineIndex();
                    this.StripReader.seekToLineStrip(n3);
                    bl2 = true;
                }
                return bl2;
            }
        }

        private static abstract class Decoder {
            protected final StripReader StripReader;
            protected final ColorUpdater ColorUpdater;
            private int a;
            private int b;

            protected Decoder(StripReader stripReader, ColorUpdater colorUpdater, LoadOptions loadOptions) {
                this.StripReader = stripReader;
                this.ColorUpdater = colorUpdater;
                if (loadOptions != null) {
                    this.a = loadOptions.getDataRecoveryMode();
                    this.b = loadOptions.getDataBackgroundColor();
                }
            }

            protected void skipRowOrStrip(String errorMessage) {
                if (this.a == 2) {
                    this.ColorUpdater.skipRows(this.ColorUpdater.getCurrentLineIndex() + 1, this.b);
                } else if (this.a == 1) {
                    int n2 = this.StripReader.getNextStripLineIndex(this.ColorUpdater.getCurrentLineIndex());
                    this.ColorUpdater.skipRows(n2, this.b);
                } else {
                    throw new TiffImageException(StringExtensions.concat("Cannot decode strip ", Int32Extensions.toString(this.StripReader.getStripIndex()), ". Details: ", errorMessage));
                }
            }
        }

        private static class PartialCcittDataProcessor
        implements IPartialProcessor {
            private final IPartialArgb32PixelLoader a;
            private final int[] b;
            private final Rectangle c = new Rectangle();

            public PartialCcittDataProcessor(int[] colors, IPartialArgb32PixelLoader processor, Rectangle area) {
                this.a = processor;
                this.b = colors;
                area.CloneTo(this.c);
            }

            @Override
            public void process(Rectangle areaToProcess) {
                if (Rectangle.op_Equality(areaToProcess, this.c)) {
                    this.a.process(areaToProcess.Clone(), this.b, areaToProcess.getLocation().Clone(), new Point(areaToProcess.getRight(), areaToProcess.getBottom()));
                } else {
                    int n2 = areaToProcess.getWidth();
                    int n3 = areaToProcess.getHeight();
                    int n4 = n2 * n3;
                    int[] nArray = new int[n4];
                    int n5 = areaToProcess.getTop() - this.c.getTop();
                    int n6 = this.c.getWidth();
                    if (areaToProcess.getLeft() == this.c.getLeft() && areaToProcess.getRight() == this.c.getRight()) {
                        int n7 = n5 * n6;
                        Array.copy(Array.boxing(this.b), n7, Array.boxing(nArray), 0, n4);
                    } else {
                        int n8 = areaToProcess.getLeft() - this.c.getLeft();
                        int n9 = areaToProcess.getHeight();
                        for (int i2 = 0; i2 < n9; ++i2) {
                            int n10 = n5++ * n6 + n8;
                            Array.copy(Array.boxing(this.b), n10, Array.boxing(nArray), i2 * n2, n2);
                        }
                    }
                    this.a.process(areaToProcess.Clone(), nArray, areaToProcess.getLocation().Clone(), new Point(areaToProcess.getRight(), areaToProcess.getBottom()));
                }
            }
        }
    }
}

