/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.codecs.writers;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.Array;
import com.aspose.html.internal.ms.System.BitConverter;
import com.aspose.html.internal.ms.System.Buffer;
import com.aspose.html.internal.ms.System.InvalidOperationException;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.msMath;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.BufferHelper;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.ByteConverter;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.ColorPalette;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.ColorPaletteHelper;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.TiffCodecDataWriter;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.imageoptions.TiffOptions;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IAdvancedBufferProcessor;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IColorPalette;
import com.aspose.html.internal.ms.lang.Operators;
import java.awt.Color;

public abstract class TiffByteConverterWriter
extends TiffCodecDataWriter {
    protected TiffByteConverterWriter(TiffOptions tiffOptions, int width, int height) {
        super(tiffOptions, width, height);
    }

    protected static ColorConverter getColorConverter(TiffOptions options, int width, int height, int rowsPerStrip) {
        int n2 = options.getPredictor();
        ColorConverter colorConverter = null;
        int[] nArray = options.getBitsPerSample();
        int n3 = options.getBitsPerPixel();
        if (nArray == null) {
            throw new ArgumentException("TiffImageException: The bits per sample are not specified");
        }
        int n4 = options.getPhotometric();
        if (nArray.length == 1) {
            IColorPalette iColorPalette = options.getPalette();
            if (n4 == 3 && iColorPalette == null) {
                throw new ArgumentException("TiffImageException: The palette is not defined for palettized tiff image.");
            }
            if (n4 != 3) {
                switch (nArray[0]) {
                    case 1: {
                        if (n4 != 1) {
                            iColorPalette = new ColorPalette(new int[]{Color.WHITE.getRGB(), Color.BLACK.getRGB()});
                            break;
                        }
                        iColorPalette = new ColorPalette(new int[]{Color.BLACK.getRGB(), Color.WHITE.getRGB()});
                        break;
                    }
                    case 4: {
                        iColorPalette = ColorPaletteHelper.create4BitGrayscale(n4 == 0);
                        break;
                    }
                    case 8: 
                    case 16: {
                        iColorPalette = ColorPaletteHelper.create8BitGrayscale(n4 == 0);
                    }
                }
            }
            if (n2 == 2) {
                if ((nArray[0] & 0xFFFF) == 8) {
                    colorConverter = new Bitmap8BitPredictorConverter(width, height, iColorPalette);
                }
            } else {
                switch (nArray[0]) {
                    case 1: {
                        colorConverter = new Bitmap1BitConverter(width, height, rowsPerStrip, iColorPalette);
                        break;
                    }
                    case 4: {
                        colorConverter = new Bitmap4BitConverter(width, height, rowsPerStrip, iColorPalette);
                        break;
                    }
                    case 8: {
                        colorConverter = new Bitmap8BitConverter(width, height, rowsPerStrip, iColorPalette);
                        break;
                    }
                    case 16: {
                        colorConverter = n4 == 3 ? new Bitmap16BitPaletteConverter(width, height, rowsPerStrip, iColorPalette) : new Bitmap16BitGrayscaleConverter(width, height, rowsPerStrip, iColorPalette);
                    }
                }
            }
        } else if (nArray.length == 3) {
            if ((nArray[0] & 0xFFFF) == 8 && (nArray[1] & 0xFFFF) == 8 && (nArray[2] & 0xFFFF) == 8) {
                colorConverter = n2 == 2 ? new HorizontalPredictorRgb888(width, height) : new Rgb888Converter(width, height, rowsPerStrip);
            }
        } else if (nArray.length >= 4) {
            boolean bl2 = true;
            for (int n5 : nArray) {
                if ((n5 & 0xFFFF) == 8) continue;
                bl2 = false;
                break;
            }
            if (bl2) {
                colorConverter = n2 == 2 ? new HorizontalPredictorRgb8888(width, height, n3, nArray.length) : new Rgb8888Converter(width, height, rowsPerStrip, nArray.length, n3);
            }
        }
        if (colorConverter == null) {
            String string = "TiffImageException: Unsupported bits per sample ";
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                string = StringExtensions.plusEqOperator(string, Operators.boxing(nArray[i2]));
                if (i2 >= nArray.length - 1) continue;
                string = StringExtensions.plusEqOperator(string, ", ");
            }
            string = StringExtensions.plusEqOperator(string, " count.");
            throw new InvalidOperationException(string);
        }
        return colorConverter;
    }

    private static class Bitmap16BitPaletteConverter
    extends ColorConverter {
        private final IColorPalette a;

        public Bitmap16BitPaletteConverter(int width, int height, int rowsPerStrip, IColorPalette palette) {
            super(width, height, rowsPerStrip, 16);
            if (palette == null) {
                throw new ArgumentNullException("palette");
            }
            this.a = palette;
        }

        @Override
        protected void convert(int[] pixels, int colorIndex, int count) {
            for (int i2 = 0; i2 < count; ++i2) {
                int n2 = this.a.getNearestColorIndex(pixels[colorIndex++]) & 0xFFFF;
                byte[] byArray = BitConverter.getBytesUInt16(n2);
                Buffer.blockCopy(Array.boxing(byArray), 0, Array.boxing(this.buffer), this.bufferIndex, 2);
                this.bufferIndex += 2;
            }
        }
    }

    private static class Bitmap16BitGrayscaleConverter
    extends ColorConverter {
        private final IColorPalette a;

        public Bitmap16BitGrayscaleConverter(int width, int height, int rowsPerStrip, IColorPalette palette) {
            super(width, height, rowsPerStrip, 16);
            if (palette == null) {
                throw new ArgumentNullException("palette");
            }
            this.a = palette;
        }

        @Override
        protected void convert(int[] pixels, int colorIndex, int count) {
            for (int i2 = 0; i2 < count; ++i2) {
                int n2 = this.a.getNearestColorIndex(pixels[colorIndex++]) & 0xFFFF;
                ByteConverter.writeBigEndianBytesUInt16(n2, this.buffer, this.bufferIndex);
                this.bufferIndex += 2;
            }
        }
    }

    private static class Bitmap8BitPredictorConverter
    extends ColorConverter {
        private final IColorPalette a;
        private byte b;

        public Bitmap8BitPredictorConverter(int width, int height, IColorPalette palette) {
            super(width, height, 1, 8);
            if (palette == null) {
                throw new ArgumentNullException("palette");
            }
            this.a = palette;
        }

        @Override
        protected void convert(int[] pixels, int colorIndex, int count) {
            for (int i2 = 0; i2 < count; ++i2) {
                byte by2 = (byte)this.a.getNearestColorIndex(pixels[colorIndex++]);
                this.buffer[this.bufferIndex++] = (byte)((by2 & 0xFF) - (this.b & 0xFF));
                this.b = by2;
            }
            if (this.rowLeft - count == 0) {
                this.b = 0;
            }
        }
    }

    private static class Bitmap8BitConverter
    extends ColorConverter {
        private final IColorPalette a;

        public Bitmap8BitConverter(int width, int height, int rowsPerStrip, IColorPalette palette) {
            super(width, height, rowsPerStrip, 8);
            if (palette == null) {
                throw new ArgumentNullException("palette");
            }
            this.a = palette;
        }

        @Override
        protected void convert(int[] pixels, int colorIndex, int count) {
            for (int i2 = 0; i2 < count; ++i2) {
                byte by2 = (byte)this.a.getNearestColorIndex(pixels[colorIndex++]);
                this.buffer[this.bufferIndex++] = by2;
            }
        }
    }

    private static class Bitmap4BitConverter
    extends ColorConverter {
        private final IColorPalette a;

        public Bitmap4BitConverter(int width, int height, int rowsPerStrip, IColorPalette palette) {
            super(width, height, rowsPerStrip, 4);
            if (palette == null) {
                throw new ArgumentNullException("palette");
            }
            this.a = palette;
        }

        @Override
        protected void convert(int[] pixels, int colorIndex, int count) {
            while (count > 0) {
                int n2 = msMath.min((this.bitIndex + 1) / 4, count);
                byte by2 = this.buffer[this.bufferIndex];
                for (int i2 = 0; i2 < n2; ++i2) {
                    int n3 = this.a.getNearestColorIndex(pixels[colorIndex++]);
                    int n4 = this.bitIndex - 3;
                    by2 = (byte)(by2 & 0xFF & ((byte)(~(15 << n4)) & 0xFF));
                    by2 = (byte)(by2 & 0xFF | (byte)(n3 << n4) & 0xFF);
                    this.bitIndex -= 4;
                }
                this.buffer[this.bufferIndex] = by2;
                count -= n2;
                if (this.bitIndex >= 0) continue;
                this.bitIndex = 7;
                ++this.bufferIndex;
            }
        }
    }

    private static class Bitmap1BitConverter
    extends ColorConverter {
        private final IColorPalette a;

        public Bitmap1BitConverter(int width, int height, int rowsPerStrip, IColorPalette palette) {
            super(width, height, rowsPerStrip, 1);
            if (palette == null) {
                throw new ArgumentNullException("palette");
            }
            this.a = palette;
        }

        @Override
        protected void convert(int[] pixels, int colorIndex, int count) {
            while (count > 0) {
                int n2 = msMath.min(this.bitIndex + 1, count);
                byte by2 = this.buffer[this.bufferIndex];
                for (int i2 = 0; i2 < n2; ++i2) {
                    int n3 = this.a.getNearestColorIndex(pixels[colorIndex++]);
                    byte by3 = (byte)(1 << this.bitIndex);
                    by2 = n3 == 1 ? (byte)(by2 & 0xFF | by3 & 0xFF) : (byte)(by2 & 0xFF & ((byte)(~(by3 & 0xFF)) & 0xFF));
                    --this.bitIndex;
                }
                this.buffer[this.bufferIndex] = by2;
                count -= n2;
                if (this.bitIndex >= 0) continue;
                this.bitIndex = 7;
                ++this.bufferIndex;
            }
        }
    }

    private static class HorizontalPredictorRgb8888
    extends HorizontalRgbPredictor {
        private final int a;

        public HorizontalPredictorRgb8888(int width, int height, int sampleSizeInBits, int samplesPerPixel) {
            super(width, height, sampleSizeInBits);
            this.a = samplesPerPixel;
        }

        @Override
        protected void convert(int[] pixels, int colorIndex, int count) {
            for (int i2 = 0; i2 < count; ++i2) {
                int n2 = pixels[colorIndex++];
                byte by2 = (byte)(n2 >> 24);
                byte by3 = (byte)(n2 >> 16 & 0xFF);
                byte by4 = (byte)(n2 >> 8 & 0xFF);
                byte by5 = (byte)(n2 & 0xFF);
                this.buffer[this.bufferIndex] = (byte)((by3 & 0xFF) - (this.oldR & 0xFF));
                this.buffer[this.bufferIndex + 1] = (byte)((by4 & 0xFF) - (this.oldG & 0xFF));
                this.buffer[this.bufferIndex + 2] = (byte)((by5 & 0xFF) - (this.oldB & 0xFF));
                this.buffer[this.bufferIndex + 3] = (byte)((by2 & 0xFF) - (this.oldA & 0xFF));
                this.bufferIndex += this.a;
                this.oldA = by2;
                this.oldR = by3;
                this.oldG = by4;
                this.oldB = by5;
            }
            this.zeroPredictors(count);
        }
    }

    private static class HorizontalPredictorRgb888
    extends HorizontalRgbPredictor {
        public HorizontalPredictorRgb888(int width, int height) {
            super(width, height, 24);
        }

        @Override
        protected void convert(int[] pixels, int colorIndex, int count) {
            for (int i2 = 0; i2 < count; ++i2) {
                int n2 = pixels[colorIndex++];
                byte by2 = (byte)(n2 >> 16 & 0xFF);
                byte by3 = (byte)(n2 >> 8 & 0xFF);
                byte by4 = (byte)(n2 & 0xFF);
                this.buffer[this.bufferIndex] = (byte)((by2 & 0xFF) - (this.oldR & 0xFF));
                this.buffer[this.bufferIndex + 1] = (byte)((by3 & 0xFF) - (this.oldG & 0xFF));
                this.buffer[this.bufferIndex + 2] = (byte)((by4 & 0xFF) - (this.oldB & 0xFF));
                this.bufferIndex += 3;
                this.oldR = by2;
                this.oldG = by3;
                this.oldB = by4;
            }
            this.zeroPredictors(count);
        }
    }

    private static abstract class HorizontalRgbPredictor
    extends ColorConverter {
        protected byte oldR;
        protected byte oldG;
        protected byte oldB;
        protected byte oldA;

        protected HorizontalRgbPredictor(int width, int height, int sampleSizeInBits) {
            super(width, height, 1, sampleSizeInBits);
            this.rowLeft = width;
        }

        protected void zeroPredictors(int count) {
            if (this.rowLeft - count == 0) {
                this.oldA = 0;
                this.oldR = 0;
                this.oldG = 0;
                this.oldB = 0;
            }
        }
    }

    private static class Rgb8888Converter
    extends ColorConverter {
        private final int a;

        public Rgb8888Converter(int width, int height, int rowsPerStrip, int samplesPerPixel, int sampleSizeInBits) {
            super(width, height, rowsPerStrip, sampleSizeInBits);
            this.a = samplesPerPixel;
        }

        @Override
        protected void convert(int[] pixels, int colorIndex, int count) {
            for (int i2 = 0; i2 < count; ++i2) {
                int n2 = pixels[colorIndex++];
                byte by2 = (byte)(n2 >> 24);
                byte by3 = (byte)(n2 >> 16 & 0xFF);
                byte by4 = (byte)(n2 >> 8 & 0xFF);
                byte by5 = (byte)(n2 & 0xFF);
                this.buffer[this.bufferIndex] = by3;
                this.buffer[this.bufferIndex + 1] = by4;
                this.buffer[this.bufferIndex + 2] = by5;
                this.buffer[this.bufferIndex + 3] = by2;
                this.bufferIndex += this.a;
            }
        }
    }

    private static class Rgb888Converter
    extends ColorConverter {
        public Rgb888Converter(int width, int height, int rowsPerStrip) {
            super(width, height, rowsPerStrip, 24);
        }

        @Override
        protected void convert(int[] pixels, int colorIndex, int count) {
            for (int i2 = 0; i2 < count; ++i2) {
                int n2 = pixels[colorIndex++];
                byte by2 = (byte)(n2 >> 16 & 0xFF);
                byte by3 = (byte)(n2 >> 8 & 0xFF);
                byte by4 = (byte)(n2 & 0xFF);
                this.buffer[this.bufferIndex++] = by2;
                this.buffer[this.bufferIndex++] = by3;
                this.buffer[this.bufferIndex++] = by4;
            }
        }
    }

    protected static abstract class ColorConverter {
        protected final int width;
        private int a;
        private final int b;
        protected int rowLeft;
        private int c;
        protected final byte[] buffer;
        protected int bufferIndex;
        protected int bitIndex = 7;

        protected ColorConverter(int width, int height, int rowsPerStrip, int sampleSizeInBits) {
            boolean bl2;
            this.b = sampleSizeInBits;
            this.width = width;
            this.c = rowsPerStrip;
            this.a = height;
            boolean bl3 = bl2 = width * sampleSizeInBits % 8 != 0;
            if (bl2) {
                this.c = 1;
            }
            this.rowLeft = this.c * width;
            this.buffer = BufferHelper.allocate((width * sampleSizeInBits + 7) / 8 * this.c);
            if (this.buffer.length * 8 / sampleSizeInBits == 0) {
                throw new InvalidOperationException("TiffImageException: The buffer allocated is too small. Cannot continue execution.");
            }
        }

        public void convert(int[] pixels, IAdvancedBufferProcessor partialDataWriter) {
            int n2 = 0;
            int n3 = pixels.length;
            int n4 = this.buffer.length;
            int n5 = this.a(n3 - n2);
            while (n5 > 0) {
                this.convert(pixels, n2, n5);
                n2 += n5;
                this.rowLeft -= n5;
                int n6 = ((n4 - this.bufferIndex) * 8 - (7 - this.bitIndex)) / this.b;
                if (this.rowLeft == 0 || n6 == 0) {
                    if (this.rowLeft == 0 && this.bitIndex != 7) {
                        ++this.bufferIndex;
                    }
                    partialDataWriter.processBuffer(this.buffer, this.bufferIndex);
                    if (this.rowLeft == 0) {
                        int n7 = msMath.min(this.a, this.c);
                        partialDataWriter.finishRows(n7);
                        this.a -= n7;
                        this.rowLeft = this.width * msMath.min(this.a, this.c);
                        this.bitIndex = 7;
                    } else if (this.bufferIndex > 0 && this.bufferIndex < n4 && this.bitIndex < 7) {
                        this.buffer[0] = this.buffer[this.bufferIndex];
                    }
                    this.bufferIndex = 0;
                }
                n5 = this.a(n3 - n2);
            }
        }

        protected abstract void convert(int[] var1, int var2, int var3);

        private int a(int n2) {
            int n3 = this.buffer.length;
            int n4 = ((n3 - this.bufferIndex) * 8 - (7 - this.bitIndex)) / this.b;
            int n5 = msMath.min(n2, n4);
            n5 = msMath.min(n5, this.rowLeft);
            return n5;
        }
    }
}

