/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.codecs.writers;

import com.aspose.html.internal.ms.System.msMath;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.Rectangle;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.exceptions.imageformats.TiffImageException;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.codecs.writers.TiffByteConverterWriter;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.imageoptions.TiffOptions;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IAdvancedBufferProcessor;

public class TiffPackBitsWriter
extends TiffByteConverterWriter {
    private BufferProcessor a;
    private TiffByteConverterWriter.ColorConverter b;

    public TiffPackBitsWriter(TiffOptions tiffOptions, int width, int height) {
        super(tiffOptions, width, height);
    }

    @Override
    public void encode(int[] colorData, Rectangle area, IAdvancedBufferProcessor partialDataWriter) {
        if (this.b == null) {
            int n2 = this.getRowsPerStrip();
            this.b = TiffByteConverterWriter.getColorConverter(this.getOptions(), this.getWidth(), this.getHeight(), n2);
            PackBitsEncoder packBitsEncoder = new PackBitsEncoder(partialDataWriter, n2, this.getOptions().getBitsPerPixel(), this.getWidth());
            packBitsEncoder.startEncoding();
            this.a = new BufferProcessor(packBitsEncoder, this.getHeight(), n2);
        }
        this.b.convert(colorData, this.a);
    }

    private static class PackBitsEncoder {
        private final IAdvancedBufferProcessor a;
        private final int b;
        private final int c;
        private byte[] d;
        private int e;

        public PackBitsEncoder(IAdvancedBufferProcessor partialDataWriter, int rowsPerStrip, int bitsPerPixel, int width) {
            this.a = partialDataWriter;
            int n2 = (bitsPerPixel * width + 7) / 8;
            int n3 = n2 + (n2 + 127) / 128;
            this.c = n3 * rowsPerStrip;
            this.b = n2;
        }

        public void startEncoding() {
            this.d = new byte[this.c];
            this.e = 0;
        }

        public void finishEncoding(int rowsCount) {
            this.a.processBuffer(this.d, this.e);
            this.a.finishRows(rowsCount);
        }

        public void encode(byte[] buffer, int bufferLength) {
            int n2 = bufferLength;
            int n3 = 0;
            do {
                this.e = PackBitsEncoder.a(buffer, n3, this.b, this.d, this.e);
                n3 += this.b;
            } while ((n2 -= this.b) >= this.b);
            if (n2 != 0) {
                throw new TiffImageException("The strip has corrupt data and cannot be decoded.");
            }
        }

        private static int a(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) {
            int n5 = n2 + n3 - 1;
            int n6 = n5 - 1;
            while (n2 <= n5) {
                int n7;
                byte by2 = byArray[n2];
                for (n7 = 1; n7 < 127 && n2 < n5 && (byArray[n2] & 0xFF) == (byArray[n2 + 1] & 0xFF); ++n7, ++n2) {
                }
                if (n7 > 1) {
                    ++n2;
                    byArray2[n4++] = (byte)(-(n7 - 1) & 0xFF);
                    byArray2[n4++] = by2;
                }
                int n8 = n4;
                for (n7 = 0; n7 < 128 && (n2 < n5 && (byArray[n2] & 0xFF) != (byArray[n2 + 1] & 0xFF) || n2 < n6 && (byArray[n2] & 0xFF) != (byArray[n2 + 2] & 0xFF)); ++n7) {
                    byArray2[++n4] = byArray[n2++];
                }
                if (n7 > 0) {
                    byArray2[n8] = (byte)(n7 - 1 & 0xFF);
                    ++n4;
                }
                if (n2 != n5) continue;
                if (n7 > 0 && n7 < 128) {
                    int n9 = n8;
                    byArray2[n9] = (byte)(byArray2[n9] + 1);
                    byArray2[n4++] = byArray[n2++];
                    continue;
                }
                byArray2[n4++] = 0;
                byArray2[n4++] = byArray[n2++];
            }
            return n4;
        }
    }

    private static class BufferProcessor
    implements IAdvancedBufferProcessor {
        private final PackBitsEncoder a;
        private final int b;
        private int c;
        private int d;

        public BufferProcessor(PackBitsEncoder encoder, int height, int rowsPerStrip) {
            this.a = encoder;
            this.b = rowsPerStrip;
            this.c = height;
            this.d = rowsPerStrip;
        }

        @Override
        public void finishRow() {
            this.finishRows(this.b);
        }

        @Override
        public void finishRows(int rowsCount) {
            this.d -= rowsCount;
            if (this.d == 0) {
                int n2 = msMath.min(this.b, this.c);
                this.a.finishEncoding(n2);
                this.c -= n2;
                if (this.c > 0) {
                    this.d = msMath.min(this.b, this.c);
                    this.a.startEncoding();
                }
            }
        }

        @Override
        public void processBuffer(byte[] buffer, int bufferLength) {
            this.a.encode(buffer, bufferLength);
        }
    }
}

