/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.ico;

import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.ico.BmpEncoder;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.ico.BmpInfoHeader;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.ico.IconEntry;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;

public class IcoEncoder {
    static final int ICON_TYPE = 1;
    static final int CURSOR_TYPE = 2;

    private IcoEncoder() {
    }

    public static void write(BufferedImage image, ImageOutputStream os) throws IOException {
        IcoEncoder.write(image, -1, os);
    }

    public static void write(List<BufferedImage> images, ImageOutputStream os) throws IOException {
        IcoEncoder.write(images, null, null, os);
    }

    public static void write(BufferedImage image, int bpp, ImageOutputStream os) throws IOException {
        ArrayList<BufferedImage> arrayList = new ArrayList<BufferedImage>(1);
        arrayList.add(image);
        IcoEncoder.write(arrayList, new int[]{bpp}, new boolean[]{false}, os);
    }

    public static void write(List<BufferedImage> images, int[] bpp, ImageOutputStream os) throws IOException {
        IcoEncoder.write(images, bpp, null, os);
    }

    public static void write(List<BufferedImage> images, int[] bpp, boolean[] compress, ImageOutputStream out) throws IOException {
        Object object;
        Object object2;
        BufferedImage bufferedImage;
        int n2;
        int n3 = images.size();
        IcoEncoder.writeFileHeader(n3, 1, out);
        int n4 = 6 + n3 * 16;
        ArrayList<Object> arrayList = new ArrayList<Object>(n3);
        ArrayList<BufferedImage> arrayList2 = new ArrayList<BufferedImage>(n3);
        ArrayList<byte[]> arrayList3 = null;
        if (compress != null) {
            arrayList3 = new ArrayList<byte[]>(n3);
        }
        ImageWriter imageWriter = null;
        for (n2 = 0; n2 < n3; ++n2) {
            bufferedImage = images.get(n2);
            int n5 = bpp == null ? -1 : bpp[n2];
            object2 = n5 == -1 ? bufferedImage : IcoEncoder.convert(bufferedImage, n5);
            arrayList2.add((BufferedImage)object2);
            object = BmpEncoder.createHeader((BufferedImage)object2, 0, 0);
            IconEntry iconEntry = IcoEncoder.createIconEntry((BmpInfoHeader)object);
            if (compress != null) {
                if (compress[n2]) {
                    if (imageWriter == null) {
                        imageWriter = IcoEncoder.a();
                    }
                    byte[] byArray = IcoEncoder.a(imageWriter, (BufferedImage)object2);
                    arrayList3.add(byArray);
                    iconEntry.sizeInBytes = byArray.length;
                } else {
                    arrayList3.add(null);
                }
            }
            ((BmpInfoHeader)object).height *= 2;
            iconEntry.fileOffset = n4;
            n4 += iconEntry.sizeInBytes;
            iconEntry.write(out);
            arrayList.add(object);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            bufferedImage = images.get(n2);
            BufferedImage bufferedImage2 = (BufferedImage)arrayList2.get(n2);
            if (compress == null || !compress[n2]) {
                object2 = (BmpInfoHeader)arrayList.get(n2);
                ((BmpInfoHeader)object2).write(out);
                if (((BmpInfoHeader)object2).bitCount <= 8) {
                    object = (IndexColorModel)bufferedImage2.getColorModel();
                    BmpEncoder.writeColorMap((IndexColorModel)object, out);
                }
                IcoEncoder.a(bufferedImage2, (BmpInfoHeader)object2, out);
                IcoEncoder.writeAndBitmap(bufferedImage, bpp == null ? ((BmpInfoHeader)object2).bitCount : bpp[n2], out);
                continue;
            }
            object2 = (byte[])arrayList3.get(n2);
            out.write((byte[])object2);
        }
        out.flush();
    }

    public static void writeFileHeader(int count, int type, ImageOutputStream out) throws IOException {
        out.writeShort(0);
        out.writeShort((short)type);
        out.writeShort((short)count);
    }

    public static IconEntry createIconEntry(BmpInfoHeader ih2) {
        int n2;
        IconEntry iconEntry = new IconEntry();
        iconEntry.width = ih2.width == 256 ? 0 : ih2.width;
        iconEntry.height = ih2.height == 256 ? 0 : ih2.height;
        iconEntry.colorCount = ih2.numColors >= 256 ? 0 : ih2.numColors;
        iconEntry.reserved = 0;
        iconEntry.planes = 1;
        iconEntry.bitCount = ih2.bitCount;
        int n3 = ih2.bitCount <= 8 ? (1 << ih2.bitCount) * 4 : 0;
        int n4 = BmpEncoder.getBitmapSize(ih2.width, ih2.height, ih2.bitCount);
        int n5 = BmpEncoder.getBitmapSize(ih2.width, ih2.height, 1);
        iconEntry.sizeInBytes = n2 = ih2.size + n3 + n4 + n5;
        iconEntry.fileOffset = 0;
        return iconEntry;
    }

    public static void writeAndBitmap(BufferedImage img, int bpp, ImageOutputStream out) throws IOException {
        WritableRaster writableRaster = img.getAlphaRaster();
        if (img.getColorModel() instanceof IndexColorModel && img.getColorModel().hasAlpha()) {
            int n2 = img.getWidth();
            int n3 = img.getHeight();
            int n4 = BmpEncoder.calcStride(n2, bpp);
            byte[] byArray = new byte[n4];
            IndexColorModel indexColorModel = (IndexColorModel)img.getColorModel();
            WritableRaster writableRaster2 = img.getRaster();
            for (int i2 = n3 - 1; i2 >= 0; --i2) {
                for (int i3 = 0; i3 < n2; ++i3) {
                    int n5 = i3 / 8;
                    int n6 = i3 % 8;
                    int n7 = writableRaster2.getSample(i3, i2, 0);
                    int n8 = indexColorModel.getAlpha(n7);
                    int n9 = ~n8 & 1;
                    byArray[n5] = IcoEncoder.a(byArray[n5], n6, n9);
                }
                out.write(byArray);
            }
        } else if (writableRaster == null) {
            int n10;
            int n11 = img.getHeight();
            int n12 = img.getWidth();
            int n13 = BmpEncoder.calcStride(n12, bpp);
            byte[] byArray = new byte[n13];
            for (n10 = 0; n10 < n13; ++n10) {
                byArray[n10] = 0;
            }
            for (n10 = n11 - 1; n10 >= 0; --n10) {
                out.write(byArray);
            }
        } else {
            int n14 = img.getWidth();
            int n15 = img.getHeight();
            int n16 = BmpEncoder.calcStride(n14, 1);
            byte[] byArray = new byte[n16];
            for (int i4 = n15 - 1; i4 >= 0; --i4) {
                for (int i5 = 0; i5 < n14; ++i5) {
                    int n17 = i5 / 8;
                    int n18 = i5 % 8;
                    int n19 = writableRaster.getSample(i5, i4, 0);
                    int n20 = ~n19 & 1;
                    byArray[n17] = IcoEncoder.a(byArray[n17], n18, n20);
                }
                out.write(byArray);
            }
        }
        out.flush();
    }

    private static byte a(byte by2, int n2, int n3) {
        int n4 = 1 << 7 - n2;
        by2 = (byte)(by2 & ~n4);
        by2 = (byte)(by2 | n3 << 7 - n2);
        return by2;
    }

    private static void a(BufferedImage bufferedImage, BmpInfoHeader bmpInfoHeader, ImageOutputStream imageOutputStream) throws IOException {
        WritableRaster writableRaster = bufferedImage.getRaster();
        switch (bmpInfoHeader.bitCount) {
            case 1: {
                BmpEncoder.write1bpp(writableRaster, imageOutputStream);
                break;
            }
            case 4: {
                BmpEncoder.write4bpp(writableRaster, imageOutputStream);
                break;
            }
            case 8: {
                BmpEncoder.write8bpp(writableRaster, imageOutputStream);
                break;
            }
            case 24: {
                BmpEncoder.write24bpp(writableRaster, imageOutputStream);
                break;
            }
            case 32: {
                WritableRaster writableRaster2 = bufferedImage.getAlphaRaster();
                BmpEncoder.write32bpp(writableRaster, writableRaster2, imageOutputStream);
            }
        }
    }

    public static BufferedImage convert(BufferedImage img, int bpp) {
        BufferedImage bufferedImage = null;
        switch (bpp) {
            case 1: {
                bufferedImage = ColorDepthConverter.convert1(img);
                break;
            }
            case 4: {
                bufferedImage = ColorDepthConverter.convert4(img);
                break;
            }
            case 8: {
                bufferedImage = ColorDepthConverter.convert8(img);
                break;
            }
            case 24: {
                int n2 = img.getColorModel().getPixelSize();
                if (n2 == 24 || n2 == 32) {
                    bufferedImage = img;
                    break;
                }
                bufferedImage = ColorDepthConverter.convert24(img);
                break;
            }
            case 32: {
                int n3 = img.getColorModel().getPixelSize();
                bufferedImage = n3 == 24 || n3 == 32 ? img : ColorDepthConverter.convert32(img);
            }
        }
        return bufferedImage;
    }

    private static ImageWriter a() {
        ImageWriter imageWriter = null;
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersByFormatName("png");
        if (iterator.hasNext()) {
            imageWriter = iterator.next();
        }
        return imageWriter;
    }

    private static byte[] a(ImageWriter imageWriter, BufferedImage bufferedImage) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(byteArrayOutputStream);
        imageWriter.setOutput(imageOutputStream);
        imageWriter.write(bufferedImage);
        byteArrayOutputStream.flush();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        return byArray;
    }

    static class ColorDepthConverter {
        ColorDepthConverter() {
        }

        public static BufferedImage convert1(BufferedImage src) {
            IndexColorModel indexColorModel = new IndexColorModel(1, 2, new byte[]{0, -1}, new byte[]{0, -1}, new byte[]{0, -1});
            BufferedImage bufferedImage = new BufferedImage(src.getWidth(), src.getHeight(), 12, indexColorModel);
            ColorConvertOp colorConvertOp = new ColorConvertOp(src.getColorModel().getColorSpace(), bufferedImage.getColorModel().getColorSpace(), null);
            colorConvertOp.filter(src, bufferedImage);
            return bufferedImage;
        }

        public static BufferedImage convert4(BufferedImage src) {
            int[] nArray = new int[]{0, 0x800000, 32768, 0x808000, 128, 0x800080, 32896, 0x808080, 0xC0C0C0, 0xFF0000, 65280, 0xFFFF00, 255, 0xFF00FF, 65535, 0xFFFFFF};
            return ColorDepthConverter.convert4(src, nArray);
        }

        public static BufferedImage convert4(BufferedImage src, int[] cmap) {
            IndexColorModel indexColorModel = new IndexColorModel(4, cmap.length, cmap, 0, false, 1, 0);
            BufferedImage bufferedImage = new BufferedImage(src.getWidth(), src.getHeight(), 12, indexColorModel);
            ColorConvertOp colorConvertOp = new ColorConvertOp(src.getColorModel().getColorSpace(), bufferedImage.getColorModel().getColorSpace(), null);
            colorConvertOp.filter(src, bufferedImage);
            return bufferedImage;
        }

        public static BufferedImage convert8(BufferedImage src) {
            BufferedImage bufferedImage = new BufferedImage(src.getWidth(), src.getHeight(), 13);
            ColorConvertOp colorConvertOp = new ColorConvertOp(src.getColorModel().getColorSpace(), bufferedImage.getColorModel().getColorSpace(), null);
            colorConvertOp.filter(src, bufferedImage);
            return bufferedImage;
        }

        public static BufferedImage convert24(BufferedImage src) {
            BufferedImage bufferedImage = new BufferedImage(src.getWidth(), src.getHeight(), 1);
            ColorConvertOp colorConvertOp = new ColorConvertOp(src.getColorModel().getColorSpace(), bufferedImage.getColorModel().getColorSpace(), null);
            colorConvertOp.filter(src, bufferedImage);
            return bufferedImage;
        }

        public static BufferedImage convert32(BufferedImage src) {
            BufferedImage bufferedImage = new BufferedImage(src.getWidth(), src.getHeight(), 2);
            ColorConvertOp colorConvertOp = new ColorConvertOp(src.getColorModel().getColorSpace(), bufferedImage.getColorModel().getColorSpace(), null);
            colorConvertOp.filter(src, bufferedImage);
            return bufferedImage;
        }
    }
}

