/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png;

import com.aspose.html.internal.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.internal.ms.System.IO.Stream;
import com.aspose.html.internal.ms.System.InvalidOperationException;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.GrayscaleAlphaConverter;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.GrayscaleConverter;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.PaletteConverter;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.PngAwtConverter;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.RgbConverter;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.RgbaConverter;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.PngReader;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.PngjInputException;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.PngMetadata;
import com.aspose.html.internal.ms.core.drawing.a.a;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.imageio.IIOException;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

public class PngjImageReader
extends ImageReader {
    static final int PNG_COLOR_GRAY = 0;
    static final int PNG_COLOR_RGB = 2;
    static final int PNG_COLOR_PALETTE = 3;
    static final int PNG_COLOR_GRAY_ALPHA = 4;
    static final int PNG_COLOR_RGB_ALPHA = 6;
    private boolean a = false;
    private PngReader b = null;
    private PngMetadata c = null;
    private boolean d = false;

    public PngjImageReader(ImageReaderSpi originatingProvider) {
        super(originatingProvider);
    }

    @Override
    public void setInput(Object input) {
        this.input = input;
    }

    private void a() {
        if (!this.a) {
            this.c();
            this.b = this.input instanceof Stream ? new PngReader(((Stream)this.input).toInputStream(), "pnginput") : new PngReader(PngjImageReader.a((ImageInputStream)this.input), "pnginput");
            this.b.setCrcCheckDisabled();
            this.b.setUnpackedMode(true);
            this.c = this.b.getMetadata();
            this.d = this.b();
            this.a = true;
        }
    }

    private boolean b() {
        if (this.b.imgInfo.bitspPixel > 32) {
            return true;
        }
        switch (this.c.getIHDR().getColormodel()) {
            case 0: {
                if (this.b.imgInfo.bitspPixel == 1) break;
                return true;
            }
            case 4: {
                return true;
            }
            case 2: {
                break;
            }
            case 6: {
                return false;
            }
            case 3: {
                if (this.c.getIHDR().getBitspc() != 2) break;
                return true;
            }
        }
        return this.c.getTRNS() != null;
    }

    @Override
    public int getNumImages(boolean allowSearch) throws IOException {
        this.c();
        return 1;
    }

    @Override
    public int getWidth(int imageIndex) throws IOException {
        this.a(imageIndex);
        this.a();
        return this.c.getIHDR().getRows();
    }

    @Override
    public int getHeight(int imageIndex) throws IOException {
        this.a(imageIndex);
        this.a();
        return this.c.getIHDR().getCols();
    }

    @Override
    public Iterator<ImageTypeSpecifier> getImageTypes(int imageIndex) throws IOException {
        this.a(imageIndex);
        this.a();
        int n2 = this.c.getIHDR().getBitspc();
        int n3 = this.c.getIHDR().getColormodel();
        ArrayList<ImageTypeSpecifier> arrayList = new ArrayList<ImageTypeSpecifier>(1);
        switch (n3) {
            case 0: {
                this.a(arrayList, n2);
                break;
            }
            case 2: {
                this.d(arrayList, n2);
                break;
            }
            case 3: {
                this.c(arrayList, n2);
                break;
            }
            case 4: {
                this.b(arrayList, n2);
                break;
            }
            case 6: {
                this.e(arrayList, n2);
                break;
            }
            default: {
                throw new ArgumentOutOfRangeException("PNG image type should be on of (0 - Greyscale, 2 - Truecolour, 3 - Indexed-colour, 4 - Greyscale with alpha, 6 - Truecolour with alpha) but got " + n3);
            }
        }
        return arrayList.iterator();
    }

    private void a(List<ImageTypeSpecifier> list, int n2) {
        if (n2 != 1 && n2 != 2 && n2 != 4 && n2 != 8 && n2 != 16) {
            throw new ArgumentOutOfRangeException("BitDepth for Greyscale PNG image should be one of (1, 2, 4, 8, 16) but got " + n2);
        }
        if (this.d) {
            this.a(list);
        } else {
            list.add(com.aspose.html.internal.ms.core.drawing.a.a.b(n2));
        }
    }

    private void b(List<ImageTypeSpecifier> list, int n2) {
        if (n2 != 8 && n2 != 16) {
            throw new ArgumentOutOfRangeException("BitDepth for Greyscale with alpha PNG image should be one of (8, 16) but got " + n2);
        }
        this.a(list);
    }

    private void c(List<ImageTypeSpecifier> list, int n2) {
        if (n2 != 1 && n2 != 2 && n2 != 4 && n2 != 8) {
            throw new ArgumentOutOfRangeException("BitDepth for Indexed-colour PNG image should be one of (1, 2, 4, 8) but got " + n2);
        }
        if (this.d) {
            this.a(list);
        } else {
            byte[] byArray = this.c.getPLTE().getColors()[0];
            byte[] byArray2 = this.c.getPLTE().getColors()[1];
            byte[] byArray3 = this.c.getPLTE().getColors()[2];
            list.add(com.aspose.html.internal.ms.core.drawing.a.a.a(n2, byArray, byArray2, byArray3));
        }
    }

    private void d(List<ImageTypeSpecifier> list, int n2) {
        if (n2 != 8 && n2 != 16) {
            throw new ArgumentOutOfRangeException("BitDepth for Truecolour PNG image should be one of (8, 16) but got " + n2);
        }
        if (this.d) {
            this.a(list);
        } else {
            list.add(ImageTypeSpecifier.createFromBufferedImageType(5));
            list.add(ImageTypeSpecifier.createFromBufferedImageType(1));
            list.add(ImageTypeSpecifier.createFromBufferedImageType(4));
        }
    }

    private void e(List<ImageTypeSpecifier> list, int n2) {
        if (n2 != 8 && n2 != 16) {
            throw new ArgumentOutOfRangeException("BitDepth for Truecolour with alpha PNG image should be one of (8, 16) but got " + n2);
        }
        this.a(list);
    }

    private void a(List<ImageTypeSpecifier> list) {
        list.add(ImageTypeSpecifier.createFromBufferedImageType(6));
        list.add(ImageTypeSpecifier.createFromBufferedImageType(2));
    }

    @Override
    public IIOMetadata getStreamMetadata() throws IOException {
        return null;
    }

    @Override
    public IIOMetadata getImageMetadata(int imageIndex) throws IIOException {
        this.a(imageIndex);
        this.a();
        return this.c;
    }

    @Override
    public BufferedImage read(int imageIndex, ImageReadParam param) throws IOException {
        this.a(imageIndex);
        BufferedImage bufferedImage = this.a(param);
        return this.a(bufferedImage, imageIndex);
    }

    private BufferedImage a(ImageReadParam imageReadParam) throws IOException {
        this.a();
        int n2 = this.b.imgInfo.cols;
        int n3 = this.b.imgInfo.rows;
        BufferedImage bufferedImage = PngjImageReader.getDestination(imageReadParam, this.getImageTypes(0), n2, n3);
        try {
            PngAwtConverter pngAwtConverter = this.a(this.c.getIHDR().getColormodel(), bufferedImage);
            pngAwtConverter.convert();
        }
        catch (PngjInputException pngjInputException) {
            // empty catch block
        }
        this.b.end();
        return bufferedImage;
    }

    private PngAwtConverter a(int n2, BufferedImage bufferedImage) {
        switch (n2) {
            case 0: {
                return new GrayscaleConverter(this.b, bufferedImage);
            }
            case 4: {
                return new GrayscaleAlphaConverter(this.b, bufferedImage);
            }
            case 3: {
                return new PaletteConverter(this.b, bufferedImage);
            }
            case 2: {
                return new RgbConverter(this.b, bufferedImage);
            }
            case 6: {
                return new RgbaConverter(this.b, bufferedImage);
            }
        }
        throw new ArgumentOutOfRangeException("colorModel", "should be Gray(0), GrayAlpha(4), Palette(3), Rgb(2), Rgba(6)");
    }

    private BufferedImage a(BufferedImage bufferedImage, int n2) throws IIOException {
        Hashtable<String, Number> hashtable = new Hashtable<String, Number>();
        int n3 = this.b.imgInfo.bitspPixel;
        double[] dArray = this.c.getDpi();
        if (dArray[0] > 0.0 && dArray[1] > 0.0) {
            hashtable.put("dpiX", Float.valueOf((float)dArray[0]));
            hashtable.put("dpiY", Float.valueOf((float)dArray[1]));
        }
        hashtable.put("bitspPixel", n3);
        if (this.d) {
            hashtable.put("pixelFormat", 2498570);
            hashtable.put("bitspPixel", 32);
        }
        return new BufferedImage(bufferedImage.getColorModel(), bufferedImage.getRaster(), bufferedImage.isAlphaPremultiplied(), hashtable);
    }

    private void c() {
        if (this.input == null) {
            throw new InvalidOperationException("No input source set!");
        }
    }

    private void a(int n2) {
        if (n2 != 0) {
            throw new IndexOutOfBoundsException("imageIndex != 0!");
        }
    }

    private static InputStream a(ImageInputStream imageInputStream) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            if (imageInputStream != null) {
                int n2;
                imageInputStream.mark();
                byte[] byArray = new byte[1024];
                while ((n2 = imageInputStream.read(byArray)) > -1) {
                    byteArrayOutputStream.write(byArray, 0, n2);
                }
                byteArrayOutputStream.flush();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                imageInputStream.reset();
                return byteArrayInputStream;
            }
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

