/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png;

import com.aspose.html.internal.ms.System.InvalidOperationException;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.ImageInfo;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.ImageLine;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.PngEncoder;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.PngReader;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.PngWriter;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.ChunksList;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.PngChunkPLTE;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.PngMetadata;
import com.aspose.html.internal.ms.core.drawing.b.b;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.IIOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageOutputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;

public class PngjImageWriter
extends ImageWriter {
    private ImageOutputStream a;

    public PngjImageWriter(ImageWriterSpi originatingProvider) {
        super(originatingProvider);
    }

    @Override
    public void setOutput(Object output) {
        super.setOutput(output);
        this.a = (ImageOutputStream)output;
    }

    @Override
    public IIOMetadata getDefaultStreamMetadata(ImageWriteParam param) {
        return null;
    }

    @Override
    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageType, ImageWriteParam param) {
        return null;
    }

    @Override
    public IIOMetadata convertStreamMetadata(IIOMetadata inData, ImageWriteParam param) {
        return null;
    }

    @Override
    public IIOMetadata convertImageMetadata(IIOMetadata inData, ImageTypeSpecifier imageType, ImageWriteParam param) {
        return null;
    }

    @Override
    public void write(IIOMetadata streamMetadata, IIOImage image, ImageWriteParam param) throws IOException {
        if (this.a == null) {
            throw new InvalidOperationException("output == null!");
        }
        if (image == null) {
            throw new IllegalArgumentException("image == null!");
        }
        BufferedImage bufferedImage = (BufferedImage)image.getRenderedImage();
        Object object = bufferedImage.getProperty("bitspPixel");
        int n2 = (Integer)(object.equals(BufferedImage.UndefinedProperty) ? Integer.valueOf(bufferedImage.getColorModel().getPixelSize()) : object);
        Object object2 = bufferedImage.getProperty("pixelFormat");
        int n3 = (Integer)(object2.equals(BufferedImage.UndefinedProperty) ? Integer.valueOf(0) : object2);
        bufferedImage = this.a(bufferedImage, n2);
        ColorModel colorModel = bufferedImage.getColorModel();
        ImageInfo imageInfo = new ImageInfo(bufferedImage.getWidth(), bufferedImage.getHeight(), colorModel.getPixelSize() / colorModel.getNumComponents(), colorModel.hasAlpha(), false, colorModel instanceof IndexColorModel);
        ChunksList chunksList = new ChunksList(imageInfo);
        IIOMetadata iIOMetadata = image.getMetadata();
        if (iIOMetadata instanceof PngMetadata) {
            chunksList = ((PngMetadata)iIOMetadata).getChunkList();
        } else if (colorModel instanceof IndexColorModel) {
            this.a(imageInfo, chunksList, (IndexColorModel)colorModel);
        }
        ImageOutputStream imageOutputStream = this.a;
        ByteArrayOutputStream byteArrayOutputStream = null;
        if (n2 > 32) {
            byteArrayOutputStream = new ByteArrayOutputStream();
            imageOutputStream = new MemoryCacheImageOutputStream(byteArrayOutputStream);
        }
        this.a(imageOutputStream, imageInfo, chunksList, bufferedImage);
        if (n2 > 32) {
            try {
                imageOutputStream.flush();
                imageOutputStream.close();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                PngjImageWriter.write64(bufferedImage, byteArrayInputStream, this.a, n3);
            }
            catch (IOException iOException) {
                throw new IIOException(iOException.getMessage(), iOException);
            }
        }
    }

    private void a(ImageInfo imageInfo, ChunksList chunksList, IndexColorModel indexColorModel) {
        PngChunkPLTE pngChunkPLTE = new PngChunkPLTE(imageInfo);
        pngChunkPLTE.setNentries(indexColorModel.getMapSize());
        int[] nArray = new int[indexColorModel.getMapSize()];
        indexColorModel.getRGBs(nArray);
        pngChunkPLTE.setEntryRgb(nArray);
        chunksList.appendReadChunk(pngChunkPLTE, 2);
    }

    private void a(ImageOutputStream imageOutputStream, ImageInfo imageInfo, ChunksList chunksList, BufferedImage bufferedImage) throws IOException {
        PngWriter pngWriter = new PngWriter(imageOutputStream, imageInfo);
        pngWriter.setShouldCloseStream(false);
        pngWriter.copyChunksFrom(chunksList, 8);
        int[] nArray = new int[bufferedImage.getWidth() * bufferedImage.getColorModel().getNumComponents()];
        WritableRaster writableRaster = bufferedImage.getRaster();
        for (int i2 = 0; i2 < bufferedImage.getHeight(); ++i2) {
            nArray = writableRaster.getPixels(0, i2, bufferedImage.getWidth(), 1, nArray);
            pngWriter.writeRowInt(nArray, i2);
        }
        pngWriter.end();
    }

    private BufferedImage a(BufferedImage bufferedImage, int n2) {
        Object object;
        Object object2;
        ColorModel colorModel = bufferedImage.getColorModel();
        if (colorModel instanceof DirectColorModel) {
            object2 = bufferedImage.getRaster();
            object = ((Raster)object2).getDataBuffer();
            DirectColorModel directColorModel = (DirectColorModel)colorModel;
            BufferedImage bufferedImage2 = null;
            SinglePixelPackedSampleModel singlePixelPackedSampleModel = null;
            int[] nArray = null;
            int n3 = (Integer)(bufferedImage.getProperty("pixelFormat").equals(BufferedImage.UndefinedProperty) ? Integer.valueOf(139273) : bufferedImage.getProperty("pixelFormat"));
            if (directColorModel.getNumColorComponents() == 3 && n2 == 32 && n3 == 139273) {
                directColorModel = new DirectColorModel(32, directColorModel.getRedMask(), directColorModel.getGreenMask(), directColorModel.getBlueMask(), -16777216);
                nArray = new int[]{directColorModel.getRedMask(), directColorModel.getGreenMask(), directColorModel.getBlueMask(), directColorModel.getAlphaMask()};
                singlePixelPackedSampleModel = new SinglePixelPackedSampleModel(3, bufferedImage.getWidth(), bufferedImage.getHeight(), nArray);
                bufferedImage2 = new BufferedImage(directColorModel, Raster.createWritableRaster(singlePixelPackedSampleModel, (DataBuffer)object, null), bufferedImage.isAlphaPremultiplied(), null);
                for (int i2 = 0; i2 < bufferedImage.getWidth(); ++i2) {
                    for (int i3 = 0; i3 < bufferedImage.getHeight(); ++i3) {
                        bufferedImage2.setRGB(i2, i3, bufferedImage2.getRGB(i2, i3) | 0xFF000000);
                    }
                }
                bufferedImage = bufferedImage2;
            }
        }
        if ((object2 = colorModel.getColorSpace()) instanceof b) {
            object = new ColorConvertOp((ColorSpace)object2, ColorSpace.getInstance(1004), null);
            bufferedImage = ((ColorConvertOp)object).filter(bufferedImage, null);
        }
        return bufferedImage;
    }

    public static void write64(BufferedImage bufferedImage, InputStream instream, ImageOutputStream outstream, int pixelFormat) {
        int n2 = PngjImageWriter.getPixelFormatSize(pixelFormat);
        PngReader pngReader = new PngReader(instream, "png64input");
        ImageInfo imageInfo = new ImageInfo(bufferedImage.getWidth(null), bufferedImage.getHeight(null), 16, n2 > 48);
        PngWriter pngWriter = new PngWriter(outstream, imageInfo);
        pngWriter.setShouldCloseStream(false);
        pngReader.setUnpackedMode(true);
        pngWriter.copyChunksFirst(pngReader, 4);
        for (int i2 = 0; i2 < pngReader.imgInfo.rows; ++i2) {
            ImageLine imageLine = pngReader.readRowInt(i2);
            ImageLine imageLine2 = new ImageLine(imageInfo);
            int n3 = n2 == 48 ? 3 : 4;
            int n4 = 0;
            for (int i3 = 0; i3 < imageLine.getScanlineInt().length; i3 += 4) {
                imageLine2.getScanlineInt()[n4 + 0] = PngEncoder.from32argbToFormat((byte)imageLine.getScanlineInt()[i3 + 0], pixelFormat, false);
                imageLine2.getScanlineInt()[n4 + 1] = PngEncoder.from32argbToFormat((byte)imageLine.getScanlineInt()[i3 + 1], pixelFormat, false);
                imageLine2.getScanlineInt()[n4 + 2] = PngEncoder.from32argbToFormat((byte)imageLine.getScanlineInt()[i3 + 2], pixelFormat, false);
                if (n2 > 48) {
                    imageLine2.getScanlineInt()[n4 + 3] = PngEncoder.from32argbToFormat((byte)imageLine.getScanlineInt()[i3 + 3], pixelFormat, true);
                }
                imageLine2.getScanlineInt()[n4 + 0] = (int)((double)imageLine2.getScanlineInt()[n4 + 0] * 65536.0 / 256.0);
                imageLine2.getScanlineInt()[n4 + 1] = (int)((double)imageLine2.getScanlineInt()[n4 + 1] * 65536.0 / 256.0);
                imageLine2.getScanlineInt()[n4 + 2] = (int)((double)imageLine2.getScanlineInt()[n4 + 2] * 65536.0 / 256.0);
                if (n2 > 48) {
                    imageLine2.getScanlineInt()[n4 + 3] = (int)((double)imageLine2.getScanlineInt()[n4 + 3] * 65536.0 / 256.0);
                }
                n4 += n3;
            }
            pngWriter.writeRow(imageLine2, i2);
        }
        pngWriter.copyChunksLast(pngReader, 4);
        pngReader.end();
        pngWriter.end();
    }

    public static int getPixelFormatSize(int pixfmt) {
        return (pixfmt & 0xFF00) > 0 ? pixfmt >> 8 & 0xFF : 0;
    }
}

