/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj;

import com.aspose.html.internal.ms.System.Text.Encoding;
import com.aspose.html.internal.ms.core.JavaLangSystem;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.PngReader;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.PngjInputException;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.PngjOutputException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;
import javax.imageio.stream.ImageOutputStream;

public class PngHelperInternal {
    public static Encoding Latin1 = Encoding.getEncoding("ISO-8859-1");
    public static Encoding UTF8 = Encoding.getEncoding("UTF-8");
    static boolean DEBUG = false;
    private static final ThreadLocal<CRC32> a = new ThreadLocal<CRC32>(){

        @Override
        protected CRC32 initialValue() {
            return new CRC32();
        }
    };

    public static byte[] getPngIdSignature() {
        return new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    }

    public static int doubleToInt100000(double d2) {
        return (int)(d2 * 100000.0 + 0.5);
    }

    public static double intToDouble100000(int i2) {
        return (double)i2 / 100000.0;
    }

    public static int readByte(InputStream is2) {
        try {
            return is2.read();
        }
        catch (IOException iOException) {
            throw new PngjInputException("error reading byte", iOException);
        }
    }

    public static int readInt2(InputStream is2) {
        try {
            int n2 = is2.read();
            int n3 = is2.read();
            if (n2 == -1 || n3 == -1) {
                return -1;
            }
            return (n2 << 8) + n3;
        }
        catch (IOException iOException) {
            throw new PngjInputException("error reading readInt2", iOException);
        }
    }

    public static int readInt4(InputStream is2) {
        try {
            int n2 = is2.read();
            int n3 = is2.read();
            int n4 = is2.read();
            int n5 = is2.read();
            if (n2 == -1 || n3 == -1 || n4 == -1 || n5 == -1) {
                return -1;
            }
            return (n2 << 24) + (n3 << 16) + (n4 << 8) + n5;
        }
        catch (IOException iOException) {
            throw new PngjInputException("error reading readInt4", iOException);
        }
    }

    public static int readInt1fromByte(byte[] b2, int offset) {
        return b2[offset] & 0xFF;
    }

    public static int readInt2fromBytes(byte[] b2, int offset) {
        return (b2[offset] & 0xFF) << 8 | b2[offset + 1] & 0xFF;
    }

    public static int readInt4fromBytes(byte[] b2, int offset) {
        return (b2[offset] & 0xFF) << 24 | (b2[offset + 1] & 0xFF) << 16 | (b2[offset + 2] & 0xFF) << 8 | b2[offset + 3] & 0xFF;
    }

    public static void writeByte(ImageOutputStream os, byte b2) {
        try {
            os.write(b2);
        }
        catch (IOException iOException) {
            throw new PngjOutputException(iOException);
        }
    }

    public static void writeInt2(ImageOutputStream os, int n2) {
        byte[] byArray = new byte[]{(byte)(n2 >> 8 & 0xFF), (byte)(n2 & 0xFF)};
        PngHelperInternal.writeBytes(os, byArray);
    }

    public static void writeInt4(ImageOutputStream os, int n2) {
        byte[] byArray = new byte[4];
        PngHelperInternal.writeInt4tobytes(n2, byArray, 0);
        PngHelperInternal.writeBytes(os, byArray);
    }

    public static void writeInt2tobytes(int n2, byte[] b2, int offset) {
        b2[offset] = (byte)(n2 >> 8 & 0xFF);
        b2[offset + 1] = (byte)(n2 & 0xFF);
    }

    public static void writeInt4tobytes(int n2, byte[] b2, int offset) {
        b2[offset] = (byte)(n2 >> 24 & 0xFF);
        b2[offset + 1] = (byte)(n2 >> 16 & 0xFF);
        b2[offset + 2] = (byte)(n2 >> 8 & 0xFF);
        b2[offset + 3] = (byte)(n2 & 0xFF);
    }

    public static void readBytes(InputStream is2, byte[] b2, int offset, int len) {
        if (len == 0) {
            return;
        }
        try {
            int n2;
            for (int i2 = 0; i2 < len; i2 += n2) {
                n2 = is2.read(b2, offset + i2, len - i2);
                if (n2 >= 1) continue;
                throw new PngjInputException("error reading bytes, " + n2 + " !=" + len);
            }
        }
        catch (IOException iOException) {
            throw new PngjInputException("error reading", iOException);
        }
    }

    public static void skipBytes(InputStream is2, int len) {
        byte[] byArray = new byte[32768];
        try {
            int n2;
            for (int i2 = len; i2 > 0; i2 -= n2) {
                n2 = is2.read(byArray, 0, i2 > byArray.length ? byArray.length : i2);
                if (n2 >= 0) continue;
                throw new PngjInputException("error reading (skipping) : EOF");
            }
        }
        catch (IOException iOException) {
            throw new PngjInputException("error reading (skipping)", iOException);
        }
    }

    public static void writeBytes(ImageOutputStream os, byte[] b2) {
        try {
            os.write(b2);
        }
        catch (IOException iOException) {
            throw new PngjOutputException(iOException);
        }
    }

    public static void writeBytes(ImageOutputStream os, byte[] b2, int offset, int n2) {
        try {
            os.write(b2, offset, n2);
        }
        catch (IOException iOException) {
            throw new PngjOutputException(iOException);
        }
    }

    public static void logdebug(String msg) {
        if (DEBUG) {
            JavaLangSystem.out.print(msg);
        }
    }

    public static CRC32 getCRC() {
        if (a.get() == null) {
            a.set(new CRC32());
        }
        return a.get();
    }

    public static void clearCRC() {
        a.remove();
    }

    public static int filterRowNone(int r2) {
        return r2 & 0xFF;
    }

    public static int filterRowSub(int r2, int left) {
        return r2 - left & 0xFF;
    }

    public static int filterRowUp(int r2, int up) {
        return r2 - up & 0xFF;
    }

    public static int filterRowAverage(int r2, int left, int up) {
        return r2 - (left + up) / 2 & 0xFF;
    }

    public static int filterRowPaeth(int r2, int left, int up, int upleft) {
        return r2 - PngHelperInternal.filterPaethPredictor(left, up, upleft) & 0xFF;
    }

    public static int unfilterRowNone(int r2) {
        return r2 & 0xFF;
    }

    public static int unfilterRowSub(int r2, int left) {
        return r2 + left & 0xFF;
    }

    public static int unfilterRowUp(int r2, int up) {
        return r2 + up & 0xFF;
    }

    public static int unfilterRowAverage(int r2, int left, int up) {
        return r2 + (left + up) / 2 & 0xFF;
    }

    public static int unfilterRowPaeth(int r2, int left, int up, int upleft) {
        return r2 + PngHelperInternal.filterPaethPredictor(left, up, upleft) & 0xFF;
    }

    static final int filterPaethPredictor(int a2, int b2, int c2) {
        int n2;
        int n3 = a2 + b2 - c2;
        int n4 = n3 >= a2 ? n3 - a2 : a2 - n3;
        int n5 = n3 >= b2 ? n3 - b2 : b2 - n3;
        int n6 = n2 = n3 >= c2 ? n3 - c2 : c2 - n3;
        if (n4 <= n5 && n4 <= n2) {
            return a2;
        }
        if (n5 <= n2) {
            return b2;
        }
        return c2;
    }

    public static final void initCrcForTests(PngReader pngr) {
        pngr.initCrctest();
    }

    public static final long getCrctestVal(PngReader pngr) {
        return pngr.getCrctestVal();
    }
}

