/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.chunks;

import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.ImageInfo;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.PngHelperInternal;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.PngjException;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.ChunkHelper;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.ChunkRaw;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.PngChunk;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.PngChunkSingle;

public class PngChunkICCP
extends PngChunkSingle {
    public static final String ID = "iCCP";
    private String a;
    private byte[] b;
    private int c;

    public PngChunkICCP(ImageInfo info) {
        super(ID, info);
    }

    @Override
    public PngChunk.ChunkOrderingConstraint getOrderingConstraint() {
        return PngChunk.ChunkOrderingConstraint.BEFORE_PLTE_AND_IDAT;
    }

    @Override
    public ChunkRaw createRawChunk() {
        ChunkRaw chunkRaw = this.createEmptyChunk(this.a.length() + this.b.length + 2, true);
        System.arraycopy(ChunkHelper.toBytes(this.a), 0, chunkRaw.data, 0, this.a.length());
        chunkRaw.data[this.a.length()] = 0;
        chunkRaw.data[this.a.length() + 1] = 0;
        System.arraycopy(this.b, 0, chunkRaw.data, this.a.length() + 2, this.b.length);
        return chunkRaw;
    }

    @Override
    public void parseFromRaw(ChunkRaw chunk) {
        int n2 = ChunkHelper.posNullByte(chunk.data);
        this.a = PngHelperInternal.Latin1.getString(chunk.data, 0, n2);
        this.c = chunk.data[n2 + 1] & 0xFF;
        if (this.c != 0) {
            throw new PngjException("bad compression for ChunkTypeICCP");
        }
        int n3 = chunk.data.length - (n2 + 2);
        this.b = new byte[n3];
        System.arraycopy(chunk.data, n2 + 2, this.b, 0, n3);
    }

    @Override
    public void cloneDataFromRead(PngChunk other) {
        PngChunkICCP pngChunkICCP = (PngChunkICCP)other;
        this.a = pngChunkICCP.a;
        this.b = new byte[pngChunkICCP.b.length];
        System.arraycopy(pngChunkICCP.b, 0, this.b, 0, pngChunkICCP.b.length);
    }

    public void setProfileNameAndContent(String name, byte[] profile) {
        this.a = name;
        this.b = ChunkHelper.compressBytes(profile, true);
    }

    public void setProfileNameAndContent(String name, String profile) {
        this.setProfileNameAndContent(name, PngHelperInternal.Latin1.getBytes(profile));
    }

    public String getProfileName() {
        return this.a;
    }

    public byte[] getUncompressedProfile() {
        return ChunkHelper.compressBytes(this.b, false);
    }

    public byte[] getCompressedProfile() {
        return this.b;
    }

    public String getProfileAsString() {
        return PngHelperInternal.Latin1.getString(this.getUncompressedProfile());
    }

    public int getCompressionMethod() {
        return this.c;
    }
}

