/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Security.Cryptography;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.Security.Cryptography.AsymmetricAlgorithm;
import com.aspose.html.internal.ms.System.Security.Cryptography.AsymmetricSignatureDeformatter;
import com.aspose.html.internal.ms.System.Security.Cryptography.CryptographicUnexpectedOperationException;
import com.aspose.html.internal.ms.System.Security.Cryptography.HashAlgorithm;
import com.aspose.html.internal.ms.System.Security.Cryptography.RSA;
import com.aspose.html.internal.ms.core.System.Security.Cryptography.MD5SHA1;
import com.aspose.html.internal.ms.core.System.Security.Cryptography.s;
import com.aspose.html.internal.ms.lang.Operators;
import com.aspose.html.internal.ms.lang.StringSwitchMap;

public class RSASslSignatureDeformatter
extends AsymmetricSignatureDeformatter {
    private RSA a;
    private HashAlgorithm b;
    private static final StringSwitchMap c = new StringSwitchMap("MD5SHA1");

    public RSASslSignatureDeformatter() {
    }

    public RSASslSignatureDeformatter(AsymmetricAlgorithm key) {
        this.setKey(key);
    }

    @Override
    public boolean verifySignature(byte[] rgbHash, byte[] rgbSignature) {
        if (this.a == null) {
            throw new CryptographicUnexpectedOperationException("The key is a null reference");
        }
        if (this.b == null) {
            throw new CryptographicUnexpectedOperationException("The hash algorithm is a null reference.");
        }
        if (rgbHash == null) {
            throw new ArgumentNullException("The rgbHash parameter is a null reference.");
        }
        return s.a(this.a, this.b, rgbHash, rgbSignature);
    }

    @Override
    public void setHashAlgorithm(String strName) {
        switch (c.of(strName)) {
            case 0: {
                this.b = new MD5SHA1();
                break;
            }
            default: {
                this.b = HashAlgorithm.create(strName);
            }
        }
    }

    @Override
    public void setKey(AsymmetricAlgorithm key) {
        if (!Operators.is(key, RSA.class)) {
            throw new ArgumentException("Specfied key is not an RSA key");
        }
        this.a = Operators.as(key, RSA.class);
    }
}

