/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Security.Cryptography.X509Certificates;

import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.Array;
import com.aspose.html.internal.ms.System.Collections.CollectionBase;
import com.aspose.html.internal.ms.System.Collections.IEnumerable;
import com.aspose.html.internal.ms.System.Collections.IEnumerator;
import com.aspose.html.internal.ms.System.NotSupportedException;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.core.System.Security.Cryptography.ASN1;
import com.aspose.html.internal.ms.core.System.Security.Cryptography.X509Certificates.X509Extension;
import com.aspose.html.internal.ms.core.logger.Log4jLogger;
import com.aspose.html.internal.ms.lang.ReservedForInternalUse;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.Set;

public final class X509ExtensionCollection
extends CollectionBase
implements IEnumerable {
    private boolean a;

    public X509ExtensionCollection() {
    }

    public X509ExtensionCollection(ASN1 asn1) {
        this();
        this.a = true;
        if (asn1 == null) {
            return;
        }
        if (asn1.getTag() != 48) {
            throw new com.aspose.html.internal.ms.System.Exception("Invalid extensions format");
        }
        for (int i2 = 0; i2 < asn1.getCount(); ++i2) {
            X509Extension x509Extension = new X509Extension(asn1.get_Item(i2));
            this.getInnerList().addItem(x509Extension);
        }
    }

    public int getExtensions(X509Extension extension) {
        if (extension == null) {
            throw new ArgumentNullException("extension");
        }
        if (this.a) {
            throw new NotSupportedException("Extensions are read only");
        }
        return this.getInnerList().addItem(extension);
    }

    public void addRange(X509Extension[] extension) {
        if (extension == null) {
            throw new ArgumentNullException("extension");
        }
        if (this.a) {
            throw new NotSupportedException("Extensions are read only");
        }
        for (int i2 = 0; i2 < extension.length; ++i2) {
            this.getInnerList().addItem(extension[i2]);
        }
    }

    public void addRange(X509ExtensionCollection collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        if (this.a) {
            throw new NotSupportedException("Extensions are read only");
        }
        for (int i2 = 0; i2 < collection.getInnerList().size(); ++i2) {
            this.getInnerList().addItem(collection.get_Item(i2));
        }
    }

    public boolean contains(X509Extension extension) {
        return this.indexOf(extension) != -1;
    }

    public boolean contains(String oid) {
        return this.indexOf(oid) != -1;
    }

    public void copyTo(X509Extension[] extensions, int index) {
        if (extensions == null) {
            throw new ArgumentNullException("extensions");
        }
        this.getInnerList().copyTo(Array.boxing(extensions), index);
    }

    public int indexOf(X509Extension extension) {
        if (extension == null) {
            throw new ArgumentNullException("extension");
        }
        for (int i2 = 0; i2 < this.getInnerList().size(); ++i2) {
            X509Extension x509Extension = (X509Extension)this.getInnerList().get_Item(i2);
            if (!x509Extension.equals(extension)) continue;
            return i2;
        }
        return -1;
    }

    public int indexOf(String oid) {
        if (oid == null) {
            throw new ArgumentNullException("oid");
        }
        for (int i2 = 0; i2 < this.getInnerList().size(); ++i2) {
            X509Extension x509Extension = (X509Extension)this.getInnerList().get_Item(i2);
            if (!StringExtensions.equals(x509Extension.getOid(), oid)) continue;
            return i2;
        }
        return -1;
    }

    public void insert(int index, X509Extension extension) {
        if (extension == null) {
            throw new ArgumentNullException("extension");
        }
        this.getInnerList().insertItem(index, extension);
    }

    public void remove(X509Extension extension) {
        if (extension == null) {
            throw new ArgumentNullException("extension");
        }
        this.getInnerList().removeItem(extension);
    }

    public void remove(String oid) {
        if (oid == null) {
            throw new ArgumentNullException("oid");
        }
        int n2 = this.indexOf(oid);
        if (n2 != -1) {
            this.getInnerList().removeAt(n2);
        }
    }

    @Override
    @ReservedForInternalUse
    public IEnumerator iterator() {
        return this.getInnerList().iterator();
    }

    @Override
    public X509Extension get_Item(int index) {
        return (X509Extension)this.getInnerList().get_Item(index);
    }

    public X509Extension get_Item(String oid) {
        int n2 = this.indexOf(oid);
        if (n2 == -1) {
            return null;
        }
        return (X509Extension)this.getInnerList().get_Item(n2);
    }

    public byte[] getBytes() {
        if (this.getInnerList().size() < 1) {
            return null;
        }
        ASN1 aSN1 = new ASN1(48);
        for (int i2 = 0; i2 < this.getInnerList().size(); ++i2) {
            X509Extension x509Extension = (X509Extension)this.getInnerList().get_Item(i2);
            aSN1.add(x509Extension.getASN1());
        }
        return aSN1.getBytes();
    }

    public static X509ExtensionCollection fromJava(X509Certificate certificate) {
        X509ExtensionCollection x509ExtensionCollection = new X509ExtensionCollection();
        x509ExtensionCollection.addRange(X509ExtensionCollection.a(certificate, certificate.getCriticalExtensionOIDs(), true));
        x509ExtensionCollection.addRange(X509ExtensionCollection.a(certificate, certificate.getNonCriticalExtensionOIDs(), false));
        return x509ExtensionCollection;
    }

    private static X509Extension[] a(X509Certificate x509Certificate, Set<String> set, boolean bl2) {
        HashSet<X509Extension> hashSet = new HashSet<X509Extension>();
        if (set != null && !set.isEmpty()) {
            for (String string : set) {
                try {
                    if (x509Certificate.getExtensionValue(string) == null) continue;
                    hashSet.add(X509Extension.fromJava((byte[])x509Certificate.getExtensionValue(string).clone(), string, bl2));
                }
                catch (Exception exception) {
                    Log4jLogger.debug(exception.toString(), exception);
                }
            }
        }
        return hashSet.toArray(new X509Extension[0]);
    }
}

