/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.asn1;

import com.aspose.html.internal.ms.core.bc.asn1.ASN1OutputStream;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1ParsingException;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1Primitive;
import com.aspose.html.internal.ms.core.bc.asn1.StreamUtil;
import com.aspose.html.internal.ms.core.bc.util.Arrays;
import java.io.IOException;

public abstract class ASN1ApplicationSpecific
extends ASN1Primitive {
    protected final boolean isConstructed;
    protected final int tag;
    protected final byte[] octets;

    ASN1ApplicationSpecific(boolean bl2, int n2, byte[] byArray) {
        this.isConstructed = bl2;
        this.tag = n2;
        this.octets = Arrays.clone(byArray);
    }

    public static ASN1ApplicationSpecific getInstance(Object object) {
        if (object == null || object instanceof ASN1ApplicationSpecific) {
            return (ASN1ApplicationSpecific)object;
        }
        if (object instanceof byte[]) {
            try {
                return ASN1ApplicationSpecific.getInstance(ASN1Primitive.fromByteArray((byte[])object));
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("Failed to construct object from byte[]: " + iOException.getMessage());
            }
        }
        throw new IllegalArgumentException("unknown object in getInstance: " + object.getClass().getName());
    }

    protected static int getLengthOfHeader(byte[] byArray) {
        int n2 = byArray[1] & 0xFF;
        if (n2 == 128) {
            return 2;
        }
        if (n2 > 127) {
            int n3 = n2 & 0x7F;
            if (n3 > 4) {
                throw new IllegalStateException("DER length more than 4 bytes: " + n3);
            }
            return n3 + 2;
        }
        return 2;
    }

    public boolean isConstructed() {
        return this.isConstructed;
    }

    public byte[] getContents() {
        return Arrays.clone(this.octets);
    }

    public int getApplicationTag() {
        return this.tag;
    }

    public ASN1Primitive getObject() throws IOException {
        return ASN1Primitive.fromByteArray(this.getContents());
    }

    public ASN1Primitive getObject(int n2) throws IOException {
        if (n2 >= 31) {
            throw new IOException("unsupported tag number");
        }
        byte[] byArray = this.getEncoded();
        byte[] byArray2 = this.replaceTagNumber(n2, byArray);
        if ((byArray[0] & 0x20) != 0) {
            byArray2[0] = (byte)(byArray2[0] | 0x20);
        }
        return ASN1Primitive.fromByteArray(byArray2);
    }

    int encodedLength() throws IOException {
        return StreamUtil.calculateTagLength(this.tag) + StreamUtil.calculateBodyLength(this.octets.length) + this.octets.length;
    }

    void encode(ASN1OutputStream aSN1OutputStream) throws IOException {
        int n2 = 64;
        if (this.isConstructed) {
            n2 |= 0x20;
        }
        aSN1OutputStream.writeEncoded(n2, this.tag, this.octets);
    }

    boolean asn1Equals(ASN1Primitive aSN1Primitive) {
        if (!(aSN1Primitive instanceof ASN1ApplicationSpecific)) {
            return false;
        }
        ASN1ApplicationSpecific aSN1ApplicationSpecific = (ASN1ApplicationSpecific)aSN1Primitive;
        return this.isConstructed == aSN1ApplicationSpecific.isConstructed && this.tag == aSN1ApplicationSpecific.tag && Arrays.areEqual(this.octets, aSN1ApplicationSpecific.octets);
    }

    public int hashCode() {
        return (this.isConstructed ? 1 : 0) ^ this.tag ^ Arrays.hashCode(this.octets);
    }

    private byte[] replaceTagNumber(int n2, byte[] byArray) throws IOException {
        int n3 = byArray[0] & 0x1F;
        int n4 = 1;
        if (n3 == 31) {
            int n5;
            n3 = 0;
            if (((n5 = byArray[n4++] & 0xFF) & 0x7F) == 0) {
                throw new ASN1ParsingException("corrupted stream - invalid high tag number found");
            }
            while (n5 >= 0 && (n5 & 0x80) != 0) {
                n3 |= n5 & 0x7F;
                n3 <<= 7;
                n5 = byArray[n4++] & 0xFF;
            }
        }
        byte[] byArray2 = new byte[byArray.length - n4 + 1];
        System.arraycopy(byArray, n4, byArray2, 1, byArray2.length - 1);
        byArray2[0] = (byte)n2;
        return byArray2;
    }
}

