/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.cert;

import com.aspose.html.internal.ms.core.bc.asn1.ASN1OctetString;
import com.aspose.html.internal.ms.core.bc.asn1.x509.AuthorityKeyIdentifier;
import com.aspose.html.internal.ms.core.bc.asn1.x509.Extension;
import com.aspose.html.internal.ms.core.bc.asn1.x509.GeneralName;
import com.aspose.html.internal.ms.core.bc.asn1.x509.GeneralNames;
import com.aspose.html.internal.ms.core.bc.asn1.x509.SubjectKeyIdentifier;
import com.aspose.html.internal.ms.core.bc.asn1.x509.SubjectPublicKeyInfo;
import com.aspose.html.internal.ms.core.bc.cert.CertRuntimeException;
import com.aspose.html.internal.ms.core.bc.cert.X509CertificateHolder;
import com.aspose.html.internal.ms.core.bc.operator.DigestCalculator;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;

public class X509ExtensionUtils {
    private DigestCalculator calculator;

    public X509ExtensionUtils(DigestCalculator calculator) {
        this.calculator = calculator;
    }

    public AuthorityKeyIdentifier createAuthorityKeyIdentifier(X509CertificateHolder certHolder) {
        GeneralName generalName = new GeneralName(certHolder.getIssuer());
        return new AuthorityKeyIdentifier(this.getSubjectKeyIdentifier(certHolder), new GeneralNames(generalName), certHolder.getSerialNumber());
    }

    public AuthorityKeyIdentifier createAuthorityKeyIdentifier(SubjectPublicKeyInfo publicKeyInfo) {
        return new AuthorityKeyIdentifier(this.calculateIdentifier(publicKeyInfo));
    }

    public AuthorityKeyIdentifier createAuthorityKeyIdentifier(SubjectPublicKeyInfo publicKeyInfo, GeneralNames generalNames, BigInteger serial) {
        return new AuthorityKeyIdentifier(this.calculateIdentifier(publicKeyInfo), generalNames, serial);
    }

    public SubjectKeyIdentifier createSubjectKeyIdentifier(SubjectPublicKeyInfo publicKeyInfo) {
        return new SubjectKeyIdentifier(this.calculateIdentifier(publicKeyInfo));
    }

    public SubjectKeyIdentifier createTruncatedSubjectKeyIdentifier(SubjectPublicKeyInfo publicKeyInfo) {
        byte[] byArray = this.calculateIdentifier(publicKeyInfo);
        byte[] byArray2 = new byte[8];
        System.arraycopy(byArray, byArray.length - 8, byArray2, 0, byArray2.length);
        byArray2[0] = (byte)(byArray2[0] & 0xF);
        byArray2[0] = (byte)(byArray2[0] | 0x40);
        return new SubjectKeyIdentifier(byArray2);
    }

    private byte[] getSubjectKeyIdentifier(X509CertificateHolder certHolder) {
        if (certHolder.getVersionNumber() != 3) {
            return this.calculateIdentifier(certHolder.getSubjectPublicKeyInfo());
        }
        Extension extension = certHolder.getExtension(Extension.subjectKeyIdentifier);
        if (extension != null) {
            return ASN1OctetString.getInstance(extension.getParsedValue()).getOctets();
        }
        return this.calculateIdentifier(certHolder.getSubjectPublicKeyInfo());
    }

    private byte[] calculateIdentifier(SubjectPublicKeyInfo publicKeyInfo) {
        byte[] byArray = publicKeyInfo.getPublicKeyData().getBytes();
        OutputStream outputStream = this.calculator.getOutputStream();
        try {
            outputStream.write(byArray);
            outputStream.close();
        }
        catch (IOException iOException) {
            throw new CertRuntimeException("unable to calculate identifier: " + iOException.getMessage(), iOException);
        }
        return this.calculator.getDigest();
    }
}

