/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.cert.crmf;

import com.aspose.html.internal.ms.core.bc.asn1.cms.EnvelopedData;
import com.aspose.html.internal.ms.core.bc.asn1.crmf.CRMFObjectIdentifiers;
import com.aspose.html.internal.ms.core.bc.asn1.crmf.EncKeyWithID;
import com.aspose.html.internal.ms.core.bc.asn1.crmf.EncryptedKey;
import com.aspose.html.internal.ms.core.bc.asn1.crmf.PKIArchiveOptions;
import com.aspose.html.internal.ms.core.bc.asn1.pkcs.PrivateKeyInfo;
import com.aspose.html.internal.ms.core.bc.asn1.x509.GeneralName;
import com.aspose.html.internal.ms.core.bc.cert.crmf.PKIArchiveControl;
import com.aspose.html.internal.ms.core.bc.cms.CMSEnvelopedData;
import com.aspose.html.internal.ms.core.bc.cms.CMSEnvelopedDataGenerator;
import com.aspose.html.internal.ms.core.bc.cms.CMSException;
import com.aspose.html.internal.ms.core.bc.cms.CMSProcessableByteArray;
import com.aspose.html.internal.ms.core.bc.cms.RecipientInfoGenerator;
import com.aspose.html.internal.ms.core.bc.operator.OutputEncryptor;
import java.io.IOException;

public class PKIArchiveControlBuilder {
    private CMSEnvelopedDataGenerator envGen;
    private CMSProcessableByteArray keyContent;

    public PKIArchiveControlBuilder(PrivateKeyInfo privateKeyInfo, GeneralName generalName) {
        EncKeyWithID encKeyWithID = new EncKeyWithID(privateKeyInfo, generalName);
        try {
            this.keyContent = new CMSProcessableByteArray(CRMFObjectIdentifiers.id_ct_encKeyWithID, encKeyWithID.getEncoded());
        }
        catch (IOException iOException) {
            throw new IllegalStateException("unable to encode key and general name info");
        }
        this.envGen = new CMSEnvelopedDataGenerator();
    }

    public PKIArchiveControlBuilder addRecipientGenerator(RecipientInfoGenerator recipientGen) {
        this.envGen.addRecipientInfoGenerator(recipientGen);
        return this;
    }

    public PKIArchiveControl build(OutputEncryptor contentEncryptor) throws CMSException {
        CMSEnvelopedData cMSEnvelopedData = this.envGen.generate(this.keyContent, contentEncryptor);
        EnvelopedData envelopedData = EnvelopedData.getInstance(cMSEnvelopedData.toASN1Structure().getContent());
        return new PKIArchiveControl(new PKIArchiveOptions(new EncryptedKey(envelopedData)));
    }
}

