/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.cert.jcajce;

import com.aspose.html.internal.ms.core.bc.cert.X509CertificateHolder;
import com.aspose.html.internal.ms.core.bc.cert.jcajce.CertHelper;
import com.aspose.html.internal.ms.core.bc.cert.jcajce.DefaultCertHelper;
import com.aspose.html.internal.ms.core.bc.cert.jcajce.NamedCertHelper;
import com.aspose.html.internal.ms.core.bc.cert.jcajce.ProviderCertHelper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;

public class JcaX509CertificateConverter {
    private CertHelper helper = new DefaultCertHelper();

    public JcaX509CertificateConverter setProvider(Provider provider) {
        this.helper = new ProviderCertHelper(provider);
        return this;
    }

    public JcaX509CertificateConverter setProvider(String providerName) {
        this.helper = new NamedCertHelper(providerName);
        return this;
    }

    public X509Certificate getCertificate(X509CertificateHolder certHolder) throws CertificateException {
        try {
            CertificateFactory certificateFactory = this.helper.getCertificateFactory("X.509");
            return (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(certHolder.getEncoded()));
        }
        catch (IOException iOException) {
            throw new ExCertificateParsingException("exception parsing certificate: " + iOException.getMessage(), iOException);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new ExCertificateException("cannot find required provider:" + noSuchProviderException.getMessage(), noSuchProviderException);
        }
    }

    private class ExCertificateException
    extends CertificateException {
        private Throwable cause;

        public ExCertificateException(String msg, Throwable cause) {
            super(msg);
            this.cause = cause;
        }

        public Throwable getCause() {
            return this.cause;
        }
    }

    private class ExCertificateParsingException
    extends CertificateParsingException {
        private Throwable cause;

        public ExCertificateParsingException(String msg, Throwable cause) {
            super(msg);
            this.cause = cause;
        }

        public Throwable getCause() {
            return this.cause;
        }
    }
}

